/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.satellite;

import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import java.io.File;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/SatelliteSyncPluginsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSatelliteSyncPluginsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SatelliteSyncPluginsTask.kt\nai/digital/integration/server/deploy/tasks/satellite/SatelliteSyncPluginsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1863#2,2:47\n*S KotlinDebug\n*F\n+ 1 SatelliteSyncPluginsTask.kt\nai/digital/integration/server/deploy/tasks/satellite/SatelliteSyncPluginsTask\n*L\n21#1:47,2\n*E\n"})
public class SatelliteSyncPluginsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "satelliteSyncPlugins";

    public SatelliteSyncPluginsTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"downloadAndExtractSatelliteServer"};
        this.dependsOn(objectArray);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$forEach$iv = SatelliteUtil.Companion.getSatellites(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Satellite satellite = (Satellite)element$iv;
            boolean bl = false;
            if (!satellite.getSyncPlugins()) continue;
            this.getProject().getLogger().lifecycle("Synchronising plugins for satellite " + satellite.getName());
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            Object[] objectArray = new String[]{"plugins"};
            FileUtils.deleteDirectory((File)Paths.get(SatelliteUtil.Companion.getSatelliteWorkingDir(project2, satellite), (String[])objectArray).toFile());
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            String string = DeployServerUtil.Companion.getServerWorkingDir(project3);
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            objectArray = new String[]{"ext", "hotfix", "plugins"};
            FileUtil.Companion.copyDirs(string, SatelliteUtil.Companion.getSatelliteWorkingDir(project4, satellite), CollectionsKt.listOf((Object[])objectArray));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/SatelliteSyncPluginsTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

