/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.InfrastructureUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.DeployShutdownUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.tasks.server.DownloadAndExtractServerDistTask;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lai/digital/integration/server/deploy/tasks/server/StartDeployServerInstanceTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowToWriteMountedHostFolders", "", "getBinDir", "Ljava/io/File;", "server", "Lai/digital/integration/server/common/domain/Server;", "hasToBeStartedFromClasspath", "", "launch", "maybeTearDown", "runWithPreviousInstallation", "start", "Ljava/lang/Process;", "startServer", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nStartDeployServerInstanceTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartDeployServerInstanceTask.kt\nai/digital/integration/server/deploy/tasks/server/StartDeployServerInstanceTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n774#2:176\n865#2,2:177\n1863#2,2:179\n*S KotlinDebug\n*F\n+ 1 StartDeployServerInstanceTask.kt\nai/digital/integration/server/deploy/tasks/server/StartDeployServerInstanceTask\n*L\n163#1:176\n163#1:177,2\n164#1:179,2\n*E\n"})
public class StartDeployServerInstanceTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startDeployServerInstance";

    public StartDeployServerInstanceTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new String[15];
        objectArray[0] = "applicationConfigurationOverride";
        objectArray[1] = "centralConfiguration";
        objectArray[2] = "checkUILibVersions";
        objectArray[3] = "copyCliBuildArtifacts";
        objectArray[4] = "copyServerFolders";
        objectArray[5] = "copyServerBuildArtifacts";
        objectArray[6] = "serverCopyOverlays";
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        objectArray[7] = DbUtil.Companion.isDerby(project) ? "derbyStart" : "databaseStart";
        objectArray[8] = DownloadAndExtractServerDistTask.Companion.getNAME();
        objectArray[9] = "prepareDatabase";
        objectArray[10] = "prepareDeploy";
        objectArray[11] = "setLogbackLevels";
        objectArray[12] = "startMq";
        objectArray[13] = "startCache";
        objectArray[14] = "serverYamlPatch";
        final List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), (Function1)((Function1)new Function1<StartDeployServerInstanceTask, Unit>(){

            public final void invoke(StartDeployServerInstanceTask $this$closureOf) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$this$closureOf");
                Project project = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                if (DeployServerUtil.Companion.isTls(project)) {
                    dependencies.add("tlsApplicationConfigurationOverride");
                }
                Project project2 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                if (DeployServerUtil.Companion.isPekkoSecured(project2)) {
                    dependencies.add("generateSecurePekkoKeys");
                }
                Project project3 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                if (InfrastructureUtil.Companion.hasInfrastructures(project3)) {
                    dependencies.add("infrastructureStart");
                }
                Project project4 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                if (CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project4)) {
                    dependencies.add("startCentralConfigurationServer");
                }
                Object[] objectArray = new Object[]{dependencies};
                $this$closureOf.dependsOn(objectArray);
                Project project5 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
                if (!DeployServerUtil.Companion.isDockerBased(project5)) {
                    Project project6 = $this$closureOf.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
                    if (WorkerUtil.Companion.hasWorkers(project6)) {
                        objectArray = new Object[]{"startWorkers"};
                        $this$closureOf.finalizedBy(objectArray);
                    }
                    Project project7 = $this$closureOf.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
                    if (SatelliteUtil.Companion.hasSatellites(project7)) {
                        objectArray = new Object[]{"startSatellite"};
                        $this$closureOf.finalizedBy(objectArray);
                    }
                }
                objectArray = new Object[]{"importDbUnitData"};
                $this$closureOf.finalizedBy(objectArray);
                objectArray = new Object[]{"runDevOpsAsCode"};
                $this$closureOf.finalizedBy(objectArray);
                objectArray = new Object[]{"runDatasetGeneration"};
                $this$closureOf.finalizedBy(objectArray);
                objectArray = new Object[]{"runCli"};
                $this$closureOf.finalizedBy(objectArray);
            }
        })));
    }

    private final File getBinDir(Server server) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String[] stringArray = new String[]{"bin"};
        return Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project, server), stringArray).toFile();
    }

    private final void runWithPreviousInstallation(Server server) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Server previousServer = DeployServerUtil.Companion.getPreviousInstallationServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String workDir = DeployServerUtil.Companion.getServerWorkingDir(project2, previousServer);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        File logFile = Paths.get(DeployServerUtil.Companion.getLogDir(project3, server) + "/deployit.log", new String[0]).toFile();
        this.getProject().getLogger().lifecycle("Initializing Deploy with previous installation from " + workDir);
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        pairArray[1] = TuplesKt.to((Object)"environment", EnvironmentUtil.Companion.getServerEnv(project4, server));
        Object[] objectArray = new String[]{"-setup", "-previous-installation", workDir, "-force-upgrades"};
        pairArray[2] = TuplesKt.to((Object)"params", (Object)CollectionsKt.listOf((Object[])objectArray));
        File file = this.getBinDir(server);
        Intrinsics.checkNotNull((Object)file);
        pairArray[3] = TuplesKt.to((Object)"workDir", (Object)file);
        pairArray[4] = TuplesKt.to((Object)"wait", (Object)true);
        Map map = MapsKt.mapOf((Pair[])pairArray);
        Intrinsics.checkNotNullExpressionValue((Object)logFile, (String)"logFile");
        ProcessUtil.Companion.execAndCheck(map, logFile);
    }

    private final Process startServer(Server server) {
        File file;
        this.getProject().getLogger().lifecycle("Launching server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Map<String, String> environment = EnvironmentUtil.Companion.getServerEnv(project, server);
        this.getProject().getLogger().info("Starting server with environment: " + environment);
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"discardIO", (Object)(server.getStdoutFileName() == null ? 1 : 0));
        if (server.getStdoutFileName() != null) {
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            file = new File(DeployServerUtil.Companion.getLogDir(project2, server).toString() + "/" + server.getStdoutFileName());
        } else {
            file = null;
        }
        pairArray[2] = TuplesKt.to((Object)"redirectTo", (Object)file);
        pairArray[3] = TuplesKt.to((Object)"environment", environment);
        pairArray[4] = TuplesKt.to((Object)"params", (Object)CollectionsKt.listOf((Object)"-force-upgrades"));
        pairArray[5] = TuplesKt.to((Object)"workDir", (Object)this.getBinDir(server));
        Map map = MapsKt.mapOf((Pair[])pairArray);
        Process process = ProcessUtil.Companion.exec(map);
        this.getProject().getLogger().lifecycle("Launched server on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
        return process;
    }

    private final boolean hasToBeStartedFromClasspath(Server server) {
        return server.getRuntimeDirectory() != null;
    }

    private final Process start(Server server) {
        Process process;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (!DeployServerUtil.Companion.isDockerBased(project)) {
            this.maybeTearDown();
            if (this.hasToBeStartedFromClasspath(server)) {
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                process = DeployServerUtil.Companion.startServerFromClasspath(project2);
            } else {
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                if (DeployServerUtil.Companion.isPreviousInstallationServerDefined(project3)) {
                    this.runWithPreviousInstallation(server);
                }
                process = this.startServer(server);
            }
        } else {
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            DeployServerUtil.Companion.runDockerBasedInstance(project4, server);
            process = null;
        }
        return process;
    }

    private final void maybeTearDown() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DeployShutdownUtil.Companion.shutdownServer(project);
    }

    private final void allowToWriteMountedHostFolders() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DeployServerUtil.Companion.grantPermissionsToIntegrationServerFolder(project);
    }

    /*
     * Unable to fully structure code
     */
    @TaskAction
    public final void launch() {
        v0 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"project");
        $this$filter$iv = DeployServerUtil.Companion.getServers(v0);
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            server = (Server)element$iv$iv;
            $i$a$-filter-StartDeployServerInstanceTask$launch$1 = false;
            if (!server.getPreviousInstallation()) ** GOTO lbl-1000
            v1 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"project");
            if (DeployServerUtil.Companion.isDockerBased(v1)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            server = (Server)element$iv;
            $i$a$-forEach-StartDeployServerInstanceTask$launch$2 = false;
            this.getProject().getLogger().lifecycle("About to launch Deploy Server " + server.getName() + " on port " + server.getHttpPort() + ".");
            this.allowToWriteMountedHostFolders();
            process = this.start(server);
            v3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"project");
            DeployServerUtil.Companion.waitForBoot$default(DeployServerUtil.Companion, v3, process, server, false, 8, null);
            v4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"project");
            if (!DeployServerUtil.Companion.isDockerBased(v4) || !server.getPreviousInstallation()) continue;
            v5 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"project");
            DeployServerUtil.Companion.stopDockerContainer(v5, server);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/StartDeployServerInstanceTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

