/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.provision;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/provision/RunDatasetGenerationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "generateDatasets", "", "project", "Lorg/gradle/api/Project;", "server", "Lai/digital/integration/server/common/domain/Server;", "launch", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRunDatasetGenerationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunDatasetGenerationTask.kt\nai/digital/integration/server/deploy/tasks/provision/RunDatasetGenerationTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1855#2,2:58\n*S KotlinDebug\n*F\n+ 1 RunDatasetGenerationTask.kt\nai/digital/integration/server/deploy/tasks/provision/RunDatasetGenerationTask\n*L\n41#1:58,2\n*E\n"})
public class RunDatasetGenerationTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "runDatasetGeneration";

    public RunDatasetGenerationTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"startDeployIntegrationServer"};
        this.dependsOn(objectArray);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (WorkerUtil.Companion.hasWorkers(project)) {
            objectArray = new Object[]{"startWorkers"};
            this.dependsOn(objectArray);
        }
    }

    @TaskAction
    public final void launch() {
        this.getProject().getLogger().lifecycle("Running datasets generation on the Deploy server.");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.generateDatasets(project, DeployServerUtil.Companion.getServer(project2));
    }

    private final void generateDatasets(Project project, Server server) {
        Iterable $this$forEach$iv = server.getGenerateDatasets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpRequest request;
            String dataset = (String)element$iv;
            boolean bl = false;
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), "/deployit/generate/" + dataset, false, 2, null), null, null, 6, null).POST(HttpRequest.BodyPublishers.noBody()).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                project.getLogger().info("DataSet " + dataset + " created on Deploy server.");
                continue;
            }
            project.getLogger().error(response.body());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/provision/RunDatasetGenerationTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

