/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/internals/DeployServerInitializeUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DeployServerInitializeUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/internals/DeployServerInitializeUtil$Companion;", "", "()V", "createConfFile", "", "project", "Lorg/gradle/api/Project;", "server", "Lai/digital/integration/server/common/domain/Server;", "auxiliaryServer", "", "createFolders", "prepare", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nDeployServerInitializeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployServerInitializeUtil.kt\nai/digital/integration/server/deploy/internals/DeployServerInitializeUtil$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n13409#2,2:60\n*S KotlinDebug\n*F\n+ 1 DeployServerInitializeUtil.kt\nai/digital/integration/server/deploy/internals/DeployServerInitializeUtil$Companion\n*L\n12#1:60,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void createFolders(Project project, Server server) {
            void $this$forEach$iv;
            project.getLogger().lifecycle("Preparing server destination folders.");
            String[] stringArray = new String[]{"centralConfiguration", "hotfix/plugins", "hotfix/lib", "plugins"};
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void folderName = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String folderPath = DeployServerUtil.Companion.getServerWorkingDir(project, server) + "/" + (String)folderName;
                File folder = new File(folderPath);
                folder.mkdirs();
                project.getLogger().lifecycle("Folder " + folderPath + " has been created.");
            }
        }

        private final void createConfFile(Project project, Server server, boolean auxiliaryServer) {
            project.getLogger().lifecycle("Creating deployit.conf file for " + server.getName());
            File file = project.file((Object)(DeployServerUtil.Companion.getServerWorkingDir(project, server) + "/conf/deployit.conf"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"${DeploySe\u2026er)}/conf/deployit.conf\")");
            File file2 = file;
            if (!file2.getParentFile().exists()) {
                file2.getParentFile().mkdirs();
            }
            file2.createNewFile();
            if (!auxiliaryServer) {
                FilesKt.writeText$default((File)file2, (String)("http.port=" + server.getHttpPort() + "\n"), null, (int)2, null);
                FilesKt.appendText$default((File)file2, (String)("http.context.root=" + server.getContextRoot() + "\n"), null, (int)2, null);
            } else {
                FilesKt.writeText$default((File)file2, (String)"http.port=4516\n", null, (int)2, null);
                FilesKt.appendText$default((File)file2, (String)"http.context.root=/\n", null, (int)2, null);
            }
            FilesKt.appendText$default((File)file2, (String)"http.bind.address=0.0.0.0\n", null, (int)2, null);
            FilesKt.appendText$default((File)file2, (String)"server.hostname=127.0.0.1\n", null, (int)2, null);
            FilesKt.appendText$default((File)file2, (String)"threads.min=3\n", null, (int)2, null);
            FilesKt.appendText$default((File)file2, (String)"threads.max=24\n", null, (int)2, null);
            FilesKt.appendText$default((File)file2, (String)"server.hostname=127.0.0.1\n", null, (int)2, null);
            FilesKt.appendText$default((File)file2, (String)"server.port=8180\n", null, (int)2, null);
            FilesKt.appendText$default((File)file2, (String)"xl.spring.cloud.enabled=true\n", null, (int)2, null);
            if (CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project)) {
                CentralConfigurationServer cc = CentralConfigurationServerUtil.Companion.getCentralConfigurationServer(project);
                FilesKt.appendText$default((File)file2, (String)("xl.spring.cloud.uri=http://localhost:" + cc.getHttpPort() + "/centralConfiguration/\n"), null, (int)2, null);
                FilesKt.appendText$default((File)file2, (String)"xl.spring.cloud.external-config=true\n", null, (int)2, null);
            }
        }

        static /* synthetic */ void createConfFile$default(Companion companion, Project project, Server server, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            companion.createConfFile(project, server, bl);
        }

        public final void prepare(@NotNull Project project, @NotNull Server server, boolean auxiliaryServer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            project.getLogger().lifecycle("Preparing Deploy server " + server.getName() + " before launching it.");
            this.createFolders(project, server);
            this.createConfFile(project, server, auxiliaryServer);
        }

        public static /* synthetic */ void prepare$default(Companion companion, Project project, Server server, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            companion.prepare(project, server, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

