/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tasks.database;

import ai.digital.integration.server.common.util.DbUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/common/tasks/database/PrepareDatabaseTask;", "Lorg/gradle/api/DefaultTask;", "()V", "injectDbDependency", "", "project", "Lorg/gradle/api/Project;", "dbName", "", "Companion", "integration-server-gradle-plugin"})
public class PrepareDatabaseTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "prepareDatabase";

    public PrepareDatabaseTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        final String dbName = DbUtil.Companion.databaseName(project);
        this.getProject().afterEvaluate(new Action(){

            public final void execute(Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                Project project = $this$afterEvaluate.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                this.injectDbDependency(project, dbName);
            }
        });
    }

    private final void injectDbDependency(Project project, String dbName) {
        block0: {
            Configuration testCompile;
            Configuration configuration = testCompile = (Configuration)project.getConfigurations().findByName("testCompile");
            if (configuration == null) break block0;
            Configuration it = configuration;
            boolean bl = false;
            String dbDependency = DbUtil.Companion.detectDbDependencies(dbName).getDriverDependency();
            project.getLogger().debug("Test compile configuration has been found. Injecting database dependency '" + dbDependency + "' for db: '" + dbName + "'");
            project.getDependencies().add(it.getName(), (Object)dbDependency);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/tasks/database/PrepareDatabaseTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

