/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals.cluster;

import ai.digital.integration.server.common.cluster.DockerClusterHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.domain.profiles.DockerComposeProfile;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.DockerUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployDockerClusterHelper;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionCompletedEvent;
import net.jodah.failsafe.event.ExecutionScheduledEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedSupplier;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020\u0006H\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0006H\u0002J\b\u0010+\u001a\u00020\u0006H\u0002J\u0010\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0006H\u0002J\b\u0010.\u001a\u00020\rH\u0002J\u0006\u0010/\u001a\u00020\rJ\b\u00100\u001a\u000201H\u0002J \u00102\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006H\u0002J\u0010\u00104\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u00105\u001a\u00020\rH\u0002J\b\u00106\u001a\u00020\rH\u0002J\u0006\u00107\u001a\u00020\rJ\b\u00108\u001a\u00020\rH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lai/digital/integration/server/deploy/internals/cluster/DeployDockerClusterHelper;", "Lai/digital/integration/server/common/cluster/DockerClusterHelper;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "lbIp", "", "getProject", "()Lorg/gradle/api/Project;", "workerToIp", "", "", "configureRabbitMq", "", "createClusterMetadata", "createNetwork", "createServerFolders", "createWorkerFolders", "deleteMountedServerFolders", "deleteMountedWorkerFolders", "fixDockerComposeVersion", "template", "Ljava/io/File;", "getClusterPublicPort", "getClusterVersion", "getEnvironmentVariables", "", "serviceName", "getLbIp", "getMasterIp", "order", "getNumberOfServers", "getProfile", "Lai/digital/integration/server/common/domain/profiles/DockerComposeProfile;", "getResolvedXldHaDockerComposeFile", "Ljava/nio/file/Path;", "getResolvedXldHaWithWorkersDockerComposeFile", "getServerVersionedImage", "getServers", "", "Lai/digital/integration/server/common/domain/Server;", "getTemplate", "path", "getWorkerVersionedImage", "giveAllPermissionsForMountedVolume", "folderPath", "inspectIps", "launchCluster", "networkExists", "", "openDebugPort", "range", "overrideWorkerCommand", "runServers", "runWorkers", "shutdownCluster", "waitForBoot", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDeployDockerClusterHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployDockerClusterHelper.kt\nai/digital/integration/server/deploy/internals/cluster/DeployDockerClusterHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,355:1\n766#2:356\n857#2,2:357\n1855#2,2:359\n1855#2,2:361\n1855#2,2:363\n1855#2,2:365\n37#3,2:367\n37#3,2:369\n*S KotlinDebug\n*F\n+ 1 DeployDockerClusterHelper.kt\nai/digital/integration/server/deploy/internals/cluster/DeployDockerClusterHelper\n*L\n49#1:356\n49#1:357,2\n300#1:359,2\n310#1:361,2\n321#1:363,2\n331#1:365,2\n30#1:367,2\n31#1:369,2\n*E\n"})
public class DeployDockerClusterHelper
implements DockerClusterHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<Integer, String> workerToIp;
    @Nullable
    private String lbIp;
    @NotNull
    private static final String clusterMetadataPath = "deploy/cluster/cluster-metadata.properties";
    @NotNull
    private static final String dockerXldHAPath = "deploy/cluster/docker-compose-xld-ha.yaml";
    @NotNull
    private static final String dockerXldHAWithWorkersPath = "deploy/cluster/docker-compose-xld-ha-slim-workers.yaml";
    @NotNull
    private static final String rabbitMqEnabledPluginsPath = "deploy/cluster/rabbitmq/enabled_plugins";
    private static final int privateDebugPort = 4005;
    @NotNull
    private static final List<String> pluginsFolders;
    @NotNull
    private static final List<String> serverMountedVolumes;
    @NotNull
    private static final List<String> workerMountedVolumes;

    public DeployDockerClusterHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.workerToIp = new LinkedHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DockerComposeProfile getProfile() {
        return DeployExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().dockerCompose();
    }

    private final String getClusterVersion() {
        Server server = (Server)CollectionsKt.first(this.getServers());
        return server.getVersion();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Server> getServers() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(this.project).getServers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Server server = (Server)element$iv$iv;
            boolean bl = false;
            if (!(!server.getPreviousInstallation())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final int getNumberOfServers() {
        return this.getServers().size();
    }

    private final String getServerVersionedImage() {
        Server server = (Server)CollectionsKt.first(this.getServers());
        CharSequence charSequence = server.getDockerImage();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new RuntimeException("Incorrect configuration. Server should have `dockerImage` field defined.");
        }
        return server.getDockerImage() + ":" + this.getClusterVersion();
    }

    private final String getWorkerVersionedImage() {
        Worker worker = (Worker)CollectionsKt.first(WorkerUtil.Companion.getWorkers(this.project));
        CharSequence charSequence = worker.getDockerImage();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new RuntimeException("Incorrect configuration. Worker should have `dockerImage` field defined.");
        }
        return worker.getDockerImage() + ":" + this.getClusterVersion();
    }

    private final void configureRabbitMq() {
        block0: {
            InputStream dockerComposeStream2 = ((Object)((Object)configureRabbitMq.dockerComposeStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream(rabbitMqEnabledPluginsPath);
            Path resultComposeFilePath = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(this.project, "rabbitmq/enabled_plugins");
            resultComposeFilePath.getParent().toFile().mkdirs();
            InputStream inputStream = dockerComposeStream2;
            if (inputStream == null) break block0;
            InputStream it = inputStream;
            boolean bl = false;
            FileUtil.Companion.copyFile(it, resultComposeFilePath);
        }
    }

    @Override
    @NotNull
    public String getClusterPublicPort() {
        return String.valueOf(DeployServerUtil.Companion.getCluster(this.project).getPublicPort());
    }

    private final void createClusterMetadata() {
        Path path = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(this.project, clusterMetadataPath);
        Properties props = new Properties();
        ((Map)props).put("cluster.port", this.getClusterPublicPort());
        ((Map)props).put("cluster.host", this.getLbIp());
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
        PropertiesUtil.Companion.writePropertiesFile(file, props);
    }

    private final Path getResolvedXldHaDockerComposeFile() {
        File template = this.getTemplate(dockerXldHAPath);
        String serviceName = "xl-deploy-master";
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)template, (Charset)Charsets.UTF_8), (String)"{{DEPLOY_MASTER_IMAGE}}", (String)this.getServerVersionedImage(), (boolean)false, (int)4, null), (String)"{{DEPLOY_NETWORK_NAME}}", (String)"xld-network", (boolean)false, (int)4, null), (String)"{{HA_PORT}}", (String)String.valueOf(HTTPUtil.Companion.findFreePort()), (boolean)false, (int)4, null), (String)"{{INTEGRATION_SERVER_ROOT_VOLUME}}", (String)IntegrationServerUtil.Companion.getDist(this.project), (boolean)false, (int)4, null), (String)"{{DB_PORT}}", (String)String.valueOf(HTTPUtil.Companion.findFreePort()), (boolean)false, (int)4, null);
        Object object = this.getProfile().getPostgresCommand().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProfile().postgresCommand.get()");
        String string2 = StringsKt.replace$default((String)string, (String)"{{POSGRES_COMMAND}}", (String)((String)object), (boolean)false, (int)4, null);
        Object object2 = this.getProfile().getPostgresImage().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getProfile().postgresImage.get()");
        String string3 = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"{{POSTGRES_IMAGE}}", (String)((String)object2), (boolean)false, (int)4, null), (String)"{{PUBLIC_PORT}}", (String)this.getClusterPublicPort(), (boolean)false, (int)4, null);
        Object object3 = this.getProfile().getRabbitMqImage().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getProfile().rabbitMqImage.get()");
        String configuredTemplate = StringsKt.replace$default((String)string3, (String)"{{RABBIT_MQ_IMAGE}}", (String)((String)object3), (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)template, (String)configuredTemplate, null, (int)2, null);
        this.openDebugPort(template, serviceName, "4000-4049");
        Path path = template.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"template.toPath()");
        return path;
    }

    private final Path getResolvedXldHaWithWorkersDockerComposeFile() {
        File template = this.getTemplate(dockerXldHAWithWorkersPath);
        String serviceName = "xl-deploy-worker";
        String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)template, (Charset)Charsets.UTF_8), (String)"{{DEPLOY_WORKER_IMAGE}}", (String)this.getWorkerVersionedImage(), (boolean)false, (int)4, null), (String)"{{INTEGRATION_SERVER_ROOT_VOLUME}}", (String)IntegrationServerUtil.Companion.getDist(this.project), (boolean)false, (int)4, null), (String)"{{DEPLOY_NETWORK_NAME}}", (String)"xld-network", (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)template, (String)configuredTemplate, null, (int)2, null);
        this.overrideWorkerCommand(template);
        this.openDebugPort(template, serviceName, "4050-4100");
        Path path = template.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"template.toPath()");
        return path;
    }

    private final void openDebugPort(File template, String serviceName, String range) {
        if (DeployServerUtil.Companion.getCluster(this.project).getEnableDebug()) {
            List<String> variables = this.getEnvironmentVariables(template, serviceName);
            variables.add(DeployDockerClusterHelper.openDebugPort$getServiceOpts(this));
            CollectionsKt.sort(variables);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)("services." + serviceName + ".environment"), variables), TuplesKt.to((Object)("services." + serviceName + ".ports"), (Object)CollectionsKt.listOf((Object)(range + ":4005")))};
            Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
            YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, template, pairs, null, false, 12, null);
            this.fixDockerComposeVersion(template);
        }
    }

    private final List<String> getEnvironmentVariables(File template, String serviceName) {
        Object object = YamlFileUtil.Companion.readFileKey$default(YamlFileUtil.Companion, template, "services." + serviceName + ".environment", false, 4, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
        return TypeIntrinsics.asMutableList((Object)object);
    }

    private final void overrideWorkerCommand(File template) {
        Object[] objectArray = new String[]{"-api", "http://" + this.lbIp + ":5000/"};
        List commandArgs = CollectionsKt.mutableListOf((Object[])objectArray);
        int orderNum = 1;
        int n = this.getNumberOfServers();
        if (orderNum <= n) {
            while (true) {
                commandArgs.add("-master");
                commandArgs.add(this.workerToIp.get(orderNum) + ":8180");
                if (orderNum == n) break;
                ++orderNum;
            }
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"services.xl-deploy-worker.command", (Object)commandArgs)};
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, template, pairs, null, false, 12, null);
        this.fixDockerComposeVersion(template);
    }

    private final void fixDockerComposeVersion(File template) {
        String fixedTemplate = StringsKt.replace$default((String)FilesKt.readText((File)template, (Charset)Charsets.UTF_8), (String)"version: 3.4", (String)"version: \"3.4\"", (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)template, (String)fixedTemplate, null, (int)2, null);
    }

    private final File getTemplate(String path) {
        Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(this.project, path);
        File file = resultComposeFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resultComposeFilePath.toFile()");
        return file;
    }

    private final boolean networkExists() {
        Object[] objectArray = new String[]{"network", "ls", "--filter", "name=^xld-network$", "--format=\"{{ .Name }}\""};
        return !StringsKt.isBlank((CharSequence)DockerUtil.Companion.execute$default(DockerUtil.Companion, this.project, CollectionsKt.listOf((Object[])objectArray), false, false, 12, null));
    }

    private final void createNetwork() {
        if (!this.networkExists()) {
            this.project.exec((Action)createNetwork.1.INSTANCE);
        }
    }

    private final void runServers() {
        this.configureRabbitMq();
        this.createServerFolders();
        int num = this.getNumberOfServers();
        Object[] objectArray = new String[6];
        objectArray[0] = "-f";
        Intrinsics.checkNotNullExpressionValue((Object)this.getResolvedXldHaDockerComposeFile().toFile().toString(), (String)"getResolvedXldHaDockerCo\u2026ile().toFile().toString()");
        objectArray[2] = "up";
        objectArray[3] = "-d";
        objectArray[4] = "--scale";
        objectArray[5] = "xl-deploy-master=" + num;
        List args = CollectionsKt.listOf((Object[])objectArray);
        this.project.getLogger().lifecycle("Running " + num + " server(s) with a command: `docker-compose " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "`");
        DockerComposeUtil.Companion.execute$default(DockerComposeUtil.Companion, this.project, args, false, 4, null);
    }

    private final void runWorkers() {
        this.createWorkerFolders();
        String num = String.valueOf(WorkerUtil.Companion.getNumberOfWorkers(this.project));
        Object[] objectArray = new String[6];
        objectArray[0] = "-f";
        Intrinsics.checkNotNullExpressionValue((Object)this.getResolvedXldHaWithWorkersDockerComposeFile().toFile().toString(), (String)"getResolvedXldHaWithWork\u2026ile().toFile().toString()");
        objectArray[2] = "up";
        objectArray[3] = "-d";
        objectArray[4] = "--scale";
        objectArray[5] = "xl-deploy-worker=" + num;
        List args = CollectionsKt.listOf((Object[])objectArray);
        this.project.getLogger().lifecycle("Running " + num + " workers(s) with a command: `docker-compose " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "`");
        DockerComposeUtil.Companion.execute$default(DockerComposeUtil.Companion, this.project, args, false, 4, null);
    }

    private final void inspectIps() {
        int orderNum = 1;
        int n = this.getNumberOfServers();
        if (orderNum <= n) {
            while (true) {
                Integer n2 = orderNum;
                this.workerToIp.put(n2, this.getMasterIp(orderNum));
                if (orderNum == n) break;
                ++orderNum;
            }
        }
        this.lbIp = this.getLbIp();
    }

    private final String getLbIp() {
        int maxAttempts = 5;
        RetryPolicy retryPolicy2 = ((RetryPolicy)new RetryPolicy().withMaxAttempts(maxAttempts).withBackoff(1L, 30L, ChronoUnit.SECONDS).handleResult((Object)"")).onRetriesExceeded(new CheckedConsumer(this, maxAttempts){
            final /* synthetic */ DeployDockerClusterHelper this$0;
            final /* synthetic */ int $maxAttempts;
            {
                this.this$0 = $receiver;
                this.$maxAttempts = $maxAttempts;
            }

            public final void accept(ExecutionCompletedEvent<String> it) {
                this.this$0.getProject().getLogger().warn("Failed to inspect Load Balancer IP. Max retries " + this.$maxAttempts + " exceeded.");
            }
        }).onRetryScheduled(new CheckedConsumer(this){
            final /* synthetic */ DeployDockerClusterHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(ExecutionScheduledEvent<String> it) {
                this.this$0.getProject().getLogger().lifecycle("Retry scheduled {}.");
            }
        });
        return (String)Failsafe.with((Policy)((Policy)retryPolicy2), (Policy[])((Policy[])new RetryPolicy[0])).get(new CheckedSupplier(this){
            final /* synthetic */ DeployDockerClusterHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public final String get() {
                return DeployDockerClusterHelper.access$getLbIp$inspectLbIp(this.this$0);
            }
        });
    }

    private final String getMasterIp(int order) {
        try {
            return DockerUtil.Companion.inspect(this.project, "{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}", "cluster_xl-deploy-master_" + order);
        }
        catch (ExecException e) {
            return DockerUtil.Companion.inspect(this.project, "{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}", "cluster-xl-deploy-master-" + order);
        }
    }

    public final void shutdownCluster() {
        Object[] objectArray = new String[5];
        objectArray[0] = "-f";
        Intrinsics.checkNotNullExpressionValue((Object)this.getResolvedXldHaWithWorkersDockerComposeFile().toFile().toString(), (String)"getResolvedXldHaWithWork\u2026ile().toFile().toString()");
        objectArray[2] = "-f";
        Intrinsics.checkNotNullExpressionValue((Object)this.getResolvedXldHaDockerComposeFile().toFile().toString(), (String)"getResolvedXldHaDockerCo\u2026ile().toFile().toString()");
        objectArray[4] = "down";
        List args = CollectionsKt.listOf((Object[])objectArray);
        DockerComposeUtil.Companion.execute$default(DockerComposeUtil.Companion, this.project, args, false, 4, null);
        this.deleteMountedServerFolders();
        this.deleteMountedWorkerFolders();
    }

    private final void waitForBoot() {
        String url = EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(this.project, ProductName.DEPLOY, true), "/deployit/metadata/type", false, 2, null);
        Server server = DeployServerUtil.Companion.getServer(this.project);
        WaitForBootUtil.Companion.byPort$default(WaitForBootUtil.Companion, this.project, "Deploy", url, null, server.getPingRetrySleepTime(), server.getPingTotalTries(), null, 64, null);
    }

    private final void createServerFolders() {
        Iterable $this$forEach$iv = serverMountedVolumes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String folderName = (String)element$iv;
            boolean bl = false;
            String folderPath = IntegrationServerUtil.Companion.getDist(this.project) + "/xl-deploy-server/" + folderName;
            File folder = new File(folderPath);
            folder.mkdirs();
            this.giveAllPermissionsForMountedVolume(folderPath);
            this.project.getLogger().lifecycle("Folder " + folderPath + " has been created.");
        }
    }

    private final void createWorkerFolders() {
        Iterable $this$forEach$iv = workerMountedVolumes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String folderName = (String)element$iv;
            boolean bl = false;
            String folderPath = IntegrationServerUtil.Companion.getDist(this.project) + "/xl-deploy-worker/" + folderName;
            File folder = new File(folderPath);
            folder.mkdirs();
            this.giveAllPermissionsForMountedVolume(folderPath);
            this.project.getLogger().lifecycle("Folder " + folderPath + " has been created.");
        }
    }

    private final void deleteMountedServerFolders() {
        Iterable $this$forEach$iv = serverMountedVolumes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String folderName = (String)element$iv;
            boolean bl = false;
            String folderPath = IntegrationServerUtil.Companion.getDist(this.project) + "/xl-deploy-server/" + folderName;
            File folder = new File(folderPath);
            FilesKt.deleteRecursively((File)folder);
            this.project.getLogger().lifecycle("Folder " + folderPath + " has been deleted.");
        }
    }

    private final void deleteMountedWorkerFolders() {
        Iterable $this$forEach$iv = workerMountedVolumes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String folderName = (String)element$iv;
            boolean bl = false;
            String folderPath = IntegrationServerUtil.Companion.getDist(this.project) + "/xl-deploy-worker/" + folderName;
            File folder = new File(folderPath);
            FilesKt.deleteRecursively((File)folder);
            this.project.getLogger().lifecycle("Folder " + folderPath + " has been deleted.");
        }
    }

    private final void giveAllPermissionsForMountedVolume(String folderPath) {
        ProcessUtil.Companion.chMod(this.project, "777", folderPath);
    }

    public final void launchCluster() {
        this.createNetwork();
        this.runServers();
        this.inspectIps();
        this.runWorkers();
        this.createClusterMetadata();
        this.waitForBoot();
    }

    private static final String openDebugPort$getServiceOpts(DeployDockerClusterHelper this$0) {
        String suspend = DeployServerUtil.Companion.getCluster(this$0.project).getDebugSuspend() ? "y" : "n";
        return "DEPLOYIT_SERVER_OPTS=-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=*:4005";
    }

    private static final String getLbIp$inspectLbIp(DeployDockerClusterHelper this$0) {
        return DockerUtil.Companion.inspect(this$0.project, "{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}", "xl-deploy-lb");
    }

    public static final /* synthetic */ String access$getLbIp$inspectLbIp(DeployDockerClusterHelper this$0) {
        return DeployDockerClusterHelper.getLbIp$inspectLbIp(this$0);
    }

    static {
        String[] stringArray = new String[]{"plugins", "plugins/__local__", "plugins/xld-official"};
        pluginsFolders = CollectionsKt.listOf((Object[])stringArray);
        stringArray = new SpreadBuilder(2);
        stringArray.add((Object)"centralConfiguration");
        Collection $this$toTypedArray$iv = pluginsFolders;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        serverMountedVolumes = CollectionsKt.listOf((Object[])stringArray.toArray((Object[])new String[stringArray.size()]));
        stringArray = new SpreadBuilder(2);
        stringArray.add((Object)"conf");
        $this$toTypedArray$iv = pluginsFolders;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        stringArray.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        workerMountedVolumes = CollectionsKt.listOf((Object[])stringArray.toArray((Object[])new String[stringArray.size()]));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/digital/integration/server/deploy/internals/cluster/DeployDockerClusterHelper$Companion;", "", "()V", "clusterMetadataPath", "", "dockerXldHAPath", "dockerXldHAWithWorkersPath", "pluginsFolders", "", "privateDebugPort", "", "rabbitMqEnabledPluginsPath", "serverMountedVolumes", "workerMountedVolumes", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

