/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.tasks.server;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/release/tasks/server/StartReleaseServerInstanceTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowToWriteMountedHostFolders", "", "launch", "start", "Ljava/lang/Process;", "Companion", "integration-server-gradle-plugin"})
public class StartReleaseServerInstanceTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startReleaseServerInstance";

    public StartReleaseServerInstanceTask() {
        this.setGroup("Integration Server");
    }

    private final void allowToWriteMountedHostFolders() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ReleaseServerUtil.Companion.grantPermissionsToIntegrationServerFolder(project);
    }

    private final Process start() {
        this.getProject().exec(new Action(this){
            final /* synthetic */ StartReleaseServerInstanceTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                $this$exec.setExecutable("docker-compose");
                Object[] objectArray = new String[4];
                objectArray[0] = "-f";
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                Intrinsics.checkNotNullExpressionValue((Object)ReleaseServerUtil.Companion.getResolvedDockerFile(project).toFile().toString(), (String)"ReleaseServerUtil.getRes\u2026ject).toFile().toString()");
                objectArray[2] = "up";
                objectArray[3] = "-d";
                $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
            }
        });
        return null;
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Server server = ReleaseServerUtil.Companion.getServer(project);
        this.getProject().getLogger().lifecycle("About to launch Release Server on port " + server.getHttpPort() + ".");
        this.allowToWriteMountedHostFolders();
        Process process = this.start();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        ReleaseServerUtil.Companion.waitForBoot(project2, process);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/release/tasks/server/StartReleaseServerInstanceTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

