/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cache;

import ai.digital.integration.server.common.util.CacheUtil;
import com.palantir.gradle.docker.DockerComposeUp;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/common/cache/StartCacheTask;", "Lcom/palantir/gradle/docker/DockerComposeUp;", "()V", "getDescription", "", "getDockerComposeFile", "Ljava/io/File;", "run", "", "Companion", "integration-server-gradle-plugin"})
public abstract class StartCacheTask
extends DockerComposeUp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startCache";

    public StartCacheTask() {
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return CacheUtil.Companion.isCacheEnabled(project);
            }
        });
    }

    @NotNull
    public String getDescription() {
        return "Starts Cache Server using `docker-compose` and " + CacheUtil.Companion.getComposeFileRelativePath() + " file.";
    }

    @InputFiles
    @NotNull
    public File getDockerComposeFile() {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File file = project.file((Object)CacheUtil.Companion.getResolvedDockerFile(project2));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(CacheUtil.g\u2026olvedDockerFile(project))");
        return file;
    }

    @TaskAction
    public void run() {
        this.getProject().getLogger().lifecycle("Starting Cache Server.");
        this.getProject().exec(new Action(this){
            final /* synthetic */ StartCacheTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                $this$exec.setExecutable("docker-compose");
                Object[] objectArray = new String[6];
                objectArray[0] = "-f";
                objectArray[1] = this.this$0.getDockerComposeFile().getPath();
                objectArray[2] = "--project-directory";
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                objectArray[3] = CacheUtil.Companion.getBaseDirectory(project);
                objectArray[4] = "up";
                objectArray[5] = "-d";
                $this$exec.setArgs((List)CollectionsKt.arrayListOf((Object[])objectArray));
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/cache/StartCacheTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

