/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.helm;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.helm.AwsEksHelmHelper;
import ai.digital.integration.server.common.cluster.helm.AwsOpenshiftHelmHelper;
import ai.digital.integration.server.common.cluster.helm.AzureAksHelmHelper;
import ai.digital.integration.server.common.cluster.helm.GcpGkeHelmHelper;
import ai.digital.integration.server.common.cluster.helm.OnPremHelmHelper;
import ai.digital.integration.server.common.cluster.helm.VmwareOpenshiftHelmHelper;
import ai.digital.integration.server.common.constant.OperatorHelmProviderName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.profiles.IngressType;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0006\u0010\u0013\u001a\u00020\bJ\b\u0010\u0014\u001a\u00020\bH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u0006\u0010\u0018\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0016H&J\u0006\u0010\u001c\u001a\u00020\u000eJ\b\u0010\u001d\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lai/digital/integration/server/common/cluster/helm/HelmHelper;", "Lai/digital/integration/server/common/cluster/Helper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "HELM_FOLDER_NAME", "", "VALUES_HAPROXY_PATH", "VALUES_NGINX_PATH", "VALUES_PATH", "helmMetadataPath", "copyValuesYamlFile", "", "createClusterMetadata", "getContextPath", "getContextRoot", "getFqdn", "getHelmHomeDir", "getHelmReleaseName", "getHelmValuesFile", "Ljava/io/File;", "getPort", "helmCleanUpCluster", "installCluster", "updateCustomHelmValues", "valuesFile", "updateHelmDependency", "updateHelmValuesYaml", "Companion", "integration-server-gradle-plugin"})
public abstract class HelmHelper
extends Helper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String HELM_FOLDER_NAME;
    @NotNull
    private final String VALUES_NGINX_PATH;
    @NotNull
    private final String VALUES_HAPROXY_PATH;
    @NotNull
    private final String VALUES_PATH;
    @NotNull
    private final String helmMetadataPath;

    public HelmHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.HELM_FOLDER_NAME = "xl-" + this.getName() + "-kubernetes-helm-chart";
        this.VALUES_NGINX_PATH = "values-nginx.yaml";
        this.VALUES_HAPROXY_PATH = "values-haproxy.yaml";
        this.VALUES_PATH = "values.yaml";
        this.helmMetadataPath = this.getName() + "/helm/helm-metadata.properties";
    }

    @NotNull
    public final String getHelmHomeDir() {
        return ((Object)this.getProject().getBuildDir().toPath().resolve(this.HELM_FOLDER_NAME).toAbsolutePath()).toString();
    }

    public final void copyValuesYamlFile() {
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProfile().ingressType.get()");
        switch (WhenMappings.$EnumSwitchMapping$0[IngressType.valueOf((String)object).ordinal()]) {
            case 1: {
                File fileNginxValues = new File(this.getHelmHomeDir(), this.VALUES_NGINX_PATH);
                this.getProject().getLogger().lifecycle("Copying " + this.VALUES_NGINX_PATH + " file to values.yaml");
                ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "cp -f \"" + fileNginxValues + "\" \"" + this.getHelmValuesFile() + "\"", null, false, false, 0L, 26, null);
                break;
            }
            case 2: {
                File fileHaproxyValues = new File(this.getHelmHomeDir(), this.VALUES_HAPROXY_PATH);
                this.getProject().getLogger().lifecycle("Copying " + this.VALUES_HAPROXY_PATH + " file to values.yaml");
                ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "cp -f \"" + fileHaproxyValues + "\" \"" + this.getHelmValuesFile() + "\"", null, false, false, 0L, 26, null);
            }
        }
    }

    @NotNull
    public final File getHelmValuesFile() {
        return new File(this.getHelmHomeDir(), this.VALUES_PATH);
    }

    public void updateHelmValuesYaml() {
        this.getProject().getLogger().lifecycle("Updating Helm values");
        File file = this.getHelmValuesFile();
        Pair[] pairArray = new Pair[21];
        pairArray[0] = TuplesKt.to((Object)"ImageRepository", (Object)this.getServerImageRepository());
        pairArray[1] = TuplesKt.to((Object)"AdminPassword", (Object)"admin");
        pairArray[2] = TuplesKt.to((Object)"ServerImageRepository", (Object)this.getServerImageRepository());
        pairArray[3] = TuplesKt.to((Object)"ImageTag", (Object)this.getServerVersion());
        pairArray[4] = TuplesKt.to((Object)"KeystorePassphrase", (Object)this.getProvider().getKeystorePassphrase().get());
        pairArray[5] = TuplesKt.to((Object)"Persistence.StorageClass", (Object)this.getStorageClass());
        pairArray[6] = TuplesKt.to((Object)"RepositoryKeystore", (Object)this.getProvider().getRepositoryKeystore().get());
        pairArray[7] = TuplesKt.to((Object)"postgresql.image.debug", (Object)true);
        pairArray[8] = TuplesKt.to((Object)"postgresql.persistence.size", (Object)"1Gi");
        pairArray[9] = TuplesKt.to((Object)"postgresql.persistence.storageClass", (Object)this.getDbStorageClass());
        pairArray[10] = TuplesKt.to((Object)"postgresql.postgresqlMaxConnections", (Object)this.getDbConnectionCount());
        pairArray[11] = TuplesKt.to((Object)"keycloak.install", (Object)false);
        pairArray[12] = TuplesKt.to((Object)"keycloak.postgresql.persistence.size", (Object)"1Gi");
        pairArray[13] = TuplesKt.to((Object)"oidc.enabled", (Object)false);
        pairArray[14] = TuplesKt.to((Object)"rabbitmq.persistence.storageClass", (Object)this.getMqStorageClass());
        pairArray[15] = TuplesKt.to((Object)"rabbitmq.image.debug", (Object)true);
        pairArray[16] = TuplesKt.to((Object)"rabbitmq.persistence.size", (Object)"1Gi");
        pairArray[17] = TuplesKt.to((Object)"rabbitmq.replicaCount", (Object)this.getProvider().getRabbitmqReplicaCount().get());
        pairArray[18] = TuplesKt.to((Object)"rabbitmq.persistence.replicaCount", (Object)1);
        String[] stringArray = new String[]{this.getHost()};
        pairArray[19] = TuplesKt.to((Object)"route.hosts", (Object)stringArray);
        pairArray[20] = TuplesKt.to((Object)(this.getPrefixName() + "License"), (Object)this.getLicense());
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProfile().ingressType.get()");
        if (IngressType.valueOf((String)object) == IngressType.HAPROXY) {
            pairArray = new Pair[]{TuplesKt.to((Object)"haproxy-ingress.install", (Object)true), TuplesKt.to((Object)"haproxy-ingress.service.type", (Object)"LoadBalancer"), TuplesKt.to((Object)"nginx-ingress-controller.install", (Object)false)};
            pairs.putAll(MapsKt.mutableMapOf((Pair[])pairArray));
        } else {
            pairArray = new Pair[]{TuplesKt.to((Object)"nginx-ingress-controller.service.type", (Object)"LoadBalancer")};
            pairs.putAll(MapsKt.mutableMapOf((Pair[])pairArray));
        }
        switch (WhenMappings.$EnumSwitchMapping$1[this.getProductName().ordinal()]) {
            case 1: {
                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"XldMasterCount", (Object)this.getMasterCount()), TuplesKt.to((Object)"XldWorkerCount", (Object)this.getDeployWorkerCount()), TuplesKt.to((Object)"WorkerImageRepository", (Object)this.getDeployWorkerImageRepository()), TuplesKt.to((Object)"Persistence.XldMasterPvcSize", (Object)"1Gi"), TuplesKt.to((Object)"Persistence.XldWorkerPvcSize", (Object)"1Gi"), TuplesKt.to((Object)"centralConfiguration.image.repository", (Object)this.getCentralConfigImageRepository())};
                pairs.putAll(MapsKt.mutableMapOf((Pair[])pairArray2));
                break;
            }
            case 2: {
                Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"replicaCount", (Object)this.getMasterCount()), TuplesKt.to((Object)"Persistence.Size", (Object)"1Gi")};
                pairs.putAll(MapsKt.mutableMapOf((Pair[])pairArray3));
            }
        }
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 4, null);
        this.updateCustomHelmValues(file);
    }

    public final void updateHelmDependency() {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "helm dependency update \"" + this.getHelmHomeDir() + "\"", null, false, false, 0L, 30, null);
    }

    public final void installCluster() {
        this.helmCleanUpCluster();
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "helm install " + this.getHelmReleaseName() + " \"" + this.getHelmHomeDir() + "\"", null, false, false, 0L, 30, null);
    }

    public final void createClusterMetadata() {
        this.clusterMetadata(this.helmMetadataPath, this.getContextRoot());
    }

    public final void helmCleanUpCluster() {
        this.getProject().getLogger().lifecycle("Release " + this.getProvider().getHelmXldReleaseName().get() + " is being uninstalled");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "helm uninstall " + this.getProvider().getHelmXldReleaseName().get(), null, false, false, 0L, 22, null);
        this.getProject().getLogger().lifecycle("Release " + this.getProvider().getHelmXlrReleaseName().get() + " is being uninstalled");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "helm uninstall " + this.getProvider().getHelmXlrReleaseName().get(), null, false, false, 0L, 22, null);
    }

    private final String getHelmReleaseName() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$1[this.getProductName().ordinal()]) {
            case 1: {
                Object object = this.getProvider().getHelmXldReleaseName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProvider().helmXldReleaseName.get()");
                string = (String)object;
                break;
            }
            case 2: {
                Object object = this.getProvider().getHelmXlrReleaseName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProvider().helmXlrReleaseName.get()");
                string = (String)object;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public abstract void updateCustomHelmValues(@NotNull File var1);

    @NotNull
    public String getContextPath() {
        return "ingress.path";
    }

    @NotNull
    public String getContextRoot() {
        File file = this.getHelmValuesFile();
        String pathKey = this.getContextPath();
        return this.getContextRootPath(file, pathKey);
    }

    @Override
    @NotNull
    public String getPort() {
        return "80";
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getHost();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/common/cluster/helm/HelmHelper$Companion;", "", "()V", "getHelmHelper", "Lai/digital/integration/server/common/cluster/helm/HelmHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "getHelmProvider", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HelmHelper getHelmHelper(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProductName productName = ReleaseServerUtil.Companion.isReleaseServerDefined(project) ? ProductName.RELEASE : ProductName.DEPLOY;
            return this.getHelmHelper(project, productName);
        }

        @NotNull
        public final HelmHelper getHelmHelper(@NotNull Project project, @NotNull ProductName productName) {
            HelmHelper helmHelper;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
            String providerName = this.getHelmProvider(project, productName);
            if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AWS_EKS.getProviderName())) {
                helmHelper = new AwsEksHelmHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AWS_OPENSHIFT.getProviderName())) {
                helmHelper = new AwsOpenshiftHelmHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AZURE_AKS.getProviderName())) {
                helmHelper = new AzureAksHelmHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.GCP_GKE.getProviderName())) {
                helmHelper = new GcpGkeHelmHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.ON_PREMISE.getProviderName())) {
                helmHelper = new OnPremHelmHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.VMWARE_OPENSHIFT.getProviderName())) {
                helmHelper = new VmwareOpenshiftHelmHelper(project, productName);
            } else {
                throw new IllegalArgumentException("Provided helm provider name `" + providerName + "` is not supported. Choose one of " + ArraysKt.joinToString$default((Object[])OperatorHelmProviderName.values(), null, null, null, (int)0, null, null, (int)63, null));
            }
            return helmHelper;
        }

        private final String getHelmProvider(Project project, ProductName productName) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[productName.ordinal()]) {
                case 1: {
                    string = DeployClusterUtil.Companion.getHelmProvider(project);
                    break;
                }
                case 2: {
                    string = ReleaseClusterUtil.Companion.getHelmProvider(project);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProductName.values().length];
                try {
                    nArray[ProductName.DEPLOY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProductName.RELEASE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IngressType.values().length];
            try {
                nArray[IngressType.NGINX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IngressType.HAPROXY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProductName.values().length];
            try {
                nArray[ProductName.DEPLOY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProductName.RELEASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

