/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import groovy.util.FileNameByRegexFinder;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/FileUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class FileUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u000eJ\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0014J\u0016\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0006\u00a8\u0006!"}, d2={"Lai/digital/integration/server/common/util/FileUtil$Companion;", "", "()V", "copyDirs", "", "srcBaseDir", "", "targetBaseDir", "dirs", "", "copyFile", "source", "Ljava/io/InputStream;", "dest", "Ljava/nio/file/Path;", "copyFiles", "srcDir", "targetDir", "files", "findFiles", "Ljava/io/File;", "basedir", "pattern", "excludesPattern", "grantRWPermissions", "file", "pathToString", "path", "removeEmptyLines", "data", "output", "toPathString", "subDir", "integration-server-gradle-plugin"})
    public static final class Companion {
        public final void copyDirs(@NotNull String srcBaseDir, @NotNull String targetBaseDir, @NotNull List<String> dirs) {
            Intrinsics.checkParameterIsNotNull((Object)srcBaseDir, (String)"srcBaseDir");
            Intrinsics.checkParameterIsNotNull((Object)targetBaseDir, (String)"targetBaseDir");
            Intrinsics.checkParameterIsNotNull(dirs, (String)"dirs");
            Iterable $this$forEach$iv = dirs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String dir = (String)element$iv;
                boolean bl = false;
                FileUtils.copyDirectory((File)Paths.get(srcBaseDir, dir).toFile(), (File)Paths.get(targetBaseDir, dir).toFile());
            }
        }

        public final void copyFiles(@NotNull String srcDir, @NotNull String targetDir, @NotNull List<String> files) {
            Intrinsics.checkParameterIsNotNull((Object)srcDir, (String)"srcDir");
            Intrinsics.checkParameterIsNotNull((Object)targetDir, (String)"targetDir");
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String file = (String)element$iv;
                boolean bl = false;
                FileUtils.copyFileToDirectory((File)Paths.get(srcDir, file).toFile(), (File)Paths.get(targetDir, new String[0]).toFile());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void copyFile(@NotNull InputStream source, @NotNull Path dest) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
            File parentDir = dest.getParent().toFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            File destFile = dest.toFile();
            destFile.createNewFile();
            FileOutputStream os = new FileOutputStream(destFile);
            Closeable closeable = os;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl3 = false;
                int n = IOUtils.copy((InputStream)source, (OutputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @NotNull
        public final String pathToString(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return ((Object)path.toAbsolutePath()).toString();
        }

        @NotNull
        public final String toPathString(@NotNull Path path, @NotNull String subDir) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)subDir, (String)"subDir");
            Path path2 = Paths.get(this.pathToString(path), subDir);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(pathToString(path), subDir)");
            return this.pathToString(path2);
        }

        public final void grantRWPermissions(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            file.setWritable(true, false);
            file.setReadable(true, false);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> findFiles(@NotNull String basedir, @NotNull String pattern) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            List list = new FileNameByRegexFinder().getFileNames(basedir, pattern);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"FileNameByRegexFinder().\u2026leNames(basedir, pattern)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file = new File((String)it);
                collection.add(file);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> findFiles(@NotNull String basedir, @NotNull String pattern, @NotNull String excludesPattern) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)excludesPattern, (String)"excludesPattern");
            List list = new FileNameByRegexFinder().getFileNames(basedir, pattern, excludesPattern);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"FileNameByRegexFinder().\u2026pattern, excludesPattern)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file = new File((String)it);
                collection.add(file);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        public final void removeEmptyLines(@NotNull String data, @NotNull File output) {
            void $this$filterTo$iv$iv;
            boolean bl;
            CharSequence charSequence;
            String line;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            FilesKt.writeText$default((File)output, (String)"", null, (int)2, null);
            Iterable $this$map$iv = StringsKt.lines((CharSequence)data);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                charSequence = line;
                bl = false;
                void v0 = charSequence;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)v0))).toString();
                collection.add(string2);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                line = (String)element$iv$iv;
                boolean bl3 = false;
                charSequence = line;
                bl = false;
                if (!(charSequence.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line2 = (String)element$iv;
                boolean bl4 = false;
                FilesKt.appendText$default((File)output, (String)(line2 + '\n'), null, (int)2, null);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

