/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OnPremHelper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.operator.OnPremiseProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\bH\u0002J\b\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\u0006\u0010\u001c\u001a\u00020\bJ\u0006\u0010\u001d\u001a\u00020\bJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010 \u001a\u00020\bJ\u0010\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0016H\u0002J\b\u0010(\u001a\u00020\bH\u0002\u00a8\u0006)"}, d2={"Lai/digital/integration/server/common/cluster/operator/OnPremHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "createCluster", "", "name", "", "driver", "clusterNodeCpus", "Lorg/gradle/api/provider/Property;", "", "clusterNodeMemory", "kubernetesVersion", "skipExisting", "", "deleteCluster", "destroyCluster", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "getFqdn", "getMinikubeIp", "getProvider", "Lai/digital/integration/server/common/domain/providers/operator/OnPremiseProvider;", "getProviderHomePath", "installCluster", "launchCluster", "onPremClusterName", "shouldSkipExisting", "shutdownCluster", "updateContext", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "updateEtcHosts", "updateInfrastructure", "infraInfo", "validateMinikubeCli", "integration-server-gradle-plugin"})
public class OnPremHelper
extends OperatorHelper {
    public final void launchCluster() {
        OnPremiseProvider onPremiseProvider = this.getProvider();
        Object object = onPremiseProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"onPremiseProvider.name.get()");
        String name = (String)object;
        Object object2 = onPremiseProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"onPremiseProvider.skipExisting.get()");
        boolean skipExisting = (Boolean)object2;
        Object object3 = onPremiseProvider.getKubernetesVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"onPremiseProvider.kubernetesVersion.get()");
        String kubernetesVersion = (String)object3;
        Object object4 = onPremiseProvider.getDriver().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"onPremiseProvider.driver.get()");
        String driver = (String)object4;
        this.validateMinikubeCli();
        this.createCluster(name, driver, onPremiseProvider.getClusterNodeCpus(), onPremiseProvider.getClusterNodeMemory(), kubernetesVersion, skipExisting);
        this.updateContext(name);
        Object object5 = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"getProvider().cleanUpWaitTimeout.get()");
        this.cleanUpCluster((Duration)object5);
        InfrastructureInfo kubeContextInfo = this.getCurrentContextInfo();
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateInfrastructure(kubeContextInfo);
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
        this.updateEtcHosts(name);
    }

    public final void installCluster() {
        this.applyYamlFiles();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.createClusterMetadata();
        this.waitForBoot();
    }

    public final void shutdownCluster() {
        this.undeployCluster();
        this.destroyCluster();
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-onprem";
    }

    @Override
    @NotNull
    public OnPremiseProvider getProvider() {
        return this.getProfile().getOnPremise();
    }

    private final void updateInfrastructure(InfrastructureInfo infraInfo) {
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Pair[] pairArray = new Pair[4];
        String string = infraInfo.getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        String string3 = infraInfo.getTlsCert();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].tlsCert", (Object)string3);
        String string4 = infraInfo.getTlsPrivateKey();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].tlsPrivateKey", (Object)string4);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getHost() + ".digitalai-testing.com";
    }

    private final void validateMinikubeCli() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube version", null, bl, bl2, l, 36, null);
        if (!StringsKt.contains$default((CharSequence)result, (CharSequence)"minikube version", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("No minikube-cli \"minikube\" in the path. Please verify your installation");
        }
    }

    private final boolean shouldSkipExisting(String name, boolean skipExisting) {
        boolean bl;
        String clusterName = this.onPremClusterName(name);
        if (skipExisting) {
            long l = 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            String profileListResult = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile list | grep " + clusterName, null, bl2, bl3, l, 36, null);
            if (StringsKt.contains$default((CharSequence)profileListResult, (CharSequence)clusterName, (boolean)false, (int)2, null)) {
                long l2 = 0L;
                bl3 = false;
                boolean bl4 = false;
                String profileResult = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile", null, bl3, bl4, l2, 36, null);
                if (!StringsKt.contains$default((CharSequence)profileResult, (CharSequence)clusterName, (boolean)false, (int)2, null)) {
                    ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile " + clusterName, null, false, false, 0L, 52, null);
                }
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void createCluster(String name, String driver, Property<Integer> clusterNodeCpus, Property<Integer> clusterNodeMemory, String kubernetesVersion, boolean skipExisting) {
        String clusterName = this.onPremClusterName(name);
        boolean shouldSkipExisting = this.shouldSkipExisting(name, skipExisting);
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing minikube cluster: {}", new Object[]{clusterName});
        } else {
            this.getProject().getLogger().lifecycle("Create minikube cluster: {}", new Object[]{clusterName});
            String additions2 = (String)clusterNodeCpus.map((Transformer)createCluster.additions.1.INSTANCE).getOrElse((Object)"") + (String)clusterNodeMemory.map((Transformer)createCluster.additions.2.INSTANCE).getOrElse((Object)"");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube start --driver=" + driver + " --kubernetes-version \"" + kubernetesVersion + "\" -p " + clusterName + ' ' + additions2, null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube addons enable ingress -p " + clusterName, null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube addons enable ingress-dns -p " + clusterName, null, false, false, 0L, 60, null);
        }
    }

    private final void updateContext(String name) {
        String clusterName = this.onPremClusterName(name);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube update-context -p " + clusterName, null, false, false, 0L, 44, null);
    }

    private final void destroyCluster() {
        Object object = this.getProvider().getDestroyClusterOnShutdown().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().destroyClusterOnShutdown.get()");
        if (((Boolean)object).booleanValue()) {
            this.deleteCluster();
            this.getProject().getLogger().lifecycle("Current cluster context is being deleted");
            this.getKubectlHelper().deleteCurrentContext();
        }
    }

    private final void deleteCluster() {
        OnPremiseProvider onPremiseProvider = this.getProvider();
        Object object = onPremiseProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"onPremiseProvider.name.get()");
        String name = (String)object;
        String clusterName = this.onPremClusterName(name);
        this.getProject().getLogger().lifecycle("Minikube cluster is being deleted {} ", new Object[]{clusterName});
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube delete -p " + clusterName, null, false, false, 0L, 44, null);
    }

    private final void updateEtcHosts(String name) {
        File infoScriptPath = OperatorHelper.getTemplate$default(this, "operator/on-perm/info_etc_hosts.sh", null, 2, null);
        File scriptPath = OperatorHelper.getTemplate$default(this, "operator/on-perm/update_etc_hosts.sh", null, 2, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "chmod 755 \"" + infoScriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "chmod 755 \"" + scriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), '\"' + infoScriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 44, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "sudo \"" + scriptPath.getAbsolutePath() + "\" " + this.getMinikubeIp(name) + " \"" + this.getFqdn() + '\"', null, false, false, 0L, 44, null);
    }

    private final String getMinikubeIp(String name) {
        String string;
        String clusterName = this.onPremClusterName(name);
        try {
            String ip = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube -p " + clusterName + " ip", null, false, false, 0L, 52, null);
            this.getProject().getLogger().lifecycle("Get cluster IP for {}: {}", new Object[]{clusterName, ip});
        }
        catch (RuntimeException e) {
            string = null;
        }
        return string;
    }

    private final String onPremClusterName(String name) {
        return name;
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)crValuesFile, (String)"crValuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.ingress.hosts", (Object)CollectionsKt.listOf((Object)this.getFqdn())), TuplesKt.to((Object)"spec.nginx-ingress-controller.defaultBackend.podSecurityContext", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"fsGroup", (Object)1001))), TuplesKt.to((Object)"spec.nginx-ingress-controller.podSecurityContext", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"fsGroup", (Object)1001)))});
        YamlFileUtil.Companion.overlayFile(crValuesFile, pairs, false);
    }

    @Override
    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        return KubeCtlHelper.getCurrentContextInfo$default(this.getKubectlHelper(), false, 1, null);
    }

    public OnPremHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
    }
}

