/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.util;

import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.cluster.util.OperatorUtil$WhenMappings;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lai/digital/integration/server/common/cluster/util/OperatorUtil;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "getProductName", "()Lai/digital/integration/server/common/constant/ProductName;", "getProject", "()Lorg/gradle/api/Project;", "getOperatorServer", "Lai/digital/integration/server/common/domain/Server;", "getServers", "Lorg/gradle/api/NamedDomainObjectContainer;", "grantPermissionsToIntegrationServerFolder", "", "isClusterEnabled", "", "isDockerBased", "readConfProperty", "", "key", "waitForBoot", "server", "integration-server-gradle-plugin"})
public final class OperatorUtil {
    @NotNull
    private final ProductName productName;
    @NotNull
    private final Project project;

    @NotNull
    public final ProductName getProductName() {
        return this.productName;
    }

    public final boolean isClusterEnabled() {
        boolean bl;
        switch (OperatorUtil$WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1: {
                bl = DeployServerUtil.Companion.isClusterEnabled(this.project);
                break;
            }
            case 2: {
                bl = ReleaseServerUtil.Companion.isClusterEnabled(this.project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final NamedDomainObjectContainer<Server> getServers() {
        NamedDomainObjectContainer<Server> namedDomainObjectContainer;
        switch (OperatorUtil$WhenMappings.$EnumSwitchMapping$1[this.productName.ordinal()]) {
            case 1: {
                namedDomainObjectContainer = DeployExtensionUtil.Companion.getExtension(this.project).getServers();
                break;
            }
            case 2: {
                namedDomainObjectContainer = ReleaseExtensionUtil.Companion.getExtension(this.project).getServers();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return namedDomainObjectContainer;
    }

    @NotNull
    public final Server getOperatorServer() {
        String string;
        Property<Server> property;
        NamedDomainObjectContainer<Server> namedDomainObjectContainer;
        switch (OperatorUtil$WhenMappings.$EnumSwitchMapping$2[this.productName.ordinal()]) {
            case 1: {
                namedDomainObjectContainer = DeployExtensionUtil.Companion.getExtension(this.project).getServers();
                break;
            }
            case 2: {
                namedDomainObjectContainer = ReleaseExtensionUtil.Companion.getExtension(this.project).getServers();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        NamedDomainObjectContainer<Server> servers = namedDomainObjectContainer;
        switch (OperatorUtil$WhenMappings.$EnumSwitchMapping$3[this.productName.ordinal()]) {
            case 1: {
                property = DeployExtensionUtil.Companion.getExtension(this.project).getOperatorServer();
                break;
            }
            case 2: {
                property = ReleaseExtensionUtil.Companion.getExtension(this.project).getOperatorServer();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object object = property.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"when (productName) {\n   \u2026torServer\n        }.get()");
        Server opServerConfig = (Server)object;
        getOperatorServer.1 $fun$findServer$1 = getOperatorServer.1.INSTANCE;
        Server server = $fun$findServer$1.invoke(servers);
        Server operatorServer = new Server("operatorServer");
        operatorServer.setHttpPort(opServerConfig.getHttpPort());
        File file = DeployServerUtil.Companion.getResolvedDockerFile(this.project, server).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"DeployServerUtil.getReso\u2026project, server).toFile()");
        if (file.isFile()) {
            Integer httpPort;
            Integer n = httpPort = DeployServerUtil.Companion.getDockerContainerPort(this.project, server, 4516);
            if (n != null) {
                Integer n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                operatorServer.setHttpPort(httpPort);
            }
        }
        if ((string = opServerConfig.getDockerImage()) == null) {
            string = server.getDockerImage();
        }
        operatorServer.setDockerImage(string);
        String string2 = opServerConfig.getVersion();
        if (string2 == null) {
            string2 = server.getVersion();
        }
        operatorServer.setVersion(string2);
        operatorServer.setPingRetrySleepTime(opServerConfig.getPingRetrySleepTime());
        operatorServer.setPingTotalTries(opServerConfig.getPingTotalTries());
        operatorServer.setRuntimeDirectory(null);
        return operatorServer;
    }

    public final void grantPermissionsToIntegrationServerFolder() {
        String workDir = IntegrationServerUtil.Companion.getDist(this.project);
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)new File(workDir), null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            FileUtil.Companion.grantRWPermissions(it);
        }
    }

    public final boolean isDockerBased() {
        return !DeployServerUtil.Companion.isDockerBased(this.getOperatorServer());
    }

    public final void waitForBoot(@NotNull Server server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Function1<LocalDateTime, LocalDateTime> $fun$saveLogs$1 = new Function1<LocalDateTime, LocalDateTime>(this, server){
            final /* synthetic */ OperatorUtil this$0;
            final /* synthetic */ Server $server;

            @NotNull
            public final LocalDateTime invoke(@NotNull LocalDateTime lastUpdate) {
                Intrinsics.checkParameterIsNotNull((Object)lastUpdate, (String)"lastUpdate");
                String string = ProductName.DEPLOY.toString();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String name = string3;
                DeployServerUtil.Companion.saveServerLogsToFile(this.this$0.getProject(), this.$server, name + '-' + this.$server.getVersion(), lastUpdate);
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
                return localDateTime;
            }
            {
                this.this$0 = operatorUtil;
                this.$server = server;
                super(1);
            }
        };
        String url = new EntryPointUrlUtil(this.project, ProductName.DEPLOY, true).composeUrl("/deployit/metadata/type", true);
        LocalDateTime lastLogUpdate2 = WaitForBootUtil.Companion.byPort(this.project, "Deploy", url, null, server.getPingRetrySleepTime(), server.getPingTotalTries(), (Function1<? super LocalDateTime, LocalDateTime>)((Function1)new Function1<LocalDateTime, LocalDateTime>($fun$saveLogs$1){
            final /* synthetic */ waitForBoot.1 $saveLogs$1;

            @NotNull
            public final LocalDateTime invoke(@NotNull LocalDateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$saveLogs$1.invoke(it);
            }
            {
                this.$saveLogs$1 = var1_1;
                super(1);
            }
        }));
        $fun$saveLogs$1.invoke(lastLogUpdate2);
    }

    @NotNull
    public final String readConfProperty(@NotNull String key) {
        File deployitConf;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String workdir = DeployServerUtil.Companion.getServerWorkingDir(this.project, this.getOperatorServer());
        File file = deployitConf = Paths.get(workdir + "/conf/deployit.conf", new String[0]).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"deployitConf");
        return PropertiesUtil.Companion.readProperty(file, key);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public OperatorUtil(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.productName = DeployExtensionUtil.Companion.getExtension(this.project).getServers().size() > 0 ? ProductName.DEPLOY : ProductName.RELEASE;
    }
}

