/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.centralConfiguration;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/StartCentralConfigurationServerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "waitForBoot", "project", "Lorg/gradle/api/Project;", "process", "Ljava/lang/Process;", "centralConfigurationServer", "Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;", "Companion", "integration-server-gradle-plugin"})
public class StartCentralConfigurationServerTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "startCentralConfigurationServer";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void launch() {
        File file;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        CentralConfigurationServer centralConfigServer = CentralConfigurationServerUtil.Companion.getCentralConfigurationServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        File binDir = CentralConfigurationServerUtil.Companion.getBinDir(project2, centralConfigServer);
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        project3.getLogger().lifecycle("Launching central configuration server from '" + binDir + "'.");
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        Map<String, String> environment = EnvironmentUtil.Companion.getEnv(project4, "JDK_JAVA_OPTIONS", centralConfigServer.getDebugSuspend(), centralConfigServer.getDebugPort(), CentralConfigurationServerUtil.Companion.logFileName());
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        project5.getLogger().info("Starting central configuration server with environment: " + environment);
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"environment", environment);
        pairArray[2] = TuplesKt.to((Object)"workDir", (Object)binDir);
        CharSequence charSequence = centralConfigServer.getStdoutFileName();
        boolean bl = false;
        boolean bl2 = false;
        pairArray[3] = TuplesKt.to((Object)"discardIO", (Object)(charSequence == null || charSequence.length() == 0 ? 1 : 0));
        charSequence = centralConfigServer.getStdoutFileName();
        bl = false;
        bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            StringBuilder stringBuilder = new StringBuilder();
            Project project6 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
            file = new File(stringBuilder.append(CentralConfigurationServerUtil.Companion.getLogDir(project6, centralConfigServer)).append('/').append(centralConfigServer.getStdoutFileName()).toString());
        } else {
            file = null;
        }
        pairArray[4] = TuplesKt.to((Object)"redirectTo", (Object)file);
        Process process = ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        Logger logger = project7.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Central Configuration Server '").append(centralConfigServer.getVersion()).append("' successfully started on PID [").append(process.pid()).append("] with command [").append(process.info().commandLine().orElse("")).append("] on port ");
        Project project8 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
        logger.lifecycle(stringBuilder.append(CentralConfigurationServerUtil.Companion.readDeployitConfProperty(project8, "http.port")).toString());
        Project project9 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project9, (String)"project");
        this.waitForBoot(project9, process, centralConfigServer);
    }

    public final void waitForBoot(@NotNull Project project, @NotNull Process process, @NotNull CentralConfigurationServer centralConfigurationServer) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)centralConfigurationServer, (String)"centralConfigurationServer");
        Server server = DeployServerUtil.Companion.getServer(project);
        File file = project.file((Object)(CentralConfigurationServerUtil.Companion.getServerPath(project, centralConfigurationServer) + "/log/" + CentralConfigurationServerUtil.Companion.logFileName() + ".log"));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(\"${CentralC\u2026Util.logFileName()}.log\")");
        File ccLog = file;
        WaitForBootUtil.Companion.byLog(project, "Central Config Server " + centralConfigurationServer.getVersion(), ccLog, "Started ConfigServerApplication.", process, server.getPingRetrySleepTime(), server.getPingTotalTries());
    }

    public StartCentralConfigurationServerTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{"downloadAndExtractCentralConfigurationServer"});
        this.dependsOn(new Object[]{"prepareCentralConfigurationServer"});
        this.dependsOn(new Object[]{"centralConfigurationServerOverlays"});
        this.dependsOn(new Object[]{"centralConfigurationServerYamlPatch"});
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project);
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/StartCentralConfigurationServerTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

