/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.centralConfiguration;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\u0004H\u0007J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/PrepareCentralConfigurationServerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "copyCentralConfigurationDir", "", "project", "Lorg/gradle/api/Project;", "server", "Lai/digital/integration/server/common/domain/Server;", "cc", "Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;", "createConfFile", "launch", "prepare", "Companion", "integration-server-gradle-plugin"})
public class PrepareCentralConfigurationServerTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "prepareCentralConfigurationServer";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.prepare(project);
    }

    public final void prepare(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        CentralConfigurationServer cc = CentralConfigurationServerUtil.Companion.getCentralConfigurationServer(project);
        Server server = DeployServerUtil.Companion.getServer(project);
        project.getLogger().lifecycle("Preparing central configuration server " + cc.getVersion() + " before launching it.");
        this.createConfFile(project, cc);
        this.copyCentralConfigurationDir(project, server, cc);
    }

    private final void copyCentralConfigurationDir(Project project, Server server, CentralConfigurationServer cc) {
        project.getLogger().lifecycle("Copying centralConfiguration directory from " + server.getName() + " to central configuration server");
        File sourceDir = Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project), "centralConfiguration").toFile();
        File destinationDir = Paths.get(((Object)CentralConfigurationServerUtil.Companion.getServerPath(project, cc)).toString(), "centralConfiguration").toFile();
        FileUtils.copyDirectory((File)sourceDir, (File)destinationDir);
    }

    private final void createConfFile(Project project, CentralConfigurationServer cc) {
        project.getLogger().lifecycle("Creating deployit.conf file for central configuration server");
        File file = project.file((Object)(CentralConfigurationServerUtil.Companion.getServerPath(project, cc) + "/conf/deployit.conf"));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(\"${CentralC\u2026cc)}/conf/deployit.conf\")");
        File file2 = file;
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        file2.createNewFile();
        FilesKt.appendText$default((File)file2, (String)("http.port=" + cc.getHttpPort() + '\n'), null, (int)2, null);
        FilesKt.appendText$default((File)file2, (String)"xl.spring.cloud.encrypt.key=MQle?8_pwB^>f<&\n", null, (int)2, null);
    }

    public PrepareCentralConfigurationServerTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (DeployServerUtil.Companion.isDeployServerDefined(project)) {
            this.dependsOn(new Object[]{"serverYamlPatch"});
        }
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project);
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/PrepareCentralConfigurationServerTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

