/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.AwsOpenshiftHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.providers.AwsOpenshiftProvider;
import ai.digital.integration.server.common.util.HtmlUtil;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eJ\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\fH\u0002J\u0006\u0010'\u001a\u00020\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lai/digital/integration/server/common/cluster/operator/AwsOpenshiftOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "awsOpenshiftHelper", "Lai/digital/integration/server/common/cluster/setup/AwsOpenshiftHelper;", "getAwsOpenshiftHelper", "()Lai/digital/integration/server/common/cluster/setup/AwsOpenshiftHelper;", "getCrName", "", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "getMasterPodName", "position", "", "getOcApiServerToken", "getPostgresPodName", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsOpenshiftProvider;", "getProviderCrContextPath", "getProviderHomePath", "getRabbitMqPodName", "getStorageClass", "getWorkerPodName", "hasIngress", "", "installCluster", "", "launchCluster", "shutdownCluster", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "updateInfrastructure", "apiServerURL", "token", "updateOperator", "integration-server-gradle-plugin"})
public class AwsOpenshiftOperatorHelper
extends OperatorHelper {
    @NotNull
    private final AwsOpenshiftHelper awsOpenshiftHelper;

    @NotNull
    public final AwsOpenshiftHelper getAwsOpenshiftHelper() {
        return this.awsOpenshiftHelper;
    }

    public final void launchCluster() {
        this.awsOpenshiftHelper.launchCluster();
    }

    public final void updateOperator() {
        this.awsOpenshiftHelper.ocLogin();
        Object object = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().cleanUpWaitTimeout.get()");
        this.cleanUpCluster((Duration)object);
        this.updateInfrastructure(this.awsOpenshiftHelper.getApiServerUrl(), this.getOcApiServerToken());
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        this.turnOnLogging();
        this.awsOpenshiftHelper.ocLogin();
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProfile().ingressType.get()");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProfile().deploymentTimeoutSeconds.get()");
        Helper.waitForDeployment$default(this, string, ((Number)object2).intValue(), false, 4, null);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForWorkerPods(((Number)object4).intValue());
        this.createClusterMetadata();
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
        this.turnOffLogging();
    }

    public final void shutdownCluster() {
        this.awsOpenshiftHelper.ocLogin();
        this.undeployCluster();
        this.awsOpenshiftHelper.ocLogout();
    }

    @NotNull
    public final String getOcApiServerToken() {
        Base64.Encoder encoder = Base64.getEncoder();
        String string = "" + this.awsOpenshiftHelper.getOcLogin() + ':' + this.awsOpenshiftHelper.getOcPassword();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String basicAuthToken = encoder.encodeToString(byArray);
        Object object = this.getProvider().getOauthHostName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().oauthHostName.get()");
        String oauthHostName = (String)object;
        this.awsOpenshiftHelper.ocLogout();
        String command1Output = this.exec("curl -vvv -L -k -c cookie -b cookie  -H \"Authorization: Basic " + basicAuthToken + "\" https://" + oauthHostName + "/oauth/token/request");
        Document doc1 = HtmlUtil.Companion.htmlToDocument(command1Output);
        String string3 = doc1.select("form input[name=\"code\"]").val();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"doc1.select(\"form input[name=\\\"code\\\"]\").`val`()");
        String code = string3;
        String string4 = doc1.select("form input[name=\"csrf\"]").val();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"doc1.select(\"form input[name=\\\"csrf\\\"]\").`val`()");
        String csrf = string4;
        String command2Output = this.exec("curl -vvv -L -k -c cookie -b cookie -d 'code=" + code + "&csrf=" + csrf + "' -H \"Authorization: Basic " + basicAuthToken + "\" https://" + oauthHostName + "/oauth/token/display");
        Document doc2 = HtmlUtil.Companion.htmlToDocument(command2Output);
        String string5 = doc2.select("code").text();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"doc2.select(\"code\").text()");
        return string5;
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-openshift";
    }

    @Override
    @NotNull
    public AwsOpenshiftProvider getProvider() {
        return this.getProfile().getAwsOpenshift();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return this.awsOpenshiftHelper.getStorageClass();
    }

    private final void updateInfrastructure(String apiServerURL, String token) {
        this.getProject().getLogger().lifecycle("Updating operator's infrastructure");
        super.updateInfrastructure();
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec[0].children[0].serverUrl", (Object)apiServerURL), TuplesKt.to((Object)"spec[0].children[0].openshiftToken", (Object)token)});
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)crValuesFile, (String)"crValuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.route.hosts", (Object)new String[]{this.getHost()}), TuplesKt.to((Object)"spec.keycloak.route.host", (Object)("keycloak-" + this.getHost()))});
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, crValuesFile, pairs, null, false, 4, null);
    }

    @Override
    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.getProject(), this.getNamespace(), true);
    }

    @Override
    public boolean hasIngress() {
        return false;
    }

    @Override
    @NotNull
    public String getCrName() {
        String string;
        block3: {
            block2: {
                string = this.getNamespace();
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = '-' + it;
                if (string != null) break block3;
            }
            string = "";
        }
        String operatorNamespace = string;
        return "dai-ocp-" + this.getPrefixName() + operatorNamespace;
    }

    @Override
    @NotNull
    public String getWorkerPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-ocp-worker-" + position;
    }

    @Override
    @NotNull
    public String getMasterPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-ocp-" + this.getMasterPodNameSuffix(position);
    }

    @Override
    @NotNull
    public String getPostgresPodName(int position) {
        return "pod/" + this.getCrName() + "-postgresql-" + position;
    }

    @Override
    @NotNull
    public String getRabbitMqPodName(int position) {
        return "pod/" + this.getCrName() + "-rabbitmq-" + position;
    }

    @Override
    @NotNull
    public String getProviderCrContextPath() {
        return "spec.route.path";
    }

    public AwsOpenshiftOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.awsOpenshiftHelper = new AwsOpenshiftHelper(project, productName, this.getProfile());
    }
}

