/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.setup;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.setup.AzureAksHelper;
import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.profiles.HelmProfile;
import ai.digital.integration.server.common.domain.profiles.OperatorProfile;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.AzureAksProvider;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0002JB\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0002J \u0010\u001f\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J&\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\b\u0010%\u001a\u00020\fH\u0016J\b\u0010&\u001a\u00020\fH\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\fH\u0016J\u0006\u0010*\u001a\u00020\u000fJ\u001c\u0010+\u001a\u00020\u000f2\b\u0010,\u001a\u0004\u0018\u00010\f2\b\u0010-\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010.\u001a\u00020\u000f2\b\u0010,\u001a\u0004\u0018\u00010\f2\b\u0010-\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\b\u0010/\u001a\u00020\u000fH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00060"}, d2={"Lai/digital/integration/server/common/cluster/setup/AzureAksHelper;", "Lai/digital/integration/server/common/cluster/Helper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "profile", "Lai/digital/integration/server/common/domain/profiles/Profile;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;Lai/digital/integration/server/common/domain/profiles/Profile;)V", "getProfile", "()Lai/digital/integration/server/common/domain/profiles/Profile;", "aksClusterName", "", "name", "connectToCluster", "", "createCluster", "clusterNodeCount", "Lorg/gradle/api/provider/Property;", "", "clusterNodeVmSize", "kubernetesVersion", "skipExisting", "", "createResourceGroup", "location", "createStorageClass", "resourceGroupName", "createStorageClassFromFile", "storageClassName", "filePath", "deleteResourceGroup", "groupName", "destroyClusterOnShutdown", "existsResourceGroup", "diskStorageClassName", "fileStorageClassName", "getDbStorageClass", "getFqdn", "getProvider", "Lai/digital/integration/server/common/domain/providers/AzureAksProvider;", "getStorageClass", "launchCluster", "loginAzCli", "username", "password", "logoutAzCli", "validateAzCli", "integration-server-gradle-plugin"})
public class AzureAksHelper
extends Helper {
    @NotNull
    private final Profile profile;

    @Override
    @NotNull
    public AzureAksProvider getProvider() {
        AzureAksProvider azureAksProvider;
        String profileName = this.getProfileName();
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            Profile profile = this.profile;
            if (profile == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.OperatorProfile");
            }
            OperatorProfile operatorProfile = (OperatorProfile)profile;
            azureAksProvider = operatorProfile.getAzureAks();
        } else if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.HELM.getProfileName())) {
            Profile profile = this.profile;
            if (profile == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.HelmProfile");
            }
            HelmProfile helmProfile = (HelmProfile)profile;
            azureAksProvider = helmProfile.getAzureAks();
        } else {
            throw (Throwable)new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported");
        }
        return azureAksProvider;
    }

    public final void launchCluster() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.name.get()");
        String name = (String)object;
        Object object2 = azureAksProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"azureAksProvider.skipExisting.get()");
        boolean skipExisting = (Boolean)object2;
        Object object3 = azureAksProvider.getLocation().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"azureAksProvider.location.get()");
        String location = (String)object3;
        this.validateAzCli();
        this.loginAzCli(azureAksProvider.getAzUsername(), azureAksProvider.getAzPassword());
        this.createResourceGroup(name, location, skipExisting);
        this.createCluster(name, azureAksProvider.getClusterNodeCount(), azureAksProvider.getClusterNodeVmSize(), azureAksProvider.getKubernetesVersion(), skipExisting);
        this.connectToCluster(name);
        String string = this.resourceGroupName(name);
        Object object4 = azureAksProvider.getStorageClass().getOrElse((Object)name);
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"azureAksProvider.storageClass.getOrElse(name)");
        this.createStorageClass(string, (String)object4);
    }

    private final void validateAzCli() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az -v", null, bl, bl2, l, 36, null);
        if (!StringsKt.contains$default((CharSequence)result, (CharSequence)"azure-cli", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("No azure-cli \"az\" in the path. Please verify your installation");
        }
    }

    private final void loginAzCli(String username, String password) {
        if (username != null && password != null) {
            this.getProject().getLogger().lifecycle("Login user");
            long l = 0L;
            boolean bl = false;
            boolean bl2 = false;
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az login -u " + username + " -p " + password, null, bl, bl2, l, 36, null);
        }
    }

    private final void createStorageClass(String resourceGroupName, String name) {
        String fileStorageClassName = this.fileStorageClassName(name);
        this.createStorageClassFromFile(resourceGroupName, fileStorageClassName, "operator/azure-aks/azure-file-sc.yaml");
        String diskStorageClassName = this.diskStorageClassName(name);
        this.createStorageClassFromFile(resourceGroupName, diskStorageClassName, "operator/azure-aks/azure-disk-sc.yaml");
        this.getKubectlHelper().setDefaultStorageClass(fileStorageClassName);
    }

    private final String diskStorageClassName(String name) {
        return name + "-disk-storage-class";
    }

    private final String fileStorageClassName(String name) {
        return name + "-file-storage-class";
    }

    private final void createStorageClassFromFile(String resourceGroupName, String storageClassName, String filePath) {
        if (!this.getKubectlHelper().hasStorageClass(storageClassName)) {
            this.getProject().getLogger().lifecycle("Create storage class: {}", new Object[]{storageClassName});
            File azureFileScTemplateFile = Helper.getTemplate$default(this, filePath, null, 2, null);
            String azureFileScTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)azureFileScTemplateFile, (Charset)Charsets.UTF_8), (String)"{{NAME}}", (String)storageClassName, (boolean)false, (int)4, null), (String)"{{RESOURCE_GROUP}}", (String)resourceGroupName, (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)azureFileScTemplateFile, (String)azureFileScTemplate, null, (int)2, null);
            this.getKubectlHelper().applyFile(azureFileScTemplateFile);
        } else {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing storage class: {}", new Object[]{storageClassName});
        }
    }

    private final void createCluster(String name, Property<Integer> clusterNodeCount, Property<String> clusterNodeVmSize, Property<String> kubernetesVersion, boolean skipExisting) {
        boolean shouldSkipExisting;
        boolean bl;
        String groupName = this.resourceGroupName(name);
        String clusterName = this.aksClusterName(name);
        if (skipExisting) {
            long l = 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az aks list --output tsv | grep " + clusterName, null, bl2, bl3, l, 36, null);
            bl = StringsKt.contains$default((CharSequence)result, (CharSequence)clusterName, (boolean)false, (int)2, null);
        } else {
            bl = shouldSkipExisting = false;
        }
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing AKS cluster: {}", new Object[]{clusterName});
        } else {
            this.getProject().getLogger().lifecycle("Create AKS cluster: {}", new Object[]{clusterName});
            String additions2 = (String)clusterNodeVmSize.map((Transformer)createCluster.additions.1.INSTANCE).getOrElse((Object)"") + (String)kubernetesVersion.map((Transformer)createCluster.additions.2.INSTANCE).getOrElse((Object)"");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az aks create --resource-group " + groupName + " --name " + clusterName + " --node-count " + (Integer)clusterNodeCount.getOrElse((Object)2) + ' ' + "--generate-ssh-keys --enable-addons monitoring " + additions2, null, false, false, 0L, 60, null);
        }
    }

    private final void connectToCluster(String name) {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az aks get-credentials --resource-group " + this.resourceGroupName(name) + " --name " + this.aksClusterName(name) + " --overwrite-existing", null, false, false, 0L, 60, null);
    }

    private final void createResourceGroup(String name, String location, boolean skipExisting) {
        boolean shouldSkipExisting;
        String groupName = this.resourceGroupName(name);
        boolean bl = shouldSkipExisting = skipExisting ? this.existsResourceGroup(groupName, location) : false;
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing resource group: {}", new Object[]{groupName});
        } else {
            this.getProject().getLogger().lifecycle("Create resource group: {}", new Object[]{groupName});
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az group create --name " + groupName + " --location " + location, null, false, false, 0L, 60, null);
        }
    }

    @NotNull
    public final String resourceGroupName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return name + "-group";
    }

    public final boolean existsResourceGroup(@NotNull String groupName, @NotNull String location) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az group list --query \"[?location=='" + location + "']\" --output tsv | grep " + groupName, null, bl, bl2, l, 36, null);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)groupName, (boolean)false, (int)2, null);
    }

    private final String aksClusterName(String name) {
        return name;
    }

    private final void deleteResourceGroup(String name, String groupName, String location) {
        String clusterName = this.aksClusterName(name);
        this.getProject().getLogger().lifecycle("Delete resource group {} and AKS cluster {} ", new Object[]{groupName, clusterName});
        if (this.existsResourceGroup(groupName, location)) {
            this.getProject().getLogger().lifecycle("Delete resource group: {}", new Object[]{groupName});
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az group delete --name " + groupName + " --yes", null, false, false, 0L, 60, null);
        } else {
            this.getProject().getLogger().lifecycle("Skipping delete of the resource group: {}", new Object[]{groupName});
        }
    }

    private final void logoutAzCli(String username, String password) {
        if (username != null && password != null) {
            this.getProject().getLogger().lifecycle("Logout user");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az logout", null, false, false, 0L, 44, null);
        }
    }

    public final void destroyClusterOnShutdown(boolean existsResourceGroup, @NotNull String name, @NotNull String groupName, @NotNull String location) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getDestroyClusterOnShutdown().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.destroyClusterOnShutdown.get()");
        if (((Boolean)object).booleanValue()) {
            if (existsResourceGroup) {
                this.deleteResourceGroup(name, groupName, location);
            }
            this.getKubectlHelper().deleteCurrentContext();
            this.logoutAzCli(azureAksProvider.getAzUsername(), azureAksProvider.getAzPassword());
        }
    }

    @Override
    @NotNull
    public String getFqdn() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getLocation().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.location.get()");
        String location = (String)object;
        return this.getHost() + '.' + location + ".cloudapp.azure.com";
    }

    @Override
    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageCla\u2026getProvider().name.get())");
        return this.fileStorageClassName((String)object);
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageCla\u2026getProvider().name.get())");
        return this.diskStorageClassName((String)object);
    }

    @NotNull
    public final Profile getProfile() {
        return this.profile;
    }

    public AzureAksHelper(@NotNull Project project, @NotNull ProductName productName, @NotNull Profile profile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        super(project, productName);
        this.profile = profile;
    }
}

