/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.setup;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.profiles.HelmProfile;
import ai.digital.integration.server.common.domain.profiles.OperatorProfile;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.AwsOpenshiftProvider;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lai/digital/integration/server/common/cluster/setup/AwsOpenshiftHelper;", "Lai/digital/integration/server/common/cluster/Helper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "profile", "Lai/digital/integration/server/common/domain/profiles/Profile;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;Lai/digital/integration/server/common/domain/profiles/Profile;)V", "getProfile", "()Lai/digital/integration/server/common/domain/profiles/Profile;", "createOcContext", "", "getApiServerUrl", "", "getOcLogin", "", "getOcPassword", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsOpenshiftProvider;", "getStorageClass", "launchCluster", "ocLogin", "ocLogout", "integration-server-gradle-plugin"})
public class AwsOpenshiftHelper
extends Helper {
    @NotNull
    private final Profile profile;

    @Override
    @NotNull
    public AwsOpenshiftProvider getProvider() {
        AwsOpenshiftProvider awsOpenshiftProvider;
        String profileName = this.getProfileName();
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            Profile profile = this.profile;
            if (profile == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.OperatorProfile");
            }
            OperatorProfile operatorProfile = (OperatorProfile)profile;
            awsOpenshiftProvider = operatorProfile.getAwsOpenshift();
        } else if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.HELM.getProfileName())) {
            Profile profile = this.profile;
            if (profile == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.HelmProfile");
            }
            HelmProfile helmProfile = (HelmProfile)profile;
            awsOpenshiftProvider = helmProfile.getAwsOpenshift();
        } else {
            throw (Throwable)new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported");
        }
        return awsOpenshiftProvider;
    }

    public final void launchCluster() {
        this.createOcContext();
    }

    @NotNull
    public final String getApiServerUrl() {
        Object object = this.getProvider().getApiServerURL().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().apiServerURL.get()");
        return (String)object;
    }

    @Nullable
    public final Object getOcLogin() {
        return this.getProject().property("ocLogin");
    }

    @Nullable
    public final Object getOcPassword() {
        return this.getProject().property("ocPassword");
    }

    public final void ocLogin() {
        this.exec("oc login " + this.getApiServerUrl() + " --username " + this.getOcLogin() + " --password \"" + this.getOcPassword() + '\"');
    }

    public final void ocLogout() {
        try {
            this.exec("oc logout");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void createOcContext() {
        this.getProject().getLogger().lifecycle("Updating kube config for Open Shift");
        this.exec("export KUBECONFIG=~/.kube/config");
        this.ocLogin();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse((Object)"aws-efs");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageClass.getOrElse(\"aws-efs\")");
        return (String)object;
    }

    @NotNull
    public final Profile getProfile() {
        return this.profile;
    }

    public AwsOpenshiftHelper(@NotNull Project project, @NotNull ProductName productName, @NotNull Profile profile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        super(project, productName);
        this.profile = profile;
    }
}

