#!/bin/bash

# insert/update hosts entry
ip_address=$1
host_name=$2
# find existing instances in the host file and save the line numbers
matches_in_hosts="$(grep -n $host_name /etc/hosts | cut -f1 -d:)"
host_entry="${ip_address} ${host_name}"

if [ ! -z "$matches_in_hosts" ]
then
    echo "Updating existing hosts entry to '$host_entry'."
    # iterate over the line numbers on which matches were found
    while read -r line_number; do
        # replace the text of each line with the desired host entry
        sudo sed -i '' "${line_number}s/.*/${host_entry} /" /etc/hosts
    done <<< "$matches_in_hosts"
else
    echo "Adding new hosts entry to '$host_entry'."
    echo "$host_entry" | sudo tee -a /etc/hosts > /dev/null
fi
