/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.setup;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.setup.GcpGkeHelper;
import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.profiles.HelmProfile;
import ai.digital.integration.server.common.domain.profiles.OperatorProfile;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.GcpGkeProvider;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J(\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002JZ\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010!\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J8\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ&\u0010$\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eJ \u0010%\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020\fJ\u0018\u0010*\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0010\u0010,\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u000eH\u0002J\b\u0010/\u001a\u00020\fH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00060"}, d2={"Lai/digital/integration/server/common/cluster/setup/GcpGkeHelper;", "Lai/digital/integration/server/common/cluster/Helper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "profile", "Lai/digital/integration/server/common/domain/profiles/Profile;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;Lai/digital/integration/server/common/domain/profiles/Profile;)V", "getProfile", "()Lai/digital/integration/server/common/domain/profiles/Profile;", "applyDnsOpenApi", "", "ip", "", "fqdn", "host", "nameSpace", "changeDefaultProject", "projectName", "changeDefaultRegionZone", "regionZone", "connectToCluster", "accountName", "name", "createCluster", "clusterNodeCount", "Lorg/gradle/api/provider/Property;", "", "clusterNodeVmSize", "kubernetesVersion", "skipExisting", "", "deleteCluster", "deleteDnsOpenApi", "destroyClusterOnShutdown", "existsCluster", "existsDnsOpenApi", "getFqdn", "getProvider", "Lai/digital/integration/server/common/domain/providers/GcpGkeProvider;", "launchCluster", "loginGCloudCli", "accountCredFile", "logoutGCloudCli", "useCustomStorageClass", "storageClassName", "validateGCloudCli", "integration-server-gradle-plugin"})
public class GcpGkeHelper
extends Helper {
    @NotNull
    private final Profile profile;

    @Override
    @NotNull
    public GcpGkeProvider getProvider() {
        GcpGkeProvider gcpGkeProvider;
        String profileName = this.getProfileName();
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            Profile profile = this.profile;
            if (profile == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.OperatorProfile");
            }
            OperatorProfile operatorProfile = (OperatorProfile)profile;
            gcpGkeProvider = operatorProfile.getGcpGke();
        } else if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.HELM.getProfileName())) {
            Profile profile = this.profile;
            if (profile == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.HelmProfile");
            }
            HelmProfile helmProfile = (HelmProfile)profile;
            gcpGkeProvider = helmProfile.getGcpGke();
        } else {
            throw (Throwable)new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported");
        }
        return gcpGkeProvider;
    }

    public final void launchCluster() {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.name.get()");
        String name = (String)object2;
        Object object3 = gcpGkeProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.skipExisting.get()");
        boolean skipExisting = (Boolean)object3;
        Object object4 = gcpGkeProvider.getRegionZone().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"gcpGkeProvider.regionZone.get()");
        String regionZone = (String)object4;
        Object object5 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object5;
        this.validateGCloudCli();
        this.loginGCloudCli(accountName, gcpGkeProvider.getAccountCredFile());
        this.changeDefaultProject(projectName);
        this.changeDefaultRegionZone(regionZone);
        this.createCluster(accountName, projectName, name, regionZone, gcpGkeProvider.getClusterNodeCount(), gcpGkeProvider.getClusterNodeVmSize(), gcpGkeProvider.getKubernetesVersion(), skipExisting);
        this.connectToCluster(accountName, projectName, name, regionZone);
        this.useCustomStorageClass(this.getStorageClass());
    }

    private final void validateGCloudCli() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud -v", null, bl, bl2, l, 36, null);
        if (!StringsKt.contains$default((CharSequence)result, (CharSequence)"Google Cloud SDK", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("No Google Cloud SDK \"gcloud\" in the path. Please verify your installation");
        }
    }

    private final void loginGCloudCli(String accountName, String accountCredFile) {
        this.getProject().getLogger().lifecycle("Login account " + accountName);
        CharSequence charSequence = accountCredFile;
        boolean bl = false;
        String additions2 = !StringsKt.isBlank((CharSequence)charSequence) ? " --cred-file=\"" + new File(accountCredFile).getAbsolutePath() + '\"' : "";
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud auth login " + accountName + ' ' + additions2 + " --quiet", null, false, false, 0L, 60, null);
    }

    private final void changeDefaultProject(String projectName) {
        this.getProject().getLogger().lifecycle("Change default project to " + projectName);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud config set project " + projectName, null, false, false, 0L, 60, null);
    }

    private final void changeDefaultRegionZone(String regionZone) {
        this.getProject().getLogger().lifecycle("Change default region to " + regionZone);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud config set compute/zone " + regionZone, null, false, false, 0L, 60, null);
    }

    private final void createCluster(String accountName, String projectName, String name, String regionZone, Property<Integer> clusterNodeCount, Property<String> clusterNodeVmSize, Property<String> kubernetesVersion, boolean skipExisting) {
        boolean shouldSkipExisting;
        boolean bl = shouldSkipExisting = skipExisting ? this.existsCluster(accountName, projectName, name, regionZone) : false;
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing cluster: {}", new Object[]{name});
        } else {
            this.getProject().getLogger().lifecycle("Create cluster: {}", new Object[]{name});
            String additions2 = (String)clusterNodeVmSize.map((Transformer)createCluster.additions.1.INSTANCE).getOrElse((Object)"") + (String)kubernetesVersion.map((Transformer)createCluster.additions.2.INSTANCE).getOrElse((Object)" --cluster-version \"1.21.5-gke.1802\"");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud beta container --account \"" + accountName + "\" --project \"" + projectName + "\" clusters create \"" + name + "\" --zone  \"" + regionZone + "\" " + "--release-channel \"regular\" " + "--num-nodes \"" + (Integer)clusterNodeCount.getOrElse((Object)3) + "\" --image-type \"COS_CONTAINERD\" --metadata disable-legacy-endpoints=true " + "--logging=SYSTEM,WORKLOAD --monitoring=SYSTEM --enable-ip-alias --no-enable-master-authorized-networks " + "--addons HorizontalPodAutoscaling,HttpLoadBalancing,GcpFilestoreCsiDriver --enable-autoupgrade --enable-autorepair " + "--enable-shielded-nodes " + additions2, null, false, false, 0L, 60, null);
        }
    }

    public final boolean existsCluster(@NotNull String accountName, @NotNull String projectName, @NotNull String name, @NotNull String regionZone) {
        Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)regionZone, (String)"regionZone");
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud beta container --account \"" + accountName + "\" --project \"" + projectName + "\" clusters list --zone \"" + regionZone + '\"', null, bl, bl2, l, 36, null);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)name, (boolean)false, (int)2, null);
    }

    private final void connectToCluster(String accountName, String projectName, String name, String regionZone) {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud beta container --account \"" + accountName + "\" --project \"" + projectName + "\" clusters get-credentials \"" + name + "\" --zone \"" + regionZone + '\"', null, false, false, 0L, 60, null);
    }

    private final void useCustomStorageClass(String storageClassName) {
        if (!this.getKubectlHelper().hasStorageClass(storageClassName) && Intrinsics.areEqual((Object)"standard", (Object)storageClassName) ^ true) {
            this.getProject().getLogger().lifecycle("Use storage class: {}", new Object[]{storageClassName});
            this.getKubectlHelper().setDefaultStorageClass(storageClassName);
        } else {
            this.getProject().getLogger().lifecycle("Skipping using of storage class: {}", new Object[]{storageClassName});
        }
    }

    public final void applyDnsOpenApi(@NotNull String ip, @NotNull String fqdn, @NotNull String host, @NotNull String nameSpace) {
        Intrinsics.checkParameterIsNotNull((Object)ip, (String)"ip");
        Intrinsics.checkParameterIsNotNull((Object)fqdn, (String)"fqdn");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)nameSpace, (String)"nameSpace");
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.name.get()");
        String name = (String)object2;
        Object object3 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object3;
        File dnsOpenApiTemplateFile = Helper.getTemplate$default(this, "operator/gcp-gke/dns-openapi.yaml", null, 2, null);
        String dnsOpenApiTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)dnsOpenApiTemplateFile, (Charset)Charsets.UTF_8), (String)"{{NAME}}", (String)name, (boolean)false, (int)4, null), (String)"{{PROJECT_ID}}", (String)projectName, (boolean)false, (int)4, null), (String)"{{PRODUCT_NAME}}", (String)this.getProductName().getShortName(), (boolean)false, (int)4, null), (String)"{{HOST}}", (String)host, (boolean)false, (int)4, null), (String)"{{NAMESPACE}}", (String)nameSpace, (boolean)false, (int)4, null), (String)"{{IP}}", (String)ip, (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)dnsOpenApiTemplateFile, (String)dnsOpenApiTemplate, null, (int)2, null);
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud endpoints --account \"" + accountName + "\" --project \"" + projectName + "\" services undelete \"" + fqdn + '\"', null, bl, bl2, l, 36, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud endpoints --account \"" + accountName + "\" --project \"" + projectName + "\" services deploy \"" + dnsOpenApiTemplateFile.getAbsolutePath() + "\" --force", null, false, false, 0L, 60, null);
    }

    public static /* synthetic */ void applyDnsOpenApi$default(GcpGkeHelper gcpGkeHelper, String string, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyDnsOpenApi");
        }
        if ((n & 2) != 0) {
            string2 = gcpGkeHelper.getFqdn();
        }
        if ((n & 4) != 0) {
            string3 = gcpGkeHelper.getHost();
        }
        if ((n & 8) != 0) {
            string4 = Profile.Companion.getDEFAULT_NAMESPACE_NAME();
        }
        gcpGkeHelper.applyDnsOpenApi(string, string2, string3, string4);
    }

    private final void deleteCluster(String accountName, String projectName, String name, String regionZone) {
        if (this.existsCluster(accountName, projectName, name, regionZone)) {
            this.getProject().getLogger().lifecycle("Delete cluster (async): {}", new Object[]{name});
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud beta container --account \"" + accountName + "\" --project \"" + projectName + "\" clusters delete \"" + name + "\" --zone \"" + regionZone + "\" --quiet", null, false, false, 0L, 44, null);
        } else {
            this.getProject().getLogger().lifecycle("Skipping delete of the cluster: {}", new Object[]{name});
        }
    }

    private final void logoutGCloudCli(String accountName) {
        this.getProject().getLogger().lifecycle("Revoke account " + accountName);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud auth revoke " + accountName + " --quiet", null, false, false, 0L, 44, null);
    }

    public final void destroyClusterOnShutdown(boolean existsCluster, @NotNull String accountName, @NotNull String projectName, @NotNull String name, @NotNull String regionZone, @NotNull String fqdn) {
        Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)regionZone, (String)"regionZone");
        Intrinsics.checkParameterIsNotNull((Object)fqdn, (String)"fqdn");
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getDestroyClusterOnShutdown().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.destroyClusterOnShutdown.get()");
        if (((Boolean)object).booleanValue()) {
            if (existsCluster) {
                this.deleteCluster(accountName, projectName, name, regionZone);
            }
            this.deleteDnsOpenApi(fqdn);
            this.getKubectlHelper().deleteCurrentContext();
            Object object2 = gcpGkeProvider.getAccountName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.accountName.get()");
            this.logoutGCloudCli((String)object2);
        }
    }

    public static /* synthetic */ void destroyClusterOnShutdown$default(GcpGkeHelper gcpGkeHelper, boolean bl, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: destroyClusterOnShutdown");
        }
        if ((n & 0x20) != 0) {
            string5 = gcpGkeHelper.getFqdn();
        }
        gcpGkeHelper.destroyClusterOnShutdown(bl, string, string2, string3, string4, string5);
    }

    private final void deleteDnsOpenApi(String fqdn) {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object2;
        if (this.existsDnsOpenApi(accountName, projectName, fqdn)) {
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud endpoints --account \"" + accountName + "\" --project \"" + projectName + "\" services delete \"" + fqdn + "\" --quiet", null, false, false, 0L, 44, null);
        }
    }

    private final boolean existsDnsOpenApi(String accountName, String projectName, String fqdn) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud endpoints --account \"" + accountName + "\" --project \"" + projectName + "\" services list", null, bl, bl2, l, 36, null);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)fqdn, (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getProductName().getShortName() + '-' + this.getHost() + ".endpoints." + (String)this.getProvider().getProjectName().get() + ".cloud.goog";
    }

    @NotNull
    public final Profile getProfile() {
        return this.profile;
    }

    public GcpGkeHelper(@NotNull Project project, @NotNull ProductName productName, @NotNull Profile profile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        super(project, productName);
        this.profile = profile;
    }
}

