/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.GcpGkeHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.GcpGkeProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u00020\u00152\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\u0006\u0010\u001d\u001a\u00020\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/digital/integration/server/common/cluster/operator/GcpGkeOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "gcpGkeHelper", "Lai/digital/integration/server/common/cluster/setup/GcpGkeHelper;", "getAccessToken", "", "accountName", "projectName", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "Lkotlin/Pair;", "getFqdn", "getProvider", "Lai/digital/integration/server/common/domain/providers/GcpGkeProvider;", "getProviderHomePath", "installCluster", "", "launchCluster", "shutdownCluster", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "updateInfrastructure", "kubeContextInfo", "updateOperator", "integration-server-gradle-plugin"})
public class GcpGkeOperatorHelper
extends OperatorHelper {
    private final GcpGkeHelper gcpGkeHelper;

    public final void launchCluster() {
        this.gcpGkeHelper.launchCluster();
    }

    public final void updateOperator() {
        Object object = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().cleanUpWaitTimeout.get()");
        this.cleanUpCluster((Duration)object);
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object2 = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object2;
        Object object3 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object3;
        Pair<InfrastructureInfo, String> kubeContextInfo = this.getCurrentContextInfo(accountName, projectName);
        this.updateInfrastructure(kubeContextInfo);
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProfile().ingressType.get()");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProfile().deploymentTimeoutSeconds.get()");
        Helper.waitForDeployment$default(this, string, ((Number)object2).intValue(), false, 4, null);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForWorkerPods(((Number)object4).intValue());
        String ip = this.getKubectlHelper().getServiceExternalIp("service/" + this.getCrName() + "-nginx-ingress-controller");
        String string2 = this.getNamespace();
        if (string2 == null) {
            string2 = Profile.Companion.getDEFAULT_NAMESPACE_NAME();
        }
        String nameSpace = string2;
        this.gcpGkeHelper.applyDnsOpenApi(ip, this.getFqdn(), this.getHost(), nameSpace);
        this.createClusterMetadata();
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
    }

    public final void shutdownCluster() {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.name.get()");
        String name = (String)object2;
        Object object3 = gcpGkeProvider.getRegionZone().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.regionZone.get()");
        String regionZone = (String)object3;
        Object object4 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object4;
        boolean existsCluster = this.gcpGkeHelper.existsCluster(accountName, projectName, name, regionZone);
        if (existsCluster) {
            this.undeployCluster();
        }
        this.gcpGkeHelper.destroyClusterOnShutdown(existsCluster, accountName, projectName, name, regionZone, this.getFqdn());
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-gcp-gke";
    }

    @Override
    @NotNull
    public GcpGkeProvider getProvider() {
        return this.getProfile().getGcpGke();
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getProductName().getShortName() + '-' + this.getHost() + ".endpoints." + (String)this.getProvider().getProjectName().get() + ".cloud.goog";
    }

    private final Pair<InfrastructureInfo, String> getCurrentContextInfo(String accountName, String projectName) {
        KubeCtlHelper kubectlHelper = this.getKubectlHelper();
        String context = kubectlHelper.getCurrentContext();
        String cluster = kubectlHelper.getContextCluster(context);
        String user = kubectlHelper.getContextUser(context);
        InfrastructureInfo info = new InfrastructureInfo(cluster, user, kubectlHelper.getClusterServer(cluster), kubectlHelper.getClusterCertificateAuthorityData(cluster), null, null);
        String accessToken = this.getAccessToken(accountName, projectName);
        return new Pair((Object)info, (Object)accessToken);
    }

    private final String getAccessToken(String accountName, String projectName) {
        Map gcloudConfigMap;
        String gcloudConfig = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud config --account \"" + accountName + "\" --project \"" + projectName + "\" config-helper --format=yaml", null, false, false, 0L, 60, null);
        Map map2 = gcloudConfigMap = (Map)new ObjectMapper((JsonFactory)YAMLFactory.builder().build()).readValue(gcloudConfig, Map.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"gcloudConfigMap");
        Map map3 = map2;
        String string = "credential";
        boolean bl = false;
        Object v = map3.get(string);
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        }
        map3 = (Map)v;
        string = "access_token";
        bl = false;
        Object v2 = map3.get(string);
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)v2;
    }

    private final void updateInfrastructure(Pair<? extends InfrastructureInfo, String> kubeContextInfo) {
        super.updateInfrastructure();
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Pair[] pairArray = new Pair[3];
        String string = ((InfrastructureInfo)kubeContextInfo.getFirst()).getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = ((InfrastructureInfo)kubeContextInfo.getFirst()).getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].token", (Object)kubeContextInfo.getSecond());
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)crValuesFile, (String)"crValuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.route.hosts", (Object)new String[]{this.getHost()}), TuplesKt.to((Object)"spec.ingress.hosts", (Object)CollectionsKt.listOf((Object)this.getFqdn()))});
        YamlFileUtil.Companion.overlayFile(crValuesFile, pairs, false);
    }

    @Override
    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        Object object = this.getProvider().getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().projectName.get()");
        String projectName = (String)object;
        Object object2 = this.getProvider().getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProvider().accountName.get()");
        String accountName = (String)object2;
        return (InfrastructureInfo)this.getCurrentContextInfo(accountName, projectName).getFirst();
    }

    @NotNull
    public final String getAccessToken() {
        Object object = this.getProvider().getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().projectName.get()");
        String projectName = (String)object;
        Object object2 = this.getProvider().getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProvider().accountName.get()");
        String accountName = (String)object2;
        return this.getAccessToken(accountName, projectName);
    }

    public GcpGkeOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.gcpGkeHelper = new GcpGkeHelper(project, productName, this.getProfile());
    }
}

