/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.helm;

import ai.digital.integration.server.common.cluster.helm.HelmHelper;
import ai.digital.integration.server.common.cluster.setup.AwsEksHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.AwsEksProvider;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/digital/integration/server/common/cluster/helm/AwsEksHelmHelper;", "Lai/digital/integration/server/common/cluster/helm/HelmHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "awsEksHelper", "Lai/digital/integration/server/common/cluster/setup/AwsEksHelper;", "getDbStorageClass", "", "getFqdn", "getMqStorageClass", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsEksProvider;", "getStorageClass", "helmInstallCluster", "", "launchCluster", "setupHelmValues", "shutdownCluster", "updateCustomHelmValues", "valuesFile", "Ljava/io/File;", "integration-server-gradle-plugin"})
public class AwsEksHelmHelper
extends HelmHelper {
    private final AwsEksHelper awsEksHelper;

    public final void launchCluster() {
        this.awsEksHelper.launchCluster();
    }

    public final void helmInstallCluster() {
        this.installCluster();
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProfile().ingressType.get()");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForDeployment(string, ((Number)object2).intValue(), true);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForWorkerPods(((Number)object4).intValue());
        this.createClusterMetadata();
        this.awsEksHelper.updateRoute53(Profile.Companion.getDEFAULT_NAMESPACE_NAME(), this.getFqdn());
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
    }

    public final void setupHelmValues() {
        this.copyValuesYamlFile();
        this.updateHelmValuesYaml();
        this.updateHelmDependency();
    }

    public final void shutdownCluster() {
        this.helmCleanUpCluster();
        this.getKubectlHelper().deleteAllPVCs();
        this.awsEksHelper.destroyClusterOnShutdown();
    }

    @Override
    @NotNull
    public AwsEksProvider getProvider() {
        return this.getProfile().getAwsEks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return this.awsEksHelper.getStorageClass();
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        return "gp2";
    }

    @Override
    @NotNull
    public String getMqStorageClass() {
        return "gp2";
    }

    @Override
    public void updateCustomHelmValues(@NotNull File valuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)valuesFile, (String)"valuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"ingress.hosts", (Object)new String[]{this.getFqdn()}), TuplesKt.to((Object)"rabbitmq.persistence.storageClass", (Object)"gp2")});
        YamlFileUtil.Companion.overlayFile(valuesFile, pairs, false);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.awsEksHelper.getFqdn();
    }

    public AwsEksHelmHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.awsEksHelper = new AwsEksHelper(project, productName, this.getProfile());
    }
}

