/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tasks.cluster.operator;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.operator.AwsEksOperatorHelper;
import ai.digital.integration.server.common.cluster.operator.AwsOpenshiftOperatorHelper;
import ai.digital.integration.server.common.cluster.operator.GcpGkeOperatorHelper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.constant.K8sSetup;
import ai.digital.integration.server.common.constant.OperatorHelmProviderName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.tasks.cluster.operator.OperatorBasedUpgradeClusterTask;
import ai.digital.integration.server.common.tasks.cluster.operator.OperatorBasedUpgradeClusterTask$WhenMappings;
import ai.digital.integration.server.common.util.GitUtil;
import ai.digital.integration.server.common.util.XlCliUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyBuilderScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020!H\u0007J\u0018\u0010\"\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010&\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010'\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001fH\u0002R$\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00190\u00190\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\n\u00a8\u0006*"}, d2={"Lai/digital/integration/server/common/tasks/cluster/operator/OperatorBasedUpgradeClusterTask;", "Lorg/gradle/api/DefaultTask;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lai/digital/integration/server/common/constant/ProductName;)V", "deployUpgraderVersion", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getDeployUpgraderVersion", "()Lorg/gradle/api/provider/Property;", "imageRepositoryName", "getImageRepositoryName", "imageTargetVersion", "getImageTargetVersion", "keycloakUrl", "getKeycloakUrl", "opBlueprintBranch", "getOpBlueprintBranch", "operatorBranch", "getOperatorBranch", "getProductName", "()Lai/digital/integration/server/common/constant/ProductName;", "runningTime", "useOperatorZip", "", "getUseOperatorZip", "getOperatorImage", "operatorHelper", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "getUpgradeDir", "Ljava/nio/file/Path;", "launch", "", "opUsingAnswersFile", "answersFile", "Ljava/io/File;", "operatorBranchToOperatorZip", "prepareAnswersFile", "operatorZip", "prepareOperatorZip", "src", "integration-server-gradle-plugin"})
public abstract class OperatorBasedUpgradeClusterTask
extends DefaultTask {
    @Input
    @NotNull
    private final Property<String> imageRepositoryName;
    @Input
    @NotNull
    private final Property<String> imageTargetVersion;
    @Input
    @NotNull
    private final Property<String> deployUpgraderVersion;
    @Input
    @NotNull
    private final Property<Boolean> useOperatorZip;
    @Optional
    @Input
    @NotNull
    private final Property<String> operatorBranch;
    @Optional
    @Input
    @NotNull
    private final Property<String> opBlueprintBranch;
    @Optional
    @Input
    @NotNull
    private final Property<String> keycloakUrl;
    private final String runningTime;
    @Input
    @NotNull
    private final ProductName productName;

    @NotNull
    public final Property<String> getImageRepositoryName() {
        return this.imageRepositoryName;
    }

    @NotNull
    public final Property<String> getImageTargetVersion() {
        return this.imageTargetVersion;
    }

    @NotNull
    public final Property<String> getDeployUpgraderVersion() {
        return this.deployUpgraderVersion;
    }

    @NotNull
    public final Property<Boolean> getUseOperatorZip() {
        return this.useOperatorZip;
    }

    @NotNull
    public final Property<String> getOperatorBranch() {
        return this.operatorBranch;
    }

    @NotNull
    public final Property<String> getOpBlueprintBranch() {
        return this.opBlueprintBranch;
    }

    @NotNull
    public final Property<String> getKeycloakUrl() {
        return this.keycloakUrl;
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project, this.productName);
        Path operatorZip = this.operatorBranchToOperatorZip(operatorHelper);
        File answersFile = this.prepareAnswersFile(operatorHelper, operatorZip);
        this.opUsingAnswersFile(operatorHelper, answersFile);
        Helper helper = operatorHelper;
        Object object = operatorHelper.getProfile().getIngressType().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"operatorHelper.getProfile().ingressType.get()");
        String string = (String)object;
        Object object2 = operatorHelper.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"operatorHelper.getProfil\u2026ymentTimeoutSeconds.get()");
        Helper.waitForDeployment$default(helper, string, ((Number)object2).intValue(), null, false, 12, null);
        Object object3 = operatorHelper.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"operatorHelper.getProfil\u2026ymentTimeoutSeconds.get()");
        operatorHelper.waitForMasterPods(((Number)object3).intValue());
        Object object4 = operatorHelper.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"operatorHelper.getProfil\u2026ymentTimeoutSeconds.get()");
        operatorHelper.waitForWorkerPods(((Number)object4).intValue());
        operatorHelper.waitForBoot(operatorHelper.getContextRoot(), operatorHelper.getFqdn());
    }

    private final Path getUpgradeDir(OperatorHelper operatorHelper) {
        Path path = Paths.get(operatorHelper.getProviderWorkDir(), this.runningTime);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(operatorHelper\u2026erWorkDir(), runningTime)");
        return path;
    }

    private final File prepareAnswersFile(OperatorHelper operatorHelper, Path operatorZip) {
        String string;
        String string2;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        OperatorUtil clusterUtil = new OperatorUtil(project);
        Server server = clusterUtil.getOperatorServer();
        String string3 = operatorHelper.getOperatorImage();
        if (string3 == null) {
            string3 = this.getOperatorImage(operatorHelper);
        }
        String operatorImage = string3;
        String crdName = operatorHelper.getKubectlHelper().getCrd(this.productName.getShortName() + ".digital.ai");
        String crName = operatorHelper.getKubectlHelper().getCr(crdName);
        Object object = operatorHelper.getProfile().getNamespace().getOrElse((Object)"default");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"operatorHelper.getProfil\u2026pace.getOrElse(\"default\")");
        String namespace = (String)object;
        switch (OperatorBasedUpgradeClusterTask$WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1: {
                Map<OperatorHelmProviderName, String> map2 = XlCliUtil.Companion.getXL_OP_MAPPING();
                Project project2 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                String string4 = map2.get((Object)DeployClusterUtil.Companion.getOperatorProviderName(project2));
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                string2 = string4;
                break;
            }
            case 2: {
                Map<OperatorHelmProviderName, String> map3 = XlCliUtil.Companion.getXL_OP_MAPPING();
                Project project3 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                String string5 = map3.get((Object)ReleaseClusterUtil.Companion.getOperatorProviderName(project3));
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                string2 = string5;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String k8sSetup = string2;
        String targetFileName = this.runningTime + "/answers.yaml";
        String string6 = k8sSetup;
        File answersFile = Intrinsics.areEqual((Object)string6, (Object)K8sSetup.GoogleGKE.toString()) ? operatorHelper.getTemplate("operator/xl-upgrade/" + this.productName.getDisplayName() + "/answers_gke.yaml", targetFileName) : (Intrinsics.areEqual((Object)string6, (Object)K8sSetup.Openshift.toString()) ? operatorHelper.getTemplate("operator/xl-upgrade/" + this.productName.getDisplayName() + "/answers_aws_openshift.yaml", targetFileName) : (Intrinsics.areEqual((Object)string6, (Object)K8sSetup.AzureAKS.toString()) ? operatorHelper.getTemplate("operator/xl-upgrade/" + this.productName.getDisplayName() + "/answers_aks.yaml", targetFileName) : (Intrinsics.areEqual((Object)string6, (Object)K8sSetup.AwsEKS.toString()) ? operatorHelper.getTemplate("operator/xl-upgrade/" + this.productName.getDisplayName() + "/answers_eks.yaml", targetFileName) : operatorHelper.getTemplate("operator/xl-upgrade/" + this.productName.getDisplayName() + "/answers.yaml", targetFileName))));
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        project4.getLogger().lifecycle("Preparing answers file " + answersFile.getAbsolutePath());
        InfrastructureInfo kubeContextInfo = operatorHelper.getCurrentContextInfo();
        String string7 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)answersFile, (Charset)Charsets.UTF_8), (String)"{{CRD_NAME}}", (String)crdName, (boolean)false, (int)4, null), (String)"{{CR_NAME}}", (String)crName, (boolean)false, (int)4, null), (String)"{{USE_CUSTOM_NAMESPACE}}", (String)String.valueOf(Intrinsics.areEqual((Object)namespace, (Object)"default") ^ true), (boolean)false, (int)4, null), (String)"{{K8S_NAMESPACE}}", (String)namespace, (boolean)false, (int)4, null), (String)"{{IS_CRD_REUSED}}", (String)String.valueOf(Intrinsics.areEqual((Object)namespace, (Object)"default") ^ true), (boolean)false, (int)4, null);
        String string8 = kubeContextInfo.getApiServerURL();
        if (string8 == null) {
            Intrinsics.throwNpe();
        }
        String string9 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string7, (String)"{{K8S_API_SERVER_URL}}", (String)string8, (boolean)false, (int)4, null), (String)"{{K8S_SETUP}}", (String)k8sSetup, (boolean)false, (int)4, null), (String)"{{OPERATOR_IMAGE}}", (String)operatorImage, (boolean)false, (int)4, null);
        Object object2 = this.imageRepositoryName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"imageRepositoryName.get()");
        String string10 = StringsKt.replace$default((String)string9, (String)"{{REPOSITORY_NAME}}", (String)((String)object2), (boolean)false, (int)4, null);
        Object object3 = this.imageTargetVersion.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"imageTargetVersion.get()");
        String string11 = StringsKt.replace$default((String)string10, (String)"{{IMAGE_TAG}}", (String)((String)object3), (boolean)false, (int)4, null);
        String string12 = server.getVersion();
        if (string12 == null) {
            Intrinsics.throwNpe();
        }
        String string13 = StringsKt.replace$default((String)StringsKt.replace$default((String)string11, (String)"{{DEPLOY_VERSION_FOR_UPGRADER}}", (String)string12, (boolean)false, (int)4, null), (String)"{{USE_KEYCLOAK}}", (String)String.valueOf((Boolean)this.keycloakUrl.map((Transformer)prepareAnswersFile.answersFileTemplateTmp.1.INSTANCE).getOrElse((Object)false)), (boolean)false, (int)4, null);
        Object object4 = this.keycloakUrl.getOrElse((Object)"null");
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"keycloakUrl.getOrElse(\"null\")");
        String string14 = StringsKt.replace$default((String)string13, (String)"{{KEYCLOAK_URL}}", (String)((String)object4), (boolean)false, (int)4, null);
        Object object5 = this.deployUpgraderVersion.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"deployUpgraderVersion.get()");
        String string15 = StringsKt.replace$default((String)StringsKt.replace$default((String)string14, (String)"{{DEPLOY_VERSION_FOR_UPGRADER}}", (String)((String)object5), (boolean)false, (int)4, null), (String)"{{USE_OPERATOR_ZIP}}", (String)String.valueOf(operatorZip != null), (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder().append("{{OPERATOR_ZIP_");
        String string16 = this.productName.getDisplayName();
        boolean bl = false;
        String string17 = string16;
        if (string17 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string18 = string17.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"(this as java.lang.String).toUpperCase()");
        String string19 = stringBuilder.append(string18).append("}}").toString();
        Object object6 = operatorZip;
        if (object6 == null || (object6 = object6.toAbsolutePath()) == null || (object6 = object6.toString()) == null) {
            object6 = "null";
        }
        String answersFileTemplateTmp2 = StringsKt.replace$default((String)string15, (String)string19, (String)object6, (boolean)false, (int)4, null);
        String string20 = k8sSetup;
        if (Intrinsics.areEqual((Object)string20, (Object)K8sSetup.GoogleGKE.toString())) {
            OperatorHelper operatorHelper2 = operatorHelper;
            if (operatorHelper2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.cluster.operator.GcpGkeOperatorHelper");
            }
            string = StringsKt.replace$default((String)answersFileTemplateTmp2, (String)"{{K8S_TOKEN}}", (String)((GcpGkeOperatorHelper)operatorHelper2).getAccessToken(), (boolean)false, (int)4, null);
        } else if (Intrinsics.areEqual((Object)string20, (Object)K8sSetup.Openshift.toString())) {
            OperatorHelper operatorHelper3 = operatorHelper;
            if (operatorHelper3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.cluster.operator.AwsOpenshiftOperatorHelper");
            }
            string = StringsKt.replace$default((String)answersFileTemplateTmp2, (String)"{{K8S_TOKEN}}", (String)((AwsOpenshiftOperatorHelper)operatorHelper3).getOcApiServerToken(), (boolean)false, (int)4, null);
        } else if (Intrinsics.areEqual((Object)string20, (Object)K8sSetup.AzureAKS.toString())) {
            String string21 = kubeContextInfo.getCaCert();
            if (string21 == null) {
                Intrinsics.throwNpe();
            }
            String string22 = StringsKt.replace$default((String)answersFileTemplateTmp2, (String)"{{K8S_CLIENT_CERT}}", (String)string21, (boolean)false, (int)4, null);
            String string23 = kubeContextInfo.getTlsPrivateKey();
            if (string23 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.replace$default((String)string22, (String)"{{K8S_CLIENT_KEY}}", (String)string23, (boolean)false, (int)4, null);
        } else if (Intrinsics.areEqual((Object)string20, (Object)K8sSetup.AwsEKS.toString())) {
            OperatorHelper operatorHelper4 = operatorHelper;
            if (operatorHelper4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.cluster.operator.AwsEksOperatorHelper");
            }
            AwsEksOperatorHelper awsEksHelper = (AwsEksOperatorHelper)operatorHelper4;
            String string24 = kubeContextInfo.getCaCert();
            if (string24 == null) {
                Intrinsics.throwNpe();
            }
            String string25 = StringsKt.replace$default((String)answersFileTemplateTmp2, (String)"{{K8S_CLIENT_CERT}}", (String)string24, (boolean)false, (int)4, null);
            Object object7 = awsEksHelper.getProvider().getClusterName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"awsEksHelper.getProvider().clusterName.get()");
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string25, (String)"{{CLUSTER_NAME}}", (String)((String)object7), (boolean)false, (int)4, null), (String)"{{AWS_ACCESS_KEY}}", (String)awsEksHelper.getProvider().getAwsAccessKey(), (boolean)false, (int)4, null), (String)"{{AWS_ACCESS_SECRET}}", (String)awsEksHelper.getProvider().getAwsSecretKey(), (boolean)false, (int)4, null);
        } else {
            String string26 = kubeContextInfo.getCaCert();
            if (string26 == null) {
                Intrinsics.throwNpe();
            }
            String string27 = StringsKt.replace$default((String)answersFileTemplateTmp2, (String)"{{K8S_CLIENT_CERT}}", (String)string26, (boolean)false, (int)4, null);
            String string28 = kubeContextInfo.getTlsPrivateKey();
            if (string28 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.replace$default((String)string27, (String)"{{K8S_CLIENT_KEY}}", (String)string28, (boolean)false, (int)4, null);
        }
        String answersFileTemplate = string;
        FilesKt.writeText$default((File)answersFile, (String)answersFileTemplate, null, (int)2, null);
        return answersFile;
    }

    private final void opUsingAnswersFile(OperatorHelper operatorHelper, File answersFile) {
        Provider provider = this.opBlueprintBranch.map((Transformer)new Transformer<File, String>(this, operatorHelper){
            final /* synthetic */ OperatorBasedUpgradeClusterTask this$0;
            final /* synthetic */ OperatorHelper $operatorHelper;

            @NotNull
            public final File transform(@NotNull String branch) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                Project project = this.this$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                project.getLogger().lifecycle("Using xl-op-blueprints from branch " + branch);
                return GitUtil.Companion.checkout("xl-op-blueprints", OperatorBasedUpgradeClusterTask.access$getUpgradeDir(this.this$0, this.$operatorHelper), branch).toFile();
            }
            {
                this.this$0 = operatorBasedUpgradeClusterTask;
                this.$operatorHelper = operatorHelper;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"opBlueprintBranch.map { \u2026ranch).toFile()\n        }");
        Provider opBlueprintPath2 = provider;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Applying prepared answers file " + answersFile.getAbsolutePath());
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        File file = this.getUpgradeDir(operatorHelper).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getUpgradeDir(operatorHelper).toFile()");
        XlCliUtil.Companion.xlOp$default(XlCliUtil.Companion, project2, answersFile, file, (File)opBlueprintPath2.getOrNull(), null, 16, null);
        FileUtils.copyFileToDirectory((File)new File(this.getUpgradeDir(operatorHelper).toFile(), "xebialabs/dai-" + this.productName.getDisplayName() + "/dai" + this.productName.getDisplayName() + "_cr.yaml"), (File)new File(operatorHelper.getProviderWorkDir()));
        operatorHelper.createClusterMetadata();
    }

    private final Path operatorBranchToOperatorZip(OperatorHelper operatorHelper) {
        Object object = this.useOperatorZip.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"useOperatorZip.get()");
        if (((Boolean)object).booleanValue() && this.operatorBranch.isPresent()) {
            Path src;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            project.getLogger().lifecycle("Using xl-" + this.productName.getDisplayName() + "-kubernetes-operator from branch " + (String)this.operatorBranch.get());
            Path operatorPath = GitUtil.Companion.checkout("xl-" + this.productName.getDisplayName() + "-kubernetes-operator", this.getUpgradeDir(operatorHelper), (String)this.operatorBranch.get());
            Path path = src = Paths.get(((Object)operatorPath.toAbsolutePath()).toString(), operatorHelper.getProviderHomePath());
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"src");
            return this.prepareOperatorZip(operatorHelper, path);
        }
        Object object2 = this.useOperatorZip.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"useOperatorZip.get()");
        if (((Boolean)object2).booleanValue()) {
            Object object3 = this.useOperatorZip.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"useOperatorZip.get()");
            if (((Boolean)object3).booleanValue() && operatorHelper.getProvider().getOperatorPackageVersion().isPresent()) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                project.getLogger().lifecycle("Downloading xl-" + this.productName.getDisplayName() + "-kubernetes-operator version " + (String)operatorHelper.getProvider().getOperatorPackageVersion().get());
                String providerHomePath = operatorHelper.getProviderHomePath();
                File file = this.getUpgradeDir(operatorHelper).toFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getUpgradeDir(operatorHelper).toFile()");
                return FilesKt.resolve((File)file, (String)providerHomePath).toPath();
            }
        }
        Object object4 = this.useOperatorZip.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"useOperatorZip.get()");
        if (((Boolean)object4).booleanValue()) {
            String providerHomePath = operatorHelper.getProviderHomePath();
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            project.getLogger().lifecycle("Using current xl-" + this.productName.getDisplayName() + "-kubernetes-operator");
            File file = this.getUpgradeDir(operatorHelper).toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getUpgradeDir(operatorHelper).toFile()");
            File operatorPath = FilesKt.resolve((File)file, (String)("xl-" + this.productName.getDisplayName() + "-kubernetes-operator"));
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            File file2 = project2.getRootDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.rootDir");
            FilesKt.copyRecursively$default((File)FilesKt.resolve((File)file2, (String)providerHomePath), (File)FilesKt.resolve((File)operatorPath, (String)providerHomePath), (boolean)true, null, (int)4, null);
            Path path = FilesKt.resolve((File)operatorPath, (String)providerHomePath).toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"operatorPath.resolve(providerHomePath).toPath()");
            return this.prepareOperatorZip(operatorHelper, path);
        }
        return null;
    }

    private final Path prepareOperatorZip(OperatorHelper operatorHelper, Path src) {
        File newCrFilePath = new File(src.toFile(), operatorHelper.getOPERATOR_CR_VALUES_REL_PATH());
        if (!newCrFilePath.exists()) {
            throw (Throwable)new IllegalArgumentException("No CR file from operator package in " + newCrFilePath.getAbsolutePath());
        }
        operatorHelper.updateCustomOperatorCrValues(newCrFilePath);
        File file = this.getUpgradeDir(operatorHelper).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getUpgradeDir(operatorHelper).toFile()");
        Path dest = Paths.get(file.getAbsolutePath(), "operator-" + this.productName.getDisplayName() + "-upgrade.zip");
        AntBuilder antBuilder = this.getAnt();
        Intrinsics.checkExpressionValueIsNotNull((Object)antBuilder, (String)"ant");
        AntBuilder $this$withGroovyBuilder$iv = antBuilder;
        boolean $i$f$withGroovyBuilder = false;
        GroovyBuilderScope $this$withGroovyBuilder = GroovyBuilderScope.Companion.of((Object)$this$withGroovyBuilder$iv);
        boolean bl = false;
        $this$withGroovyBuilder.invoke("zip", new Pair[]{TuplesKt.to((Object)"basedir", (Object)((Object)src.toAbsolutePath()).toString()), TuplesKt.to((Object)"destfile", (Object)((Object)dest.toAbsolutePath()).toString())});
        Path path = dest;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dest");
        return path;
    }

    private final String getOperatorImage(OperatorHelper operatorHelper) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootDir");
        File operatorDeployment = FilesKt.resolve((File)FilesKt.resolve((File)file, (String)operatorHelper.getProviderHomePath()), (String)operatorHelper.getOPERATOR_DEPLOYMENT_PATH());
        operatorHelper.getReferenceCrValuesFile();
        Object object = YamlFileUtil.Companion.readFileKey$default(YamlFileUtil.Companion, operatorDeployment, "spec.template.spec.containers[1].image", false, 4, null);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)object;
    }

    @NotNull
    public final ProductName getProductName() {
        return this.productName;
    }

    public OperatorBasedUpgradeClusterTask(@NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        this.productName = productName;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.imageRepositoryName = property;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ObjectFactory objectFactory2 = project2.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory2, (String)"project.objects");
        $this$property$iv = objectFactory2;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.imageTargetVersion = property2;
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        ObjectFactory objectFactory3 = project3.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory3, (String)"project.objects");
        $this$property$iv = objectFactory3;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        Property property4 = property3.value((Provider)this.imageTargetVersion);
        Intrinsics.checkExpressionValueIsNotNull((Object)property4, (String)"project.objects.property\u2026value(imageTargetVersion)");
        this.deployUpgraderVersion = property4;
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        ObjectFactory objectFactory4 = project4.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory4, (String)"project.objects");
        $this$property$iv = objectFactory4;
        $i$f$property = false;
        Property property5 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(T::class.java)");
        Property property6 = property5.value((Object)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)property6, (String)"project.objects.property<Boolean>().value(true)");
        this.useOperatorZip = property6;
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        ObjectFactory objectFactory5 = project5.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory5, (String)"project.objects");
        $this$property$iv = objectFactory5;
        $i$f$property = false;
        Property property7 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property7, (String)"property(T::class.java)");
        this.operatorBranch = property7;
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        ObjectFactory objectFactory6 = project6.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory6, (String)"project.objects");
        $this$property$iv = objectFactory6;
        $i$f$property = false;
        Property property8 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property8, (String)"property(T::class.java)");
        this.opBlueprintBranch = property8;
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        ObjectFactory objectFactory7 = project7.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory7, (String)"project.objects");
        $this$property$iv = objectFactory7;
        $i$f$property = false;
        Property property9 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property9, (String)"property(T::class.java)");
        this.keycloakUrl = property9;
        this.runningTime = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now());
        this.setGroup("Integration Server");
        final OperatorBasedUpgradeClusterTask upgradeTask = this;
        this.getProject().afterEvaluate((Action)new Action<Project>(){

            /*
             * Unable to fully structure code
             */
            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkParameterIsNotNull((Object)$this$afterEvaluate, (String)"$receiver");
                dependencies = CollectionsKt.mutableListOf((Object[])new Object[]{"downloadXlCliDist"});
                v0 = $this$afterEvaluate.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"project");
                if (DeployExtensionUtil.Companion.getExtension(v0).getClusterProfiles().operator().getActiveProviderName().isPresent()) ** GOTO lbl-1000
                v1 = $this$afterEvaluate.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"project");
                if (ReleaseExtensionUtil.Companion.getExtension(v1).getClusterProfiles().operator().getActiveProviderName().isPresent()) lbl-1000:
                // 2 sources

                {
                    v2 = $this$afterEvaluate.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"project");
                    operatorHelper = OperatorHelper.Companion.getOperatorHelper(v2, this.getProductName());
                    v3 = this.getUseOperatorZip().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"useOperatorZip.get()");
                    if (((Boolean)v3).booleanValue() && operatorHelper.getProvider().getOperatorPackageVersion().isPresent()) {
                        v4 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"project");
                        v5 = v4.getBuildscript();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"project.buildscript");
                        v5.getDependencies().add("operatorDist", (Object)("ai.digital." + operatorHelper.getProductName().getDisplayName() + ".operator:" + operatorHelper.getProviderHomePath() + ':' + (String)operatorHelper.getProvider().getOperatorPackageVersion().get() + "@zip"));
                        taskName = "downloadOperator" + operatorHelper.getProviderHomePath();
                        providerHomePath = operatorHelper.getProviderHomePath();
                        v6 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"project");
                        v7 = v6.getTasks().register(taskName, Copy.class, (Action)new Action<Copy>(this, operatorHelper, providerHomePath){
                            final /* synthetic */ 1 this$0;
                            final /* synthetic */ OperatorHelper $operatorHelper;
                            final /* synthetic */ String $providerHomePath;

                            public final void execute(@NotNull Copy $this$register) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$register, (String)"$receiver");
                                Object[] objectArray = new Object[1];
                                Project project = $this$register.getProject();
                                Project project2 = $this$register.getProject();
                                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                                ScriptHandler scriptHandler = project2.getBuildscript();
                                Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
                                Configuration configuration = scriptHandler.getConfigurations().getByName("operatorDist");
                                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.buildscript.conf\u2026ationsUtil.OPERATOR_DIST)");
                                objectArray[0] = project.zipTree((Object)configuration.getSingleFile());
                                $this$register.from(objectArray);
                                File file = OperatorBasedUpgradeClusterTask.access$getUpgradeDir(this.this$0.this, this.$operatorHelper).toFile();
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getUpgradeDir(operatorHelper).toFile()");
                                $this$register.into((Object)FilesKt.resolve((File)file, (String)this.$providerHomePath));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$operatorHelper = operatorHelper;
                                this.$providerHomePath = string;
                            }
                        });
                        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"project.tasks.register(t\u2026h))\n                    }");
                        task = v7;
                        dependencies.add(task);
                    }
                } else {
                    v8 = $this$afterEvaluate.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"project");
                    v8.getLogger().warn("Active provider name is not set - OperatorBasedUpgradeClusterTask");
                }
                upgradeTask.dependsOn(new Object[]{dependencies});
            }
        });
    }

    public static final /* synthetic */ Path access$getUpgradeDir(OperatorBasedUpgradeClusterTask $this, OperatorHelper operatorHelper) {
        return $this.getUpgradeDir(operatorHelper);
    }
}

