/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.Helper$WhenMappings;
import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.domain.profiles.IngressType;
import ai.digital.integration.server.common.domain.profiles.OperatorHelmProfile;
import ai.digital.integration.server.common.domain.providers.Provider;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.ServerUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0006\u0010\u0019\u001a\u00020\u000eJ\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u000eJ\b\u0010 \u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020\u000eJ\b\u0010%\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\u0006\u0010*\u001a\u00020\u000eJ\n\u0010+\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010,\u001a\u00020\u000eH\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0006\u0010.\u001a\u00020\u000eJ\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u000eJ\b\u00102\u001a\u000203H&J\u0006\u00104\u001a\u00020\u000eJ\u0010\u00105\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u00020\u000eJ\u0006\u00109\u001a\u00020\u000eJ\b\u0010:\u001a\u00020\u000eH\u0016J\u001a\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u000e2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\b\u0010?\u001a\u00020@H\u0016J\u0016\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000eJ*\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u001e2\b\b\u0002\u0010G\u001a\u00020\u000e2\b\b\u0002\u0010H\u001a\u00020@J\u000e\u0010I\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u001eJ\u000e\u0010J\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006K"}, d2={"Lai/digital/integration/server/common/cluster/Helper;", "", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "getProductName", "()Lai/digital/integration/server/common/constant/ProductName;", "getProject", "()Lorg/gradle/api/Project;", "clusterMetadata", "", "metaDataPath", "", "contextRoot", "exec", "command", "getCentralConfigImageRepository", "getConfigDir", "Ljava/io/File;", "getContextRootPath", "file", "pathKey", "getCrName", "getDbConnectionCount", "getDbStorageClass", "getDeployWorker", "Lai/digital/integration/server/deploy/domain/Worker;", "getDeployWorkerCount", "", "getDeployWorkerImageRepository", "getFqdn", "getHost", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "getLicense", "getMasterCount", "getMasterPodName", "position", "getMasterPodNameSuffix", "getMqStorageClass", "getName", "getNamespace", "getPort", "getPostgresPodName", "getPrefixName", "getProfile", "Lai/digital/integration/server/common/domain/profiles/OperatorHelmProfile;", "getProfileName", "getProvider", "Lai/digital/integration/server/common/domain/providers/Provider;", "getProviderWorkDir", "getRabbitMqPodName", "getServer", "Lai/digital/integration/server/common/domain/Server;", "getServerImageRepository", "getServerVersion", "getStorageClass", "getTemplate", "relativePath", "targetFilename", "getWorkerPodName", "hasIngress", "", "waitForBoot", "pContextRoot", "fqdn", "waitForDeployment", "ingressType", "deploymentTimeoutSeconds", "namespaceAsPrefix", "skipOperator", "waitForMasterPods", "waitForWorkerPods", "integration-server-gradle-plugin"})
public abstract class Helper {
    @NotNull
    private final Project project;
    @NotNull
    private final ProductName productName;

    @NotNull
    public abstract Provider getProvider();

    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.project, null, false, 4, null);
    }

    public int getMasterCount() {
        int n;
        switch (Helper$WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1: {
                n = DeployServerUtil.Companion.getServers(this.project).size();
                break;
            }
            case 2: {
                n = ReleaseExtensionUtil.Companion.getExtension(this.project).getServers().size();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public int getDeployWorkerCount() {
        return WorkerUtil.Companion.getNumberOfWorkers(this.project);
    }

    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse((Object)"standard");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageClass.getOrElse(\"standard\")");
        return (String)object;
    }

    @NotNull
    public String getDbStorageClass() {
        return this.getStorageClass();
    }

    @NotNull
    public String getMqStorageClass() {
        return this.getStorageClass();
    }

    @NotNull
    public String getFqdn() {
        Object object = this.getProvider().getHost().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().host.getOr\u2026getProvider().name.get())");
        return (String)object;
    }

    @NotNull
    public String getHost() {
        Object object = this.getProvider().getHost().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().host.getOr\u2026getProvider().name.get())");
        return (String)object;
    }

    @NotNull
    public String getPort() {
        return "80";
    }

    public boolean hasIngress() {
        return true;
    }

    @NotNull
    public String getWorkerPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-worker-" + position;
    }

    @NotNull
    public String getMasterPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + '-' + this.getMasterPodNameSuffix(position);
    }

    @NotNull
    public String getPostgresPodName(int position) {
        return "pod/" + this.getCrName() + "-postgresql-" + position;
    }

    @NotNull
    public String getRabbitMqPodName(int position) {
        return "pod/" + this.getCrName() + "-rabbitmq-" + position;
    }

    @Nullable
    public String getNamespace() {
        return (String)this.getProfile().getNamespace().getOrNull();
    }

    @NotNull
    public String getCrName() {
        String string;
        block3: {
            block2: {
                string = this.getNamespace();
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = '-' + it;
                if (string != null) break block3;
            }
            string = "";
        }
        String operatorNamespace = string;
        return "dai-" + this.getPrefixName() + operatorNamespace;
    }

    @NotNull
    public String getMasterPodNameSuffix(int position) {
        String string;
        switch (Helper$WhenMappings.$EnumSwitchMapping$1[this.productName.ordinal()]) {
            case 1: {
                string = "master-" + position;
                break;
            }
            case 2: {
                string = String.valueOf(position);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String getContextRootPath(@NotNull File file, @NotNull String pathKey) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)pathKey, (String)"pathKey");
        Object object = YamlFileUtil.Companion.readFileKey$default(YamlFileUtil.Companion, file, pathKey, false, 4, null);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String pathValue = (String)object;
        switch (Helper$WhenMappings.$EnumSwitchMapping$2[this.productName.ordinal()]) {
            case 1: {
                string = "/xl-deploy";
                break;
            }
            case 2: {
                string = "/xl-release";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String expectedPathValue = string;
        return StringsKt.startsWith$default((String)pathValue, (String)expectedPathValue, (boolean)false, (int)2, null) ? expectedPathValue : "/";
    }

    @NotNull
    public final String getProfileName() {
        String string;
        switch (Helper$WhenMappings.$EnumSwitchMapping$3[this.productName.ordinal()]) {
            case 1: {
                string = DeployClusterUtil.Companion.getProfile(this.project);
                break;
            }
            case 2: {
                string = ReleaseClusterUtil.Companion.getProfile(this.project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final OperatorHelmProfile getProfile() {
        String profileName = this.getProfileName();
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            OperatorHelmProfile operatorHelmProfile;
            switch (Helper$WhenMappings.$EnumSwitchMapping$4[this.productName.ordinal()]) {
                case 1: {
                    operatorHelmProfile = DeployExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().operator();
                    break;
                }
                case 2: {
                    operatorHelmProfile = ReleaseExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().operator();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return operatorHelmProfile;
        }
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.HELM.getProfileName())) {
            OperatorHelmProfile operatorHelmProfile;
            switch (Helper$WhenMappings.$EnumSwitchMapping$5[this.productName.ordinal()]) {
                case 1: {
                    operatorHelmProfile = DeployExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().helm();
                    break;
                }
                case 2: {
                    operatorHelmProfile = ReleaseExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().helm();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return operatorHelmProfile;
        }
        throw (Throwable)new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported");
    }

    @NotNull
    public final String getProviderWorkDir() {
        String path = ((Object)this.project.getBuildDir().toPath().resolve((String)this.getProvider().getName().get() + "-work").toAbsolutePath()).toString();
        new File(path).mkdirs();
        return path;
    }

    @NotNull
    public final String getServerImageRepository() {
        String string = this.getServer().getDockerImage();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public final String getCentralConfigImageRepository() {
        String string = this.getServer().getCentralConfigDockerImage();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public final String getDeployWorkerImageRepository() {
        String string = this.getDeployWorker().getDockerImage();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public final String getServerVersion() {
        String string = this.getServer().getVersion();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public final Server getServer() {
        Server server;
        switch (Helper$WhenMappings.$EnumSwitchMapping$6[this.productName.ordinal()]) {
            case 1: {
                server = DeployServerUtil.Companion.getServer(this.project);
                break;
            }
            case 2: {
                server = ReleaseServerUtil.Companion.getServer(this.project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return server;
    }

    @NotNull
    public final Worker getDeployWorker() {
        return WorkerUtil.Companion.getWorkers(this.project).get(0);
    }

    @NotNull
    public final String getDbConnectionCount() {
        int n;
        switch (Helper$WhenMappings.$EnumSwitchMapping$7[this.productName.ordinal()]) {
            case 1: {
                n = 44 * (this.getMasterCount() + this.getDeployWorkerCount());
                break;
            }
            case 2: {
                n = 33 * this.getMasterCount();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int defaultMaxDbConnections = n;
        return String.valueOf(((Number)this.getProvider().getMaxDbConnections().getOrElse((Object)defaultMaxDbConnections)).intValue());
    }

    @NotNull
    public final String getLicense() {
        String string;
        switch (Helper$WhenMappings.$EnumSwitchMapping$8[this.productName.ordinal()]) {
            case 1: {
                string = "deployit-license.lic";
                break;
            }
            case 2: {
                string = "xl-release-license.lic";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String licenseFileName = string;
        File licenseFile = new File(this.getConfigDir(), licenseFileName);
        String content = Files.readString(licenseFile.toPath());
        Base64.Encoder encoder = Base64.getEncoder();
        String string2 = content;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"content");
        String string3 = string2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string5 = encoder.encodeToString(byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"Base64.getEncoder().enco\u2026ng(content.toByteArray())");
        return string5;
    }

    @NotNull
    public final String getName() {
        String string = this.productName.toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return string3;
    }

    @NotNull
    public final String getPrefixName() {
        String string;
        switch (Helper$WhenMappings.$EnumSwitchMapping$9[this.productName.ordinal()]) {
            case 1: {
                string = "xld";
                break;
            }
            case 2: {
                string = "xlr";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final File getTemplate(@NotNull String relativePath, @Nullable String targetFilename) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        File file = new File(relativePath);
        InputStream fileStream2 = ((Object)((Object)getTemplate.fileStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream(relativePath);
        String string = this.getProviderWorkDir();
        String[] stringArray = new String[1];
        String string2 = targetFilename;
        if (string2 == null) {
            string2 = file.getName();
        }
        stringArray[0] = string2;
        Path resultComposeFilePath = Paths.get(string, stringArray);
        InputStream inputStream = fileStream2;
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream it = inputStream2;
            boolean bl3 = false;
            Path path = resultComposeFilePath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"resultComposeFilePath");
            FileUtil.Companion.copyFile(it, path);
        }
        File file2 = resultComposeFilePath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"resultComposeFilePath.toFile()");
        return file2;
    }

    public static /* synthetic */ File getTemplate$default(Helper helper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTemplate");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return helper.getTemplate(string, string2);
    }

    public final void clusterMetadata(@NotNull String metaDataPath, @NotNull String contextRoot) {
        Intrinsics.checkParameterIsNotNull((Object)metaDataPath, (String)"metaDataPath");
        Intrinsics.checkParameterIsNotNull((Object)contextRoot, (String)"contextRoot");
        Path path = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(this.project, metaDataPath);
        path.getParent().toFile().mkdirs();
        Properties props = new Properties();
        ((Map)props).put("cluster.port", this.getPort());
        ((Map)props).put("cluster.context-root", contextRoot);
        ((Map)props).put("cluster.host", this.getHost());
        ((Map)props).put("cluster.fqdn", this.getFqdn());
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path.toFile()");
        PropertiesUtil.Companion.writePropertiesFile(file, props);
    }

    @NotNull
    public final String exec(@NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, command, null, false, false, 0L, 30, null);
    }

    public final void waitForDeployment(@NotNull String ingressType, int deploymentTimeoutSeconds, @NotNull String namespaceAsPrefix, boolean skipOperator) {
        Object[] objectArray;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)ingressType, (String)"ingressType");
                Intrinsics.checkParameterIsNotNull((Object)namespaceAsPrefix, (String)"namespaceAsPrefix");
                if (!this.hasIngress()) break block5;
                switch (Helper$WhenMappings.$EnumSwitchMapping$10[IngressType.valueOf(ingressType).ordinal()]) {
                    case 1: {
                        String[] stringArray = new String[2];
                        stringArray[0] = "deployment.apps/" + this.getCrName() + "-nginx-ingress-controller";
                        objectArray = stringArray;
                        stringArray[1] = "deployment.apps/" + this.getCrName() + "-nginx-ingress-controller-default-backend";
                        break block6;
                    }
                    case 2: {
                        String[] stringArray = new String[1];
                        objectArray = stringArray;
                        stringArray[0] = "deployment.apps/" + this.getCrName() + "-haproxy-ingress";
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            objectArray = new String[]{};
        }
        Object[] resources = objectArray;
        Object[] $this$forEach$iv = ArraysKt.plus((Object[])resources, (Object)("deployment.apps/" + this.getPrefixName() + "-operator-controller-manager"));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String resource = (String)element$iv;
            boolean bl = false;
            if (skipOperator || this.getKubectlHelper().wait(resource, "Available", deploymentTimeoutSeconds)) continue;
            throw (Throwable)new RuntimeException("Resource " + resource + "  is not available");
        }
    }

    public static /* synthetic */ void waitForDeployment$default(Helper helper, String string, int n, String string2, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: waitForDeployment");
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        helper.waitForDeployment(string, n, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void waitForMasterPods(int deploymentTimeoutSeconds) {
        int n = this.getMasterCount();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        boolean bl3 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void position;
            int n4 = n2++;
            boolean bl4 = false;
            int n5 = n4;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl5 = false;
            String string = this.getMasterPodName((int)position);
            arrayList2.add(string);
        }
        List resources = arrayList;
        Iterable $this$forEach$iv = resources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String resource = (String)element$iv;
            boolean bl6 = false;
            if (this.getKubectlHelper().wait(resource, "Ready", deploymentTimeoutSeconds)) continue;
            throw (Throwable)new RuntimeException("Resource " + resource + " is not ready");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void waitForWorkerPods(int deploymentTimeoutSeconds) {
        int n = this.getDeployWorkerCount();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        boolean bl3 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void position;
            int n4 = n2++;
            boolean bl4 = false;
            int n5 = n4;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl5 = false;
            String string = this.getWorkerPodName((int)position);
            arrayList2.add(string);
        }
        List resources = arrayList;
        Iterable $this$forEach$iv = resources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String resource = (String)element$iv;
            boolean bl6 = false;
            if (this.getKubectlHelper().wait(resource, "Ready", deploymentTimeoutSeconds)) continue;
            throw (Throwable)new RuntimeException("Resource " + resource + " is not ready");
        }
    }

    private final File getConfigDir() {
        File file;
        switch (Helper$WhenMappings.$EnumSwitchMapping$11[this.productName.ordinal()]) {
            case 1: {
                file = DeployServerUtil.Companion.getConfDir(this.project);
                break;
            }
            case 2: {
                file = ReleaseServerUtil.Companion.getConfDir(this.project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return file;
    }

    public final void waitForBoot(@NotNull String pContextRoot, @NotNull String fqdn) {
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)pContextRoot, (String)"pContextRoot");
        Intrinsics.checkParameterIsNotNull((Object)fqdn, (String)"fqdn");
        boolean bl = Intrinsics.areEqual((Object)pContextRoot, (Object)"/");
        if (bl) {
            string2 = "";
        } else if (!bl) {
            string2 = pContextRoot;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String contextRoot = string2;
        switch (Helper$WhenMappings.$EnumSwitchMapping$12[this.productName.ordinal()]) {
            case 1: {
                string = "http://" + fqdn + contextRoot + "/deployit/metadata/type";
                break;
            }
            case 2: {
                string = "http://" + fqdn + contextRoot + "/api/extension/metadata";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String url = string;
        Server server = new ServerUtil(this.project, this.productName).getServer();
        WaitForBootUtil.Companion.byPort$default(WaitForBootUtil.Companion, this.project, this.getName(), url, null, server.getPingRetrySleepTime(), server.getPingTotalTries(), null, 64, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProductName getProductName() {
        return this.productName;
    }

    public Helper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        this.project = project;
        this.productName = productName;
    }
}

