/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.OverlaysUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.tasks.server.DownloadAndExtractServerDistTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/tasks/server/ServerCopyOverlaysTask;", "Lorg/gradle/api/DefaultTask;", "()V", "Companion", "integration-server-gradle-plugin"})
public class ServerCopyOverlaysTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "serverCopyOverlays";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ServerCopyOverlaysTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (!new OperatorUtil(project).isClusterEnabled()) {
            this.mustRunAfter(new Object[]{"centralConfiguration"});
            this.mustRunAfter(new Object[]{"copyServerBuildArtifacts"});
            this.mustRunAfter(new Object[]{DownloadAndExtractServerDistTask.Companion.getNAME()});
            this.finalizedBy(new Object[]{"checkUILibVersions"});
        }
        final ServerCopyOverlaysTask currentTask = this;
        this.getProject().afterEvaluate((Action)new Action<Project>(){

            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkParameterIsNotNull((Object)$this$afterEvaluate, (String)"$receiver");
                Project project = $this$afterEvaluate.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                Iterable $this$forEach$iv = DeployServerUtil.Companion.getServers(project);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Server server = (Server)element$iv;
                    boolean bl = false;
                    Project project2 = $this$afterEvaluate.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    project2.getLogger().lifecycle("Copying overlays on Deploy server " + server.getName());
                    Project project3 = $this$afterEvaluate.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                    OverlaysUtil.Companion.addDatabaseDependency(project3, server);
                    Project project4 = $this$afterEvaluate.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
                    OverlaysUtil.Companion.addMqDependency(project4, server);
                    Map<String, List<Object>> $this$forEach$iv2 = server.getOverlays();
                    boolean $i$f$forEach2 = false;
                    Map<String, List<Object>> map2 = $this$forEach$iv2;
                    boolean bl2 = false;
                    Iterator<Map.Entry<String, List<Object>>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        ArrayList arrayList;
                        Map.Entry<String, List<Object>> element$iv2;
                        Map.Entry<String, List<Object>> overlay = element$iv2 = iterator.next();
                        boolean bl3 = false;
                        Project project5 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
                        Task task2 = (Task)currentTask;
                        Project project6 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
                        String string = DeployServerUtil.Companion.getServerWorkingDir(project6, server);
                        Project project7 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
                        if (DeployServerUtil.Companion.isDistDownloadRequired(project7, server)) {
                            arrayList = CollectionsKt.arrayListOf((Object[])new String[]{DownloadAndExtractServerDistTask.Companion.getNAME() + server.getName()});
                        } else {
                            boolean bl4 = false;
                            arrayList = new ArrayList();
                        }
                        OverlaysUtil.Companion.defineOverlay(project5, task2, string, "deployIntegrationServer", overlay, arrayList, server.getName());
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/ServerCopyOverlaysTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

