/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.helm;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.helm.HelmHelper;
import ai.digital.integration.server.common.cluster.setup.AzureAksHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.providers.AzureAksProvider;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/digital/integration/server/common/cluster/helm/AzureAksHelmHelper;", "Lai/digital/integration/server/common/cluster/helm/HelmHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "azureAksHelper", "Lai/digital/integration/server/common/cluster/setup/AzureAksHelper;", "getDbStorageClass", "", "getFqdn", "getProvider", "Lai/digital/integration/server/common/domain/providers/AzureAksProvider;", "getStorageClass", "helmInstallCluster", "", "launchCluster", "setupHelmValues", "shutdownCluster", "updateCustomHelmValues", "valuesFile", "Ljava/io/File;", "integration-server-gradle-plugin"})
public class AzureAksHelmHelper
extends HelmHelper {
    private final AzureAksHelper azureAksHelper;

    public final void launchCluster() {
        this.azureAksHelper.launchCluster();
    }

    public final void setupHelmValues() {
        this.copyValuesYamlFile();
        this.updateHelmValuesYaml();
        this.updateHelmDependency();
    }

    public final void helmInstallCluster() {
        this.installCluster();
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProfile().ingressType.get()");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProfile().deploymentTimeoutSeconds.get()");
        Helper.waitForDeployment$default(this, string, ((Number)object2).intValue(), null, true, 4, null);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"getProfile().deploymentTimeoutSeconds.get()");
        this.waitForWorkerPods(((Number)object4).intValue());
        this.createClusterMetadata();
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
    }

    public final void shutdownCluster() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.name.get()");
        String name = (String)object;
        String groupName = this.azureAksHelper.resourceGroupName(name);
        Object object2 = azureAksProvider.getLocation().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"azureAksProvider.location.get()");
        String location = (String)object2;
        boolean existsResourceGroup = this.azureAksHelper.existsResourceGroup(groupName, location);
        if (existsResourceGroup) {
            this.helmCleanUpCluster();
            this.getKubectlHelper().deleteAllPVCs();
        }
        this.azureAksHelper.destroyClusterOnShutdown(existsResourceGroup, name, groupName, location);
    }

    @Override
    @NotNull
    public AzureAksProvider getProvider() {
        return this.getProfile().getAzureAks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return this.azureAksHelper.getStorageClass();
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        return this.azureAksHelper.getDbStorageClass();
    }

    @Override
    public void updateCustomHelmValues(@NotNull File valuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)valuesFile, (String)"valuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"nginx-ingress-controller.service.annotations", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"service.beta.kubernetes.io/azure-dns-label-name", (Object)this.getHost()))), TuplesKt.to((Object)"haproxy-ingress.controller.service.annotations", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"service.beta.kubernetes.io/azure-dns-label-name", (Object)this.getHost()))), TuplesKt.to((Object)"ingress.hosts", (Object)new String[]{this.getFqdn()})});
        YamlFileUtil.Companion.overlayFile(valuesFile, pairs, false);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.azureAksHelper.getFqdn();
    }

    public AzureAksHelmHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.azureAksHelper = new AzureAksHelper(project, productName, this.getProfile());
    }
}

