/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.util.GitUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/operator/ProvideDeployKubernetesOperatorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "cloneRepository", "", "branch", "", "copyCurrentRepository", "operatorHelper", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "launch", "Companion", "integration-server-gradle-plugin"})
public class ProvideDeployKubernetesOperatorTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "provideDeployKubernetesOperator";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project, ProductName.DEPLOY);
        if (operatorHelper.getProvider().getOperatorBranch().isPresent()) {
            Object object = operatorHelper.getProvider().getOperatorBranch().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"operatorHelper.getProvider().operatorBranch.get()");
            String branch = (String)object;
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            project2.getLogger().lifecycle("Checking out xl-deploy-kubernetes-operator branch " + branch);
            this.cloneRepository(branch);
        } else if (operatorHelper.getProvider().getOperatorPackageVersion().isPresent()) {
            Object object = operatorHelper.getProvider().getOperatorPackageVersion().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"operatorHelper.getProvid\u2026ratorPackageVersion.get()");
            String version = (String)object;
            Project project3 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            project3.getLogger().lifecycle("Downloading package xl-deploy-kubernetes-operator version " + version);
        } else {
            Project project4 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
            project4.getLogger().lifecycle("Using current repository as operator source");
            this.copyCurrentRepository(operatorHelper);
        }
    }

    private final void cloneRepository(String branch) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Path path = project.getBuildDir().toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"project.buildDir.toPath()");
        GitUtil.Companion.checkout("xl-deploy-kubernetes-operator", path, branch);
    }

    private final void copyCurrentRepository(OperatorHelper operatorHelper) {
        String providerHomePath = operatorHelper.getProviderHomePath();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootDir");
        FilesKt.copyRecursively$default((File)FilesKt.resolve((File)file, (String)providerHomePath), (File)new File(operatorHelper.getProviderHomeDir()), (boolean)true, null, (int)4, null);
    }

    public ProvideDeployKubernetesOperatorTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (DeployExtensionUtil.Companion.getExtension(project).getClusterProfiles().operator().getActiveProviderName().isPresent()) {
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project2, ProductName.DEPLOY);
            if (operatorHelper.getProvider().getOperatorPackageVersion().isPresent()) {
                Project project3 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                ScriptHandler scriptHandler = project3.getBuildscript();
                Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
                scriptHandler.getDependencies().add("operatorDist", (Object)("ai.digital.deploy.operator:" + operatorHelper.getProviderHomePath() + ':' + (String)operatorHelper.getProvider().getOperatorPackageVersion().get() + "@zip"));
                String taskName = "downloadAndExtractOperator" + operatorHelper.getProviderHomePath();
                Project project4 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
                TaskProvider taskProvider = project4.getTasks().register(taskName, Copy.class, (Action)new Action<Copy>(operatorHelper){
                    final /* synthetic */ OperatorHelper $operatorHelper;

                    public final void execute(@NotNull Copy $this$register) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$register, (String)"$receiver");
                        Object[] objectArray = new Object[1];
                        Project project = $this$register.getProject();
                        Project project2 = $this$register.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                        ScriptHandler scriptHandler = project2.getBuildscript();
                        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
                        Configuration configuration = scriptHandler.getConfigurations().getByName("operatorDist");
                        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.buildscript.conf\u2026ationsUtil.OPERATOR_DIST)");
                        objectArray[0] = project.zipTree((Object)configuration.getSingleFile());
                        $this$register.from(objectArray);
                        $this$register.into((Object)this.$operatorHelper.getProviderHomeDir());
                    }
                    {
                        this.$operatorHelper = operatorHelper;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(t\u2026eDir())\n                }");
                TaskProvider task2 = taskProvider;
                this.dependsOn(new Object[]{task2});
            }
        } else {
            Project project5 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
            project5.getLogger().warn("Active provider name is not set - ProvideDeployKubernetesOperatorTask");
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/operator/ProvideDeployKubernetesOperatorTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

