/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.setup;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.OnPremHelper;
import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.providers.OnPremiseProvider;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\bH\u0002J\u0006\u0010\u0014\u001a\u00020\bJ\b\u0010\u0015\u001a\u00020\nH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\bJ\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\nJ\b\u0010\u001f\u001a\u00020\bH\u0002\u00a8\u0006 "}, d2={"Lai/digital/integration/server/common/cluster/setup/OnPremHelper;", "Lai/digital/integration/server/common/cluster/Helper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "createCluster", "", "name", "", "driver", "clusterNodeCpus", "Lorg/gradle/api/provider/Property;", "", "clusterNodeMemory", "kubernetesVersion", "skipExisting", "", "deleteCluster", "destroyClusterOnShutdown", "getFqdn", "getMinikubeIp", "getProvider", "Lai/digital/integration/server/common/domain/providers/OnPremiseProvider;", "launchCluster", "onPremClusterName", "shouldSkipExisting", "updateContext", "updateEtcHosts", "fqdn", "validateMinikubeCli", "integration-server-gradle-plugin"})
public class OnPremHelper
extends Helper {
    @Override
    @NotNull
    public OnPremiseProvider getProvider() {
        String profileName = this.getProfileName();
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            return OperatorHelper.Companion.getOperatorHelper(this.getProject(), this.getProductName()).getProfile().getOnPremise();
        }
        throw (Throwable)new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported");
    }

    public final void launchCluster() {
        OnPremiseProvider onPremiseProvider = this.getProvider();
        Object object = onPremiseProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"onPremiseProvider.name.get()");
        String name = (String)object;
        Object object2 = onPremiseProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"onPremiseProvider.skipExisting.get()");
        boolean skipExisting = (Boolean)object2;
        Object object3 = onPremiseProvider.getKubernetesVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"onPremiseProvider.kubernetesVersion.get()");
        String kubernetesVersion = (String)object3;
        Object object4 = onPremiseProvider.getDriver().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"onPremiseProvider.driver.get()");
        String driver = (String)object4;
        this.validateMinikubeCli();
        this.createCluster(name, driver, onPremiseProvider.getClusterNodeCpus(), onPremiseProvider.getClusterNodeMemory(), kubernetesVersion, skipExisting);
        this.updateContext(name);
        OnPremHelper.updateEtcHosts$default(this, name, null, 2, null);
    }

    private final void validateMinikubeCli() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube version", null, bl, bl2, l, 36, null);
        if (!StringsKt.contains$default((CharSequence)result, (CharSequence)"minikube version", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("No minikube-cli \"minikube\" in the path. Please verify your installation");
        }
    }

    private final void createCluster(String name, String driver, Property<Integer> clusterNodeCpus, Property<Integer> clusterNodeMemory, String kubernetesVersion, boolean skipExisting) {
        String clusterName = this.onPremClusterName(name);
        boolean shouldSkipExisting = this.shouldSkipExisting(name, skipExisting);
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing minikube cluster: {}", new Object[]{clusterName});
        } else {
            this.getProject().getLogger().lifecycle("Create minikube cluster: {}", new Object[]{clusterName});
            String additions2 = (String)clusterNodeCpus.map((Transformer)createCluster.additions.1.INSTANCE).getOrElse((Object)"") + (String)clusterNodeMemory.map((Transformer)createCluster.additions.2.INSTANCE).getOrElse((Object)"");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube start --driver=" + driver + " --kubernetes-version \"" + kubernetesVersion + "\" -p " + clusterName + ' ' + additions2, null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube addons enable ingress -p " + clusterName, null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube addons enable ingress-dns -p " + clusterName, null, false, false, 0L, 60, null);
        }
    }

    private final String onPremClusterName(String name) {
        return name;
    }

    private final boolean shouldSkipExisting(String name, boolean skipExisting) {
        boolean bl;
        String clusterName = this.onPremClusterName(name);
        if (skipExisting) {
            long l = 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            String profileListResult = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile list | grep " + clusterName, null, bl2, bl3, l, 36, null);
            if (StringsKt.contains$default((CharSequence)profileListResult, (CharSequence)clusterName, (boolean)false, (int)2, null)) {
                long l2 = 0L;
                bl3 = false;
                boolean bl4 = false;
                String profileResult = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile", null, bl3, bl4, l2, 36, null);
                if (!StringsKt.contains$default((CharSequence)profileResult, (CharSequence)clusterName, (boolean)false, (int)2, null)) {
                    ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile " + clusterName, null, false, false, 0L, 52, null);
                }
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void updateContext(String name) {
        String clusterName = this.onPremClusterName(name);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube update-context -p " + clusterName, null, false, false, 0L, 44, null);
    }

    public final void updateEtcHosts(@NotNull String name, @NotNull String fqdn) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)fqdn, (String)"fqdn");
        File infoScriptPath = Helper.getTemplate$default(this, "operator/on-perm/info_etc_hosts.sh", null, 2, null);
        File scriptPath = Helper.getTemplate$default(this, "operator/on-perm/update_etc_hosts.sh", null, 2, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "chmod 755 \"" + infoScriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "chmod 755 \"" + scriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), '\"' + infoScriptPath.getAbsolutePath() + '\"', null, false, false, 0L, 44, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "sudo \"" + scriptPath.getAbsolutePath() + "\" " + this.getMinikubeIp(name) + " \"" + fqdn + '\"', null, false, false, 0L, 44, null);
    }

    public static /* synthetic */ void updateEtcHosts$default(OnPremHelper onPremHelper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateEtcHosts");
        }
        if ((n & 2) != 0) {
            string2 = onPremHelper.getFqdn();
        }
        onPremHelper.updateEtcHosts(string, string2);
    }

    private final String getMinikubeIp(String name) {
        String string;
        String clusterName = this.onPremClusterName(name);
        try {
            String ip = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube -p " + clusterName + " ip", null, false, false, 0L, 52, null);
            this.getProject().getLogger().lifecycle("Get cluster IP for {}: {}", new Object[]{clusterName, ip});
        }
        catch (RuntimeException e) {
            string = null;
        }
        return string;
    }

    public final void destroyClusterOnShutdown() {
        Object object = this.getProvider().getDestroyClusterOnShutdown().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().destroyClusterOnShutdown.get()");
        if (((Boolean)object).booleanValue()) {
            this.deleteCluster();
            this.getProject().getLogger().lifecycle("Current cluster context is being deleted");
            this.getKubectlHelper().deleteCurrentContext();
        }
    }

    private final void deleteCluster() {
        OnPremiseProvider onPremiseProvider = this.getProvider();
        Object object = onPremiseProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"onPremiseProvider.name.get()");
        String name = (String)object;
        String clusterName = this.onPremClusterName(name);
        this.getProject().getLogger().lifecycle("Minikube cluster is being deleted {} ", new Object[]{clusterName});
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube delete -p " + clusterName, null, false, false, 0L, 44, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getHost() + ".digitalai-testing.com";
    }

    public OnPremHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
    }
}

