/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.AzureAksHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.AzureAksProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0006\u0010\u0019\u001a\u00020\u0012\u00a8\u0006\u001a"}, d2={"Lai/digital/integration/server/common/cluster/operator/AzureAksOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "getAccessToken", "", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "getDbStorageClass", "getFqdn", "getProvider", "Lai/digital/integration/server/common/domain/providers/AzureAksProvider;", "getProviderHomePath", "getStorageClass", "installCluster", "", "shutdownCluster", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "updateInfrastructure", "infraInfo", "updateOperator", "integration-server-gradle-plugin"})
public class AzureAksOperatorHelper
extends OperatorHelper {
    public final void updateOperator() {
        Object object = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().cleanUpWaitTimeout.get()");
        this.cleanUpCluster((Duration)object);
        InfrastructureInfo kubeContextInfo = this.getCurrentContextInfo();
        this.updateInfrastructure(kubeContextInfo);
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        this.turnOnLogging();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.createClusterMetadata();
        this.waitForBoot();
        this.turnOffLogging();
    }

    public final void shutdownCluster() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.name.get()");
        String name = (String)object;
        String groupName = new AzureAksHelper(this.getProject(), this.getProductName()).resourceGroupName(name);
        Object object2 = azureAksProvider.getLocation().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"azureAksProvider.location.get()");
        String location = (String)object2;
        boolean existsResourceGroup = new AzureAksHelper(this.getProject(), this.getProductName()).existsResourceGroup(groupName, location);
        if (existsResourceGroup) {
            this.undeployCluster();
        }
        new AzureAksHelper(this.getProject(), this.getProductName()).destroyClusterOnShutdown(existsResourceGroup, name, groupName, location);
    }

    private final void updateInfrastructure(InfrastructureInfo infraInfo) {
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Pair[] pairArray = new Pair[4];
        String string = infraInfo.getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        String string3 = infraInfo.getTlsCert();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].tlsCert", (Object)string3);
        String string4 = infraInfo.getTlsPrivateKey();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].tlsPrivateKey", (Object)string4);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-azure-aks";
    }

    @Override
    @NotNull
    public AzureAksProvider getProvider() {
        return this.getProfile().getAzureAks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return new AzureAksHelper(this.getProject(), this.getProductName()).getStorageClass();
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        return new AzureAksHelper(this.getProject(), this.getProductName()).getDbStorageClass();
    }

    @Override
    @NotNull
    public String getFqdn() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getLocation().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.location.get()");
        String location = (String)object;
        return this.getHost() + '.' + location + ".cloudapp.azure.com";
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)crValuesFile, (String)"crValuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.nginx-ingress-controller.service.annotations", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"service.beta.kubernetes.io/azure-dns-label-name", (Object)this.getHost()))), TuplesKt.to((Object)"spec.haproxy-ingress.controller.service.annotations", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"service.beta.kubernetes.io/azure-dns-label-name", (Object)this.getHost()))), TuplesKt.to((Object)"spec.ingress.hosts", (Object)new String[]{this.getFqdn()})});
        YamlFileUtil.Companion.overlayFile(crValuesFile, pairs, false);
    }

    @Override
    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        return KubeCtlHelper.getCurrentContextInfo$default(this.getKubectlHelper(), false, 1, null);
    }

    @NotNull
    public final String getAccessToken() {
        Map azConfigMap;
        String azToken = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az account get-access-token -o yaml", null, false, false, 0L, 60, null);
        Map map2 = azConfigMap = (Map)new ObjectMapper((JsonFactory)YAMLFactory.builder().build()).readValue(azToken, Map.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"azConfigMap");
        Map map3 = map2;
        String string = "accessToken";
        boolean bl = false;
        Object v = map3.get(string);
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)v;
    }

    public AzureAksOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
    }
}

