/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.AwsEksHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.AwsEksProvider;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u0006\u0010\u0018\u001a\u00020\u0012\u00a8\u0006\u0019"}, d2={"Lai/digital/integration/server/common/cluster/operator/AwsEksOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "getDbStorageClass", "", "getFqdn", "getMqStorageClass", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsEksProvider;", "getProviderHomePath", "getStorageClass", "installCluster", "", "shutdownCluster", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "updateInfrastructure", "updateOperator", "integration-server-gradle-plugin"})
public class AwsEksOperatorHelper
extends OperatorHelper {
    public final void updateOperator() {
        Object object = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().cleanUpWaitTimeout.get()");
        this.cleanUpCluster((Duration)object);
        this.updateInfrastructure();
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.createClusterMetadata();
        new AwsEksHelper(this.getProject(), this.getProductName()).updateRoute53(this.getFqdn());
        this.waitForBoot();
    }

    public final void shutdownCluster() {
        this.undeployCluster();
        new AwsEksHelper(this.getProject(), this.getProductName()).destroyClusterOnShutdown();
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)crValuesFile, (String)"crValuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.ingress.hosts", (Object)new String[]{this.getFqdn()}), TuplesKt.to((Object)"spec.rabbitmq.persistence.storageClass", (Object)"gp2")});
        YamlFileUtil.Companion.overlayFile(crValuesFile, pairs, false);
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-aws-eks";
    }

    @Override
    @NotNull
    public AwsEksProvider getProvider() {
        return this.getProfile().getAwsEks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return new AwsEksHelper(this.getProject(), this.getProductName()).getStorageClass();
    }

    private final void updateInfrastructure() {
        InfrastructureInfo infraInfo = this.getCurrentContextInfo();
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        AwsEksProvider awsEksProvider = this.getProvider();
        Pair[] pairArray = new Pair[6];
        String string = infraInfo.getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].accessKey", (Object)awsEksProvider.getAwsAccessKey());
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].accessSecret", (Object)awsEksProvider.getAwsSecretKey());
        pairArray[4] = TuplesKt.to((Object)"spec[0].children[0].regionName", (Object)awsEksProvider.getRegion().get());
        pairArray[5] = TuplesKt.to((Object)"spec[0].children[0].clusterName", (Object)awsEksProvider.getClusterName().get());
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        StringBuilder stringBuilder = new StringBuilder().append((String)this.getProvider().getStack().get()).append('-').append(this.getName()).append('-');
        String string = this.getNamespace();
        if (string == null) {
            string = "default";
        }
        return stringBuilder.append(string).append(".digitalai-testing.com").toString();
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        return "gp2";
    }

    @Override
    @NotNull
    public String getMqStorageClass() {
        return "gp2";
    }

    @Override
    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        return this.getKubectlHelper().getCurrentContextInfo(true);
    }

    public AwsEksOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
    }
}

