/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.OnPremHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.OnPremiseProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u000f\u00a8\u0006\u0017"}, d2={"Lai/digital/integration/server/common/cluster/operator/OnPremOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "getFqdn", "", "getProvider", "Lai/digital/integration/server/common/domain/providers/OnPremiseProvider;", "getProviderHomePath", "installCluster", "", "shutdownCluster", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "updateInfrastructure", "infraInfo", "updateOperator", "integration-server-gradle-plugin"})
public class OnPremOperatorHelper
extends OperatorHelper {
    public final void updateOperator() {
        OnPremHelper onPremHelper = new OnPremHelper(this.getProject(), this.getProductName());
        Object object = this.getProvider().getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().name.get()");
        onPremHelper.updateEtcHosts((String)object, this.getFqdn());
        Object object2 = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProvider().cleanUpWaitTimeout.get()");
        this.cleanUpCluster((Duration)object2);
        InfrastructureInfo kubeContextInfo = this.getCurrentContextInfo();
        this.updateInfrastructure(kubeContextInfo);
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.createClusterMetadata();
        this.waitForBoot();
    }

    public final void shutdownCluster() {
        this.undeployCluster();
        new OnPremHelper(this.getProject(), this.getProductName()).destroyClusterOnShutdown();
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-onprem";
    }

    @Override
    @NotNull
    public OnPremiseProvider getProvider() {
        return new OnPremHelper(this.getProject(), this.getProductName()).getProvider();
    }

    public final void updateInfrastructure(@NotNull InfrastructureInfo infraInfo) {
        Intrinsics.checkParameterIsNotNull((Object)infraInfo, (String)"infraInfo");
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Pair[] pairArray = new Pair[4];
        String string = infraInfo.getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        String string3 = infraInfo.getTlsCert();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].tlsCert", (Object)string3);
        String string4 = infraInfo.getTlsPrivateKey();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].tlsPrivateKey", (Object)string4);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getHost() + ".digitalai-testing.com";
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)crValuesFile, (String)"crValuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.ingress.hosts", (Object)CollectionsKt.listOf((Object)this.getFqdn())), TuplesKt.to((Object)"spec.nginx-ingress-controller.defaultBackend.podSecurityContext", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"fsGroup", (Object)1001))), TuplesKt.to((Object)"spec.nginx-ingress-controller.podSecurityContext", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"fsGroup", (Object)1001)))});
        YamlFileUtil.Companion.overlayFile(crValuesFile, pairs, false);
    }

    @Override
    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        return KubeCtlHelper.getCurrentContextInfo$default(this.getKubectlHelper(), false, 1, null);
    }

    public OnPremOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
    }
}

