/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.GcpGkeHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.GcpGkeProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00132\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\rH\u0002J\u0006\u0010\u001a\u001a\u00020\u0013\u00a8\u0006\u001b"}, d2={"Lai/digital/integration/server/common/cluster/operator/GcpGkeOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "getAccessToken", "", "accountName", "projectName", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "Lkotlin/Pair;", "getFqdn", "getProvider", "Lai/digital/integration/server/common/domain/providers/GcpGkeProvider;", "getProviderHomePath", "installCluster", "", "shutdownCluster", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "updateInfrastructure", "kubeContextInfo", "updateOperator", "integration-server-gradle-plugin"})
public class GcpGkeOperatorHelper
extends OperatorHelper {
    public final void updateOperator() {
        Object object = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().cleanUpWaitTimeout.get()");
        this.cleanUpCluster((Duration)object);
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object2 = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object2;
        Object object3 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object3;
        Pair<InfrastructureInfo, String> kubeContextInfo = this.getCurrentContextInfo(accountName, projectName);
        this.updateInfrastructure(kubeContextInfo);
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        String ip = this.getKubectlHelper().getServiceExternalIp("service/dai-" + this.getPrefixName() + "-nginx-ingress-controller");
        String string = this.getNamespace();
        if (string == null) {
            string = "default";
        }
        String nameSpace = string;
        new GcpGkeHelper(this.getProject(), this.getProductName()).applyDnsOpenApi(ip, this.getFqdn(), this.getHost(), nameSpace);
        this.createClusterMetadata();
        this.waitForBoot();
    }

    public final void shutdownCluster() {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.name.get()");
        String name = (String)object2;
        Object object3 = gcpGkeProvider.getRegionZone().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.regionZone.get()");
        String regionZone = (String)object3;
        Object object4 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object4;
        boolean existsCluster = new GcpGkeHelper(this.getProject(), this.getProductName()).existsCluster(accountName, projectName, name, regionZone);
        if (existsCluster) {
            this.undeployCluster();
        }
        new GcpGkeHelper(this.getProject(), this.getProductName()).destroyClusterOnShutdown(existsCluster, accountName, projectName, name, regionZone, this.getFqdn());
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-gcp-gke";
    }

    @Override
    @NotNull
    public GcpGkeProvider getProvider() {
        return new GcpGkeHelper(this.getProject(), this.getProductName()).getProvider();
    }

    @Override
    @NotNull
    public String getFqdn() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getProductName().getShortName()).append('-').append(this.getHost()).append('-');
        String string = this.getNamespace();
        if (string == null) {
            string = "default";
        }
        return stringBuilder.append(string).append(".endpoints.").append((String)this.getProvider().getProjectName().get()).append(".cloud.goog").toString();
    }

    private final Pair<InfrastructureInfo, String> getCurrentContextInfo(String accountName, String projectName) {
        KubeCtlHelper kubectlHelper = this.getKubectlHelper();
        String context = kubectlHelper.getCurrentContext();
        String cluster = kubectlHelper.getContextCluster(context);
        String user = kubectlHelper.getContextUser(context);
        InfrastructureInfo info = new InfrastructureInfo(cluster, user, kubectlHelper.getClusterServer(cluster), kubectlHelper.getClusterCertificateAuthorityData(cluster), null, null);
        String accessToken = this.getAccessToken(accountName, projectName);
        return new Pair((Object)info, (Object)accessToken);
    }

    private final String getAccessToken(String accountName, String projectName) {
        Map gcloudConfigMap;
        String gcloudConfig = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud config --account \"" + accountName + "\" --project \"" + projectName + "\" config-helper --format=yaml", null, false, false, 0L, 60, null);
        Map map2 = gcloudConfigMap = (Map)new ObjectMapper((JsonFactory)YAMLFactory.builder().build()).readValue(gcloudConfig, Map.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"gcloudConfigMap");
        Map map3 = map2;
        String string = "credential";
        boolean bl = false;
        Object v = map3.get(string);
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        }
        map3 = (Map)v;
        string = "access_token";
        bl = false;
        Object v2 = map3.get(string);
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)v2;
    }

    private final void updateInfrastructure(Pair<? extends InfrastructureInfo, String> kubeContextInfo) {
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Pair[] pairArray = new Pair[3];
        String string = ((InfrastructureInfo)kubeContextInfo.getFirst()).getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = ((InfrastructureInfo)kubeContextInfo.getFirst()).getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].token", (Object)kubeContextInfo.getSecond());
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkParameterIsNotNull((Object)crValuesFile, (String)"crValuesFile");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.ingress.hosts", (Object)CollectionsKt.listOf((Object)this.getFqdn()))});
        YamlFileUtil.Companion.overlayFile(crValuesFile, pairs, false);
    }

    @Override
    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        Object object = this.getProvider().getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().projectName.get()");
        String projectName = (String)object;
        Object object2 = this.getProvider().getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProvider().accountName.get()");
        String accountName = (String)object2;
        return (InfrastructureInfo)this.getCurrentContextInfo(accountName, projectName).getFirst();
    }

    @NotNull
    public final String getAccessToken() {
        Object object = this.getProvider().getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().projectName.get()");
        String projectName = (String)object;
        Object object2 = this.getProvider().getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getProvider().accountName.get()");
        String accountName = (String)object2;
        return this.getAccessToken(accountName, projectName);
    }

    public GcpGkeOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
    }
}

