/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cluster.operator;

import ai.digital.integration.server.common.constant.OperatorProviderName;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/operator/OperatorBasedInstallDeployClusterTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
public class OperatorBasedInstallDeployClusterTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "operatorBasedInstallDeployCluster";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String providerName = DeployClusterUtil.Companion.getOperatorProvider(project);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        project2.getLogger().lifecycle("Operator based Deploy Cluster with provider " + providerName + " has started.");
    }

    public OperatorBasedInstallDeployClusterTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (DeployExtensionUtil.Companion.getExtension(project).getClusterProfiles().operator().getActiveProviderName().isPresent()) {
            String string;
            Object[] objectArray = new Object[2];
            objectArray[0] = "downloadAndExtractCli";
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            String providerName = DeployClusterUtil.Companion.getOperatorProvider(project2);
            if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.AWS_EKS.getProviderName())) {
                string = "operatorBasedAwsEksInstallDeployCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.AWS_OPENSHIFT.getProviderName())) {
                string = "operatorBasedAwsOpenShiftInstallDeployCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.AZURE_AKS.getProviderName())) {
                string = "operatorBasedAzureAksInstallDeployCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.GCP_GKE.getProviderName())) {
                string = "operatorBasedGcpGkeInstallDeployCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.ON_PREMISE.getProviderName())) {
                string = "operatorBasedOnPremInstallDeployCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.VMWARE_OPENSHIFT.getProviderName())) {
                string = "operatorBasedVmWareOpenShiftInstallDeployCluster";
            } else {
                throw (Throwable)new IllegalArgumentException("Provided operator provider name `" + providerName + "` is not supported. Choose one of " + ArraysKt.joinToString$default((Object[])OperatorProviderName.values(), null, null, null, (int)0, null, null, (int)63, null));
            }
            objectArray[1] = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.dependsOn(objectArray), (String)"this.dependsOn(\n        \u2026         }\n            })");
        } else {
            Project project3 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            project3.getLogger().warn("Active provider name is not set - OperatorBasedInstallDeployClusterTask");
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/operator/OperatorBasedInstallDeployClusterTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

