/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tasks.infrastructure;

import ai.digital.integration.server.common.domain.Infrastructure;
import ai.digital.integration.server.common.util.InfrastructureUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/common/tasks/infrastructure/InfrastructureStartTask;", "Lorg/gradle/api/DefaultTask;", "()V", "getDescription", "", "run", "", "startDockerContainers", "infrastructure", "Lai/digital/integration/server/common/domain/Infrastructure;", "Companion", "integration-server-gradle-plugin"})
public abstract class InfrastructureStartTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "infrastructureStart";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getDescription() {
        return "Starts infrastructures.";
    }

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Starting infrastructures.");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Iterable $this$forEach$iv = InfrastructureUtil.Companion.getInfrastructures(project2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Infrastructure infrastructure = (Infrastructure)element$iv;
            boolean bl = false;
            if (!infrastructure.isDockerBased()) continue;
            this.startDockerContainers(infrastructure);
        }
    }

    private final void startDockerContainers(Infrastructure infrastructure) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Starting infrastructure " + infrastructure.getName() + " using `docker-compose`");
        boolean bl = false;
        ArrayList<String> dockerComposeArgs = new ArrayList<String>();
        Iterable $this$forEach$iv = infrastructure.getDockerComposeFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String dockerComposeFile = (String)element$iv;
            boolean bl2 = false;
            dockerComposeArgs.add("-f");
            dockerComposeArgs.add(dockerComposeFile);
        }
        dockerComposeArgs.add("up");
        dockerComposeArgs.add("-d");
        this.getProject().exec((Action)new Action<ExecSpec>(dockerComposeArgs){
            final /* synthetic */ ArrayList $dockerComposeArgs;

            public final void execute(@NotNull ExecSpec $this$exec) {
                Intrinsics.checkParameterIsNotNull((Object)$this$exec, (String)"$receiver");
                $this$exec.setExecutable("docker-compose");
                $this$exec.setArgs((List)this.$dockerComposeArgs);
            }
            {
                this.$dockerComposeArgs = arrayList;
            }
        });
    }

    public InfrastructureStartTask() {
        this.setGroup("Integration Server");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/tasks/infrastructure/InfrastructureStartTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

