/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/internals/CentralConfigurationServerUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class CentralConfigurationServerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u001f\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004\u00a8\u0006\u0018"}, d2={"Lai/digital/integration/server/deploy/internals/CentralConfigurationServerUtil$Companion;", "", "()V", "getBaseUrl", "", "project", "Lorg/gradle/api/Project;", "getBinDir", "Ljava/io/File;", "cc", "Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;", "getCentralConfigurationServer", "getDebugPort", "", "(Lorg/gradle/api/Project;Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;)Ljava/lang/Integer;", "getLogDir", "getServerPath", "Ljava/nio/file/Path;", "getVersion", "hasCentralConfigurationServer", "", "logFileName", "readDeployitConfProperty", "key", "integration-server-gradle-plugin"})
    public static final class Companion {
        public final boolean hasCentralConfigurationServer(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return ((CentralConfigurationServer)DeployExtensionUtil.Companion.getExtension(project).getCentralConfigurationServer().get()).getEnable();
        }

        @NotNull
        public final CentralConfigurationServer getCentralConfigurationServer(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = DeployExtensionUtil.Companion.getExtension(project).getCentralConfigurationServer().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"DeployExtensionUtil.getE\u2026ConfigurationServer.get()");
            CentralConfigurationServer cc = (CentralConfigurationServer)object;
            cc.setVersion(this.getVersion(project, cc));
            cc.setDebugPort(this.getDebugPort(project, cc));
            return cc;
        }

        private final Integer getDebugPort(Project project, CentralConfigurationServer cc) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "ccDebugPort", cc.getDebugPort()) : null;
        }

        private final String getVersion(Project project, CentralConfigurationServer cc) {
            String string;
            if (project.hasProperty("centralConfigurationVersion")) {
                string = String.valueOf(project.property("centralConfigurationVersion"));
            } else {
                CharSequence charSequence = cc.getVersion();
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    string = cc.getVersion();
                } else {
                    charSequence = DeployServerUtil.Companion.getServer(project).getVersion();
                    bl = false;
                    bl2 = false;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        string = DeployServerUtil.Companion.getServer(project).getVersion();
                    } else {
                        project.getLogger().error("Central Configuration Server Version is not specified");
                        int n = 1;
                        bl = false;
                        System.exit(n);
                        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                }
            }
            return string;
        }

        @NotNull
        public final Path getServerPath(@NotNull Project project, @NotNull CentralConfigurationServer cc) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)cc, (String)"cc");
            String targetDir = ((Object)DeployServerUtil.Companion.getServerDistFolderPath(project)).toString();
            Path path = Paths.get(targetDir, "central-configuration-" + cc.getVersion() + "-server").toAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(targetDir, \"ce\u2026server\").toAbsolutePath()");
            return path;
        }

        @NotNull
        public final File getBinDir(@NotNull Project project, @NotNull CentralConfigurationServer cc) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)cc, (String)"cc");
            File file = Paths.get(((Object)this.getServerPath(project, cc)).toString(), "bin").toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Paths.get(getServerPath(\u2026String(), \"bin\").toFile()");
            return file;
        }

        @NotNull
        public final File getLogDir(@NotNull Project project, @NotNull CentralConfigurationServer cc) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)cc, (String)"cc");
            File file = Paths.get(((Object)this.getServerPath(project, cc)).toString(), "log").toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Paths.get(getServerPath(\u2026String(), \"log\").toFile()");
            return file;
        }

        @NotNull
        public final String readDeployitConfProperty(@NotNull Project project, @NotNull String key) {
            File deployitConf;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            File file = deployitConf = Paths.get(this.getServerPath(project, this.getCentralConfigurationServer(project)) + "/conf/deployit.conf", new String[0]).toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"deployitConf");
            return PropertiesUtil.Companion.readProperty(file, key);
        }

        @NotNull
        public final String logFileName() {
            return "central-config";
        }

        @NotNull
        public final String getBaseUrl(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return "http://localhost:" + this.readDeployitConfProperty(project, "http.port");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

