/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.util.CacheUtil;
import ai.digital.integration.server.common.util.OverlaysUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/WorkerOverlaysTask;", "Lorg/gradle/api/DefaultTask;", "()V", "Companion", "integration-server-gradle-plugin"})
public class WorkerOverlaysTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "workerOverlays";
    @NotNull
    public static final String PREFIX = "worker";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public WorkerOverlaysTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (WorkerUtil.Companion.hasSlimWorkers(project)) {
            this.dependsOn(new Object[]{"downloadAndExtractWorkerServer"});
            this.dependsOn(new Object[]{"syncServerPluginsWithWorker"});
            this.dependsOn(new Object[]{"setWorkerLogbackLevels"});
            this.mustRunAfter(new Object[]{"downloadAndExtractWorkerServer"});
            this.mustRunAfter(new Object[]{"syncServerPluginsWithWorker"});
            this.mustRunAfter(new Object[]{"setWorkerLogbackLevels"});
        }
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        if (WorkerUtil.Companion.hasNonSlimWorkers(project2)) {
            this.dependsOn(new Object[]{"copyIntegrationServer"});
            this.dependsOn(new Object[]{"setWorkerLogbackLevels"});
            this.mustRunAfter(new Object[]{"copyIntegrationServer"});
            this.mustRunAfter(new Object[]{"setWorkerLogbackLevels"});
        }
        this.setGroup("Integration Server");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
        final WorkerOverlaysTask currentTask = this;
        this.getProject().afterEvaluate((Action)new Action<Project>(){

            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkParameterIsNotNull((Object)$this$afterEvaluate, (String)"$receiver");
                Project project = $this$afterEvaluate.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                Iterable $this$forEach$iv = WorkerUtil.Companion.getWorkers(project);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Worker worker = (Worker)element$iv;
                    boolean bl = false;
                    if (worker.getSlimDistribution()) {
                        Project project2 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                        OverlaysUtil.Companion.addDatabaseDependency(project2, worker);
                        Project project3 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                        OverlaysUtil.Companion.addMqDependency(project3, worker);
                        Project project4 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
                        if (CacheUtil.Companion.isCacheEnabled(project4)) {
                            Project project5 = $this$afterEvaluate.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
                            OverlaysUtil.Companion.addCacheDependency(project5, worker);
                        }
                    }
                    Map<String, List<Object>> map2 = worker.getOverlays();
                    boolean bl2 = false;
                    if (!map2.isEmpty()) {
                        Project project6 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
                        if (!WorkerUtil.Companion.isExternalRuntimeWorker(project6, worker)) {
                            $this$afterEvaluate.getLogger().warn("Overlays on the worker " + worker.getName() + " are ignored because worker's runtime directory is same to the master.");
                            continue;
                        }
                    }
                    Map<String, List<Object>> $this$forEach$iv2 = worker.getOverlays();
                    boolean $i$f$forEach2 = false;
                    Map<String, List<Object>> map3 = $this$forEach$iv2;
                    boolean bl3 = false;
                    Iterator<Map.Entry<String, List<Object>>> iterator = map3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, List<Object>> element$iv2;
                        Map.Entry<String, List<Object>> overlay = element$iv2 = iterator.next();
                        boolean bl4 = false;
                        Project project7 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
                        Task task2 = (Task)currentTask;
                        Project project8 = $this$afterEvaluate.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
                        OverlaysUtil.Companion.defineOverlay$default(OverlaysUtil.Companion, project7, task2, WorkerUtil.Companion.getWorkerWorkingDir(project8, worker), WorkerOverlaysTask.PREFIX, overlay, CollectionsKt.arrayListOf((Object[])new String[]{"downloadAndExtractWorkerServer" + worker.getName(), "syncServerPluginsWithWorker", "setWorkerLogbackLevels"}), null, 64, null);
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/WorkerOverlaysTask$Companion;", "", "()V", "NAME", "", "PREFIX", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

