/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tls;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.tls.KeytoolTask;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001e\u0010\u000f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\b\u00a8\u0006\u0017"}, d2={"Lai/digital/integration/server/common/tls/KeytoolGenKeyTask;", "Lai/digital/integration/server/common/tls/KeytoolTask;", "()V", "dns", "", "getDns", "()Ljava/lang/String;", "setDns", "(Ljava/lang/String;)V", "ip", "getIp", "setIp", "keySize", "getKeySize", "setKeySize", "validity", "getValidity", "setValidity", "getOutputFile", "Ljava/io/File;", "skipIfOutputFileExists", "", "Companion", "integration-server-gradle-plugin"})
public class KeytoolGenKeyTask
extends KeytoolTask {
    @Input
    @NotNull
    private String ip = "127.0.0.1";
    @Input
    @NotNull
    private String dns;
    @Input
    @NotNull
    private String validity;
    @Input
    @NotNull
    private String keySize;
    @NotNull
    public static final String NAME = "keytoolGenKey";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getIp() {
        return this.ip;
    }

    public final void setIp(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.ip = string;
    }

    @NotNull
    public final String getDns() {
        return this.dns;
    }

    public final void setDns(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.dns = string;
    }

    @NotNull
    public final String getValidity() {
        return this.validity;
    }

    public final void setValidity(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.validity = string;
    }

    @NotNull
    public final String getKeySize() {
        return this.keySize;
    }

    public final void setKeySize(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.keySize = string;
    }

    @Override
    @OutputFile
    @NotNull
    public File getOutputFile() {
        StringBuilder stringBuilder = new StringBuilder();
        File file = this.getWorkDir();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        return new File(stringBuilder.append(file.getAbsolutePath()).append("/").append(this.getKeyname()).append(".").append(this.getTypeExtension()).toString());
    }

    @Override
    public boolean skipIfOutputFileExists() {
        return true;
    }

    public KeytoolGenKeyTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.dns = EntryPointUrlUtil.getHttpHost$default(new EntryPointUrlUtil(project, ProductName.DEPLOY), false, 1, null);
        this.validity = String.valueOf(360);
        this.keySize = String.valueOf(2048);
        this.doFirst((Action)new Action<Task>(){

            public final void execute(@NotNull Task $this$doFirst) {
                Intrinsics.checkParameterIsNotNull((Object)$this$doFirst, (String)"$receiver");
                Object[] objectArray = new String[17];
                objectArray[0] = "-genkey";
                objectArray[1] = "-alias";
                String string = this.getKeyname();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                objectArray[2] = string;
                objectArray[3] = "-ext";
                objectArray[4] = "SAN:c=DNS:" + this.getDns() + ",IP:" + this.getIp();
                objectArray[5] = "-dname";
                objectArray[6] = "CN=localhost,O=digital.ai,OU=Deploy";
                objectArray[7] = "-keyalg";
                objectArray[8] = "RSA";
                objectArray[9] = "-keystore";
                String string2 = this.getOutputFile().getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getOutputFile().absolutePath");
                objectArray[10] = string2;
                objectArray[11] = "-storetype";
                objectArray[12] = this.getType();
                objectArray[13] = "-validity";
                objectArray[14] = this.getValidity();
                objectArray[15] = "-keysize";
                objectArray[16] = this.getKeySize();
                this.setParams(CollectionsKt.listOf((Object[])objectArray));
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/tls/KeytoolGenKeyTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

