/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/SyncServerPluginsWithWorkerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "copyServerDirToWorkerDir", "", "worker", "Lai/digital/integration/server/deploy/domain/Worker;", "copyToWorkers", "Companion", "integration-server-gradle-plugin"})
public class SyncServerPluginsWithWorkerTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "syncServerPluginsWithWorker";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void copyToWorkers() {
        Worker worker;
        Iterable $this$filterTo$iv$iv;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Iterable $this$filter$iv = WorkerUtil.Companion.getWorkers(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            worker = (Worker)element$iv$iv;
            boolean bl = false;
            if (!worker.getSlimDistribution()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            worker = (Worker)element$iv$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            if (!WorkerUtil.Companion.isExternalRuntimeWorker(project2, worker)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Worker worker2 = (Worker)element$iv;
            boolean bl = false;
            this.copyServerDirToWorkerDir(worker2);
        }
    }

    private final void copyServerDirToWorkerDir(Worker worker) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String sourceDir = DeployServerUtil.Companion.getServerWorkingDir(project);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        File destinationDir = Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project2, worker), new String[0]).toFile();
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        ProcessUtil.Companion.chMod(project3, "755", String.valueOf(Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project4, worker), "bin").toAbsolutePath()));
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        project5.getLogger().lifecycle("Copy plugins from directory " + sourceDir + " to Worker " + worker.getName() + " in directory " + destinationDir);
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        FileUtils.deleteDirectory((File)Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project6, worker), "plugins").toFile());
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        String string = DeployServerUtil.Companion.getServerWorkingDir(project7);
        Project project8 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
        FileUtil.Companion.copyDirs(string, WorkerUtil.Companion.getWorkerWorkingDir(project8, worker), CollectionsKt.listOf((Object[])new String[]{"ext", "hotfix", "plugins"}));
        Project project9 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project9, (String)"project");
        String string2 = ((Object)Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project9), "conf").toAbsolutePath()).toString();
        Project project10 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project10, (String)"project");
        FileUtil.Companion.copyFiles(string2, ((Object)Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project10, worker), "conf").toAbsolutePath()).toString(), CollectionsKt.listOf((Object)"deployit-license.lic"));
    }

    public SyncServerPluginsWithWorkerTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{"downloadAndExtractWorkerServer"});
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/SyncServerPluginsWithWorkerTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

