/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server.operator;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/StartDeployServerForOperatorInstanceTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowToWriteMountedHostFolders", "", "launch", "start", "server", "Lai/digital/integration/server/common/domain/Server;", "Companion", "integration-server-gradle-plugin"})
public class StartDeployServerForOperatorInstanceTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "startDeployServerForOperatorInstance";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void start(Server server) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        DeployServerUtil.Companion.runDockerBasedInstance(project, server);
    }

    private final void allowToWriteMountedHostFolders() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        DeployServerUtil.Companion.grantPermissionsToIntegrationServerFolder(project);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Server server = DeployServerUtil.Companion.getServer(project);
        if (!server.getPreviousInstallation()) {
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            project2.getLogger().lifecycle("About to launch Deploy Server " + server.getName() + " on port " + String.valueOf(server.getHttpPort()) + ".");
            this.allowToWriteMountedHostFolders();
            this.start(server);
            Project project3 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            DeployServerUtil.Companion.waitForBoot(project3, null, server, true);
            Project project4 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
            File dockerComposeFile = DeployServerUtil.Companion.getResolvedDockerFile(project4, server).toFile();
            Project project5 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
            File file = dockerComposeFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dockerComposeFile");
            DockerComposeUtil.Companion.allowToCleanMountedFiles(project5, server, file);
        }
    }

    public StartDeployServerForOperatorInstanceTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new String[10];
        objectArray[0] = "applicationConfigurationOverride";
        objectArray[1] = "copyServerFolders";
        objectArray[2] = "copyServerBuildArtifacts";
        objectArray[3] = "serverCopyOverlays";
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        objectArray[4] = DbUtil.Companion.isDerby(project) ? "derbyStart" : "databaseStart";
        objectArray[5] = "operatorCentralConfiguration";
        objectArray[6] = "prepareDatabase";
        objectArray[7] = "prepareOperatorServer";
        objectArray[8] = "setLogbackLevels";
        objectArray[9] = "serverYamlPatch";
        final List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), (Function1)((Function1)new Function1<StartDeployServerForOperatorInstanceTask, Unit>(){

            public final void invoke(@NotNull StartDeployServerForOperatorInstanceTask $this$closureOf) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$closureOf), (String)"$receiver");
                $this$closureOf.dependsOn(new Object[]{dependencies});
            }
        })));
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/StartDeployServerForOperatorInstanceTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

