/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Cluster;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.DockerUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.JavaUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/internals/DeployServerUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DeployServerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\u0004H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u001f\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010 \u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\"2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010%\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010&\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010'\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010(\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010*\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010+\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010,\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0004J\u0016\u0010.\u001a\u00020$2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010/\u001a\u00020$2\u0006\u0010\f\u001a\u00020\r2\u0006\u00100\u001a\u00020\u0004H\u0002J\u000e\u00101\u001a\u0002022\u0006\u0010\f\u001a\u00020\rJ*\u00103\u001a\u00020$2\u0006\u0010\f\u001a\u00020\r2\b\u00104\u001a\u0004\u0018\u0001022\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u00105\u001a\u00020\u0006\u00a8\u00066"}, d2={"Lai/digital/integration/server/deploy/internals/DeployServerUtil$Companion;", "", "()V", "createDebugString", "", "debugSuspend", "", "debugPort", "", "dockerServerRelativePath", "enrichServer", "Lai/digital/integration/server/common/domain/Server;", "project", "Lorg/gradle/api/Project;", "server", "getCluster", "Lai/digital/integration/server/common/domain/Cluster;", "getConfDir", "Ljava/io/File;", "getDebugPort", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/domain/Server;)Ljava/lang/Integer;", "getDockerImageVersion", "getDockerServiceName", "getHttpPort", "getLogDir", "getOldDockerServerPath", "getPreviousInstallationServer", "getResolvedDockerFile", "Ljava/nio/file/Path;", "getServer", "getServerDistFolderPath", "getServerVersion", "getServerWorkingDir", "getServers", "", "grantPermissionsToIntegrationServerFolder", "", "isAkkaSecured", "isClusterEnabled", "isDeployServerDefined", "isDistDownloadRequired", "isDockerBased", "isPreviousInstallationServerDefined", "isTls", "readDeployitConfProperty", "key", "runDockerBasedInstance", "saveServerLogsToFile", "containerName", "startServerFromClasspath", "Ljava/lang/Process;", "waitForBoot", "process", "auxiliaryServer", "integration-server-gradle-plugin"})
    public static final class Companion {
        public final boolean isTls(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return this.getServer(project).getTls();
        }

        public final boolean isAkkaSecured(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return this.getServer(project).getAkkaSecured();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Server getServer(@NotNull Project project) {
            Object t;
            Object element$iv;
            boolean bl;
            void $this$first$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Iterable iterable = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
            Project project2 = project;
            Companion companion = this;
            boolean $i$f$first = false;
            Iterator iterator = $this$first$iv.iterator();
            do {
                if (!iterator.hasNext()) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                element$iv = iterator.next();
                Server server = (Server)element$iv;
                boolean bl2 = false;
                if (!server.getPreviousInstallation()) {
                    String string = server.getDockerImage();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if (StringsKt.endsWith$default((String)string, (String)"xl-deploy", (boolean)false, (int)2, null)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            Object t2 = t = element$iv;
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"DeployExtensionUtil.getE\u2026eploy\")\n                }");
            return companion.enrichServer(project2, (Server)t2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Server> getServers(@NotNull Project project) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Iterable $this$map$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void server;
                Server server2 = (Server)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Server server3 = Companion.enrichServer(project, (Server)server);
                collection.add(server3);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final Server getPreviousInstallationServer(@NotNull Project project) {
            Object element$iv2;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Iterable $this$first$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Server server = (Server)element$iv2;
                    boolean bl = false;
                    if (!server.getPreviousInstallation()) continue;
                    break block1;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"DeployExtensionUtil.getE\u2026er.previousInstallation }");
            return (Server)t;
        }

        public final boolean isPreviousInstallationServerDefined(@NotNull Project project) {
            Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Iterable iterable = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Server server = (Server)t;
                    boolean bl3 = false;
                    if (!server.getPreviousInstallation()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        private final Server enrichServer(Project project, Server server) {
            server.setDebugPort(this.getDebugPort(project, server));
            server.setHttpPort(this.getHttpPort(project, server));
            server.setVersion(this.getServerVersion(project, server));
            if (this.isPreviousInstallationServerDefined(project)) {
                server.setHttpPort(this.getPreviousInstallationServer(project).getHttpPort());
            }
            String string = server.getDockerImage();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                server.setRuntimeDirectory(null);
            }
            if (!StringsKt.startsWith$default((String)server.getContextRoot(), (String)"/", (boolean)false, (int)2, null)) {
                server.setContextRoot("" + '/' + server + ".contextRoot");
            }
            return server;
        }

        @NotNull
        public final String getServerWorkingDir(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return this.getServerWorkingDir(project, this.getServer(project));
        }

        @NotNull
        public final String getServerWorkingDir(@NotNull Project project, @NotNull Server server) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            if (this.isDockerBased(project)) {
                Path workDir = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(project, "deploy-" + server.getVersion());
                string = ((Object)workDir.toAbsolutePath()).toString();
            } else if (server.getRuntimeDirectory() == null) {
                String targetDir = ((Object)this.getServerDistFolderPath(project)).toString();
                string = ((Object)Paths.get(targetDir, "xl-deploy-" + server.getVersion() + "-server").toAbsolutePath()).toString();
            } else {
                String string2 = project.getProjectDir().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.projectDir.toString()");
                String target = string2;
                string = ((Object)Paths.get(target, server.getRuntimeDirectory()).toAbsolutePath()).toString();
            }
            return string;
        }

        @NotNull
        public final Path getServerDistFolderPath(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Path path = Paths.get(IntegrationServerUtil.Companion.getDist(project), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(IntegrationServerUtil.getDist(project))");
            return path;
        }

        public final boolean isDockerBased(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            CharSequence charSequence = this.getServer(project).getDockerImage();
            boolean bl = false;
            boolean bl2 = false;
            return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        }

        @NotNull
        public final Cluster getCluster(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = DeployExtensionUtil.Companion.getExtension(project).getCluster().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"DeployExtensionUtil.getE\u2026on(project).cluster.get()");
            return (Cluster)object;
        }

        public final boolean isClusterEnabled(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return this.getCluster(project).getEnable();
        }

        private final String getServerVersion(Project project, Server server) {
            CharSequence charSequence = server.getVersion();
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return server.getVersion();
            }
            return project.hasProperty("xlDeployVersion") ? String.valueOf(project.property("xlDeployVersion")) : server.getVersion();
        }

        private final int getHttpPort(Project project, Server server) {
            int n;
            if (project.hasProperty("serverHttpPort")) {
                Integer n2 = Integer.valueOf(String.valueOf(project.property("serverHttpPort")));
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"Integer.valueOf(project.\u2026verHttpPort\").toString())");
                n = n2;
            } else {
                n = server.getHttpPort();
            }
            return n;
        }

        private final Integer getDebugPort(Project project, Server server) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "serverDebugPort", server.getDebugPort()) : null;
        }

        @NotNull
        public final String createDebugString(boolean debugSuspend, int debugPort) {
            String suspend = debugSuspend ? "y" : "n";
            return "-Xrunjdwp:transport=dt_socket,server=y,suspend=" + suspend + ",address=" + debugPort;
        }

        public final boolean isDeployServerDefined(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return DeployExtensionUtil.Companion.getExtension(project).getServers().size() > 0;
        }

        public final boolean isDistDownloadRequired(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            return server.getRuntimeDirectory() == null && !this.isDockerBased(project);
        }

        @NotNull
        public final String readDeployitConfProperty(@NotNull Project project, @NotNull String key) {
            File deployitConf;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            File file = deployitConf = Paths.get(this.getServerWorkingDir(project) + "/conf/deployit.conf", new String[0]).toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"deployitConf");
            return PropertiesUtil.Companion.readProperty(file, key);
        }

        @NotNull
        public final File getLogDir(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            File file = Paths.get(this.getServerWorkingDir(project, server), "log").toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Paths.get(getServerWorki\u2026 server), \"log\").toFile()");
            return file;
        }

        @NotNull
        public final File getLogDir(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Server server = this.getServer(project);
            File logDir = Paths.get(this.getServerWorkingDir(project, server), "log").toFile();
            logDir.mkdirs();
            File file = logDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"logDir");
            return file;
        }

        @NotNull
        public final File getConfDir(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Server server = this.getServer(project);
            File file = Paths.get(this.getServerWorkingDir(project, server), "conf").toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Paths.get(getServerWorki\u2026server), \"conf\").toFile()");
            return file;
        }

        public final void grantPermissionsToIntegrationServerFolder(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (this.isDockerBased(project)) {
                String workDir = IntegrationServerUtil.Companion.getDist(project);
                Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)new File(workDir), null, (int)1, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    FileUtil.Companion.grantRWPermissions(it);
                }
            }
        }

        public final void waitForBoot(@NotNull Project project, @Nullable Process process, @NotNull Server server, boolean auxiliaryServer) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Function0<Unit> $fun$saveLogs$1 = new Function0<Unit>(project, server){
                final /* synthetic */ Project $project;
                final /* synthetic */ Server $server;

                public final void invoke() {
                    if (DeployServerUtil.Companion.isDockerBased(this.$project) || DeployServerUtil.Companion.isClusterEnabled(this.$project)) {
                        ai.digital.integration.server.deploy.internals.DeployServerUtil$Companion.access$saveServerLogsToFile(DeployServerUtil.Companion, this.$project, "deploy-" + this.$server.getVersion());
                    }
                }
                {
                    this.$project = project;
                    this.$server = server;
                    super(0);
                }
            };
            String url = new EntryPointUrlUtil(project, ProductName.DEPLOY).composeUrl("/deployit/metadata/type", auxiliaryServer);
            WaitForBootUtil.Companion.byPort(project, "Deploy", url, process, server.getPingRetrySleepTime(), server.getPingTotalTries(), (Function0<Unit>)((Function0)new Function0<Unit>($fun$saveLogs$1){
                final /* synthetic */ waitForBoot.1 $saveLogs$1;

                public final void invoke() {
                    this.$saveLogs$1.invoke();
                }
                {
                    this.$saveLogs$1 = var1_1;
                    super(0);
                }
            }));
            $fun$saveLogs$1.invoke();
        }

        public static /* synthetic */ void waitForBoot$default(Companion companion, Project project, Process process, Server server, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.waitForBoot(project, process, server, bl);
        }

        private final void saveServerLogsToFile(Project project, String containerName) {
            String logContent = DockerUtil.Companion.dockerLogs(project, containerName);
            File logDir = this.getLogDir(project);
            File file = new File(logDir, containerName + ".log");
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            FilesKt.writeText((File)file, (String)logContent, (Charset)charset);
        }

        @NotNull
        public final Process startServerFromClasspath(@NotNull Project project) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            project.getLogger().lifecycle("startServerFromClasspath.");
            Server server = this.getServer(project);
            FileCollection fileCollection = project.getConfigurations().getByName("integrationTestServer").filter((Spec)startServerFromClasspath.classpath.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"project.configurations.g\u2026ndsWith(\"-sources.jar\") }");
            String string = fileCollection.getAsPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.configurations.g\u2026}\n                .asPath");
            String classpath2 = string;
            project.getLogger().lifecycle("Launching Deploy Server from classpath " + classpath2 + '.');
            boolean bl3 = false;
            List jvmArgs = new ArrayList();
            CollectionsKt.addAll((Collection)jvmArgs, (Object[])server.getJvmArgs());
            Integer n = server.getDebugPort();
            if (n != null) {
                Integer n2 = n;
                boolean bl4 = false;
                bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl5 = false;
                jvmArgs.addAll((Collection)JavaUtil.Companion.debugJvmArg(project, it, server.getDebugSuspend()));
            }
            Map config = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"classpath", (Object)classpath2), TuplesKt.to((Object)"discardIO", (Object)(server.getStdoutFileName() == null ? 1 : 0)), TuplesKt.to((Object)"jvmArgs", (Object)jvmArgs), TuplesKt.to((Object)"mainClass", (Object)"com.xebialabs.deployit.DeployitBootstrapper"), TuplesKt.to((Object)"programArgs", (Object)CollectionsKt.listOf((Object)"-force-upgrades")), TuplesKt.to((Object)"workDir", (Object)new File(this.getServerWorkingDir(project)))});
            String string2 = server.getStdoutFileName();
            if (string2 != null) {
                String string3 = string2;
                bl2 = false;
                bl = false;
                String it = string3;
                boolean bl6 = false;
                config.put("redirectTo", new File(Companion.getLogDir(project, server) + '/' + it));
            }
            Object v = project.getProperties().get("integrationServerJVMPath");
            if (v != null) {
                Object v2 = v;
                bl2 = false;
                bl = false;
                Object it = v2;
                boolean bl7 = false;
                Object v3 = it;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                config.putAll(JavaUtil.Companion.jvmPath(project, (String)v3));
            }
            project.getLogger().lifecycle("Starting integration test server on port " + server.getHttpPort() + " from runtime dir " + server.getRuntimeDirectory());
            Process process = JavaUtil.Companion.execJava(config);
            project.getLogger().lifecycle("Launched server on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
            return process;
        }

        @NotNull
        public final String getDockerImageVersion(@NotNull Server server) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            return server.getDockerImage() + ':' + server.getVersion();
        }

        @NotNull
        public final String getDockerServiceName(@NotNull Server server) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            return "deploy-" + server.getVersion();
        }

        private final String getOldDockerServerPath(Project project) {
            if (this.isPreviousInstallationServerDefined(project)) {
                Object element$iv2;
                String rootPath;
                block2: {
                    rootPath = IntegrationServerUtil.Companion.getDist(project);
                    Iterable $this$first$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        Server oldServer = (Server)element$iv2;
                        boolean bl = false;
                        if (!oldServer.getPreviousInstallation()) continue;
                        break block2;
                    }
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Server oldDockerServer = (Server)element$iv2;
                return rootPath + "/deploy-" + oldDockerServer.getVersion();
            }
            return ".";
        }

        @NotNull
        public final Path getResolvedDockerFile(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            InputStream dockerComposeStream2 = ((Object)((Object)getResolvedDockerFile.dockerComposeStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream(this.dockerServerRelativePath());
            String newPath = "deploy-" + server.getVersion() + "/server-docker-compose.yaml";
            Path destinationPath = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(project, newPath);
            InputStream inputStream = dockerComposeStream2;
            if (inputStream != null) {
                InputStream inputStream2 = inputStream;
                boolean bl = false;
                boolean bl2 = false;
                InputStream it = inputStream2;
                boolean bl3 = false;
                FileUtil.Companion.copyFile(it, destinationPath);
            }
            Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(project, newPath);
            File serverTemplate = resultComposeFilePath.toFile();
            boolean forceUpgrade = this.isPreviousInstallationServerDefined(project) && !server.getPreviousInstallation();
            File file = serverTemplate;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"serverTemplate");
            String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)file, (Charset)Charsets.UTF_8), (String)"{{DEPLOY_SERVER_HTTP_PORT}}", (String)String.valueOf(server.getHttpPort()), (boolean)false, (int)4, null), (String)"{{DEPLOY_IMAGE_VERSION}}", (String)this.getDockerImageVersion(server), (boolean)false, (int)4, null), (String)"{{DEPLOY_PLUGINS_TO_EXCLUDE}}", (String)CollectionsKt.joinToString$default((Iterable)server.getDefaultOfficialPluginsToExclude(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), (boolean)false, (int)4, null), (String)"{{DEPLOY_VERSION}}", (String)String.valueOf(server.getVersion()), (boolean)false, (int)4, null), (String)"{{DEPLOY_FORCE_UPGRADE}}", (String)String.valueOf(forceUpgrade), (boolean)false, (int)4, null), (String)"{{INTEGRATION_SERVER_ROOT_VOLUME}}", (String)this.getOldDockerServerPath(project), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)serverTemplate, (String)configuredTemplate, null, (int)2, null);
            return resultComposeFilePath;
        }

        private final String dockerServerRelativePath() {
            return "deploy/server-docker-compose.yaml";
        }

        public final void runDockerBasedInstance(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            project.exec((Action)new Action<ExecSpec>(project, server){
                final /* synthetic */ Project $project;
                final /* synthetic */ Server $server;

                public final void execute(@NotNull ExecSpec $this$exec) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$exec, (String)"$receiver");
                    $this$exec.setExecutable("docker-compose");
                    Object[] objectArray = new String[4];
                    objectArray[0] = "-f";
                    String string = DeployServerUtil.Companion.getResolvedDockerFile(this.$project, this.$server).toFile().toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getResolvedDockerFile(pr\u2026rver).toFile().toString()");
                    objectArray[1] = string;
                    objectArray[2] = "up";
                    objectArray[3] = "-d";
                    $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
                }
                {
                    this.$project = project;
                    this.$server = server;
                }
            });
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$saveServerLogsToFile(Companion $this, Project project, String containerName) {
            $this.saveServerLogsToFile(project, containerName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

