/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.operator.AwsEksProvider;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONTokener;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013H\u0002J\b\u0010!\u001a\u00020\u0013H\u0016J\b\u0010\"\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020\u0013H\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020\bH\u0002J\u0006\u0010&\u001a\u00020\bJ\u0006\u0010'\u001a\u00020\bJ0\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u00020\bH\u0002J\u0010\u00100\u001a\u00020\b2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\bH\u0002J\b\u00104\u001a\u00020\bH\u0002J\b\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u000206H\u0002J\u0018\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J(\u0010;\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0013H\u0002J\u0010\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\u0013H\u0002J4\u0010>\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020\u00132\b\b\u0002\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020,H\u0002\u00a8\u0006A"}, d2={"Lai/digital/integration/server/common/cluster/operator/AwsEksHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "configureAws", "", "awsEksProvider", "Lai/digital/integration/server/common/domain/providers/operator/AwsEksProvider;", "createCluster", "skipExisting", "", "createIAMOidcProvider", "createIAMRoleForCSIDriver", "createSshKey", "createStorageClass", "efsStorageClassName", "", "createStorageClassEFS", "storageClassName", "deleteCluster", "deleteIAMRoleForCSIDriver", "deleteSshKey", "existingSshKeyPair", "existingStack", "getDbStorageClass", "getFileSystemId", "getFqdn", "getHostName", "getHostZoneId", "hostName", "getMqStorageClass", "getProvider", "getProviderHomeDir", "getStorageClass", "installEFSDriver", "launchCluster", "shutdownCluster", "stackStatus", "totalTimeInSec", "", "sleepTime", "", "stackId", "status", "updateCrValues", "updateInfrastructure", "infraInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "updateKubeConfig", "updateRoute53", "updateRoute53Json", "Ljava/io/File;", "updateRoute53RecordSet", "awsRoute53TemplateFile", "updateStorageClass", "fileSystemId", "verifyClusterStatus", "verifyRoute53Status", "route53Change", "wait", "command", "resource", "integration-server-gradle-plugin"})
public class AwsEksHelper
extends OperatorHelper {
    public final void launchCluster() {
        AwsEksProvider awsEksProvider = this.getProvider();
        Object object = awsEksProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"awsEksProvider.skipExisting.get()");
        boolean skipExisting = (Boolean)object;
        this.configureAws(awsEksProvider);
        this.createSshKey(skipExisting);
        this.createCluster(skipExisting);
        this.updateKubeConfig();
        InfrastructureInfo kubeContextInfo = this.getKubectlHelper().getCurrentContextInfo(true);
        this.updateInfrastructure(kubeContextInfo);
        if (Intrinsics.areEqual((Object)this.getStorageClass(), (Object)"aws-efs")) {
            this.createStorageClass(this.getStorageClass());
        }
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorCrValues();
        this.updateCrValues();
        this.applyYamlFiles();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.createClusterMetadata();
        this.updateRoute53();
        this.waitForBoot();
    }

    private final void configureAws(AwsEksProvider awsEksProvider) {
        this.getProject().getLogger().lifecycle("Configure AWS access key and secret key");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws configure set aws_access_key_id " + awsEksProvider.getAwsAccessKey() + " --profile default", null, false, false, 0L, 36, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws configure set aws_secret_access_key " + awsEksProvider.getAwsSecretKey() + " --profile default", null, false, false, 0L, 36, null);
    }

    private final void createSshKey(boolean skipExisting) {
        boolean shouldSkipExisting;
        boolean bl = shouldSkipExisting = skipExisting ? this.existingSshKeyPair() : false;
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing ssh key pair: {}", new Object[]{this.getProvider().getSshKeyName().get()});
        } else {
            this.getProject().getLogger().lifecycle("Create ssh key pair : {}", new Object[]{this.getProvider().getSshKeyName().get()});
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws --region " + (String)this.getProvider().getRegion().get() + ' ' + "ec2 create-key-pair " + "--key-name " + (String)this.getProvider().getSshKeyName().get(), null, true, false, 0L, 36, null);
        }
    }

    private final boolean existingSshKeyPair() {
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws  --region " + (String)this.getProvider().getRegion().get() + ' ' + "ec2 describe-key-pairs " + "--key-names=" + (String)this.getProvider().getSshKeyName().get() + ' ' + "--query 'KeyPairs[0].KeyName' " + "--output text", null, true, false, 0L, 36, null);
        if (StringsKt.contains$default((CharSequence)result, (CharSequence)"does not exist", (boolean)false, (int)2, null)) {
            return false;
        }
        CharSequence charSequence = result;
        Object object = this.getProvider().getSshKeyName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().sshKeyName.get()");
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)((CharSequence)object), (boolean)false, (int)2, null);
    }

    private final void createCluster(boolean skipExisting) {
        boolean shouldSkipExisting;
        boolean bl = shouldSkipExisting = skipExisting ? this.existingStack() : false;
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the stack: {}", new Object[]{this.getProvider().getStack().get()});
        } else {
            this.getProject().getLogger().lifecycle("Create Stack  : {}", new Object[]{this.getProvider().getStack().get()});
            File awsEksClusterTemplateFile = this.getTemplate("operator/aws-eks/aws-eks-cluster.yaml");
            AwsEksProvider awsEksProvider = this.getProvider();
            String stackId = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws --region  " + (String)awsEksProvider.getRegion().get() + ' ' + "cloudformation create-stack " + "--stack-name " + (String)awsEksProvider.getStack().get() + ' ' + "--template-body file://\"" + awsEksClusterTemplateFile + "\" " + "--capabilities CAPABILITY_IAM " + "--parameters " + "ParameterKey=ProjectName,ParameterValue=" + (String)awsEksProvider.getStack().get() + ' ' + "ParameterKey=ClusterName,ParameterValue=" + (String)awsEksProvider.getClusterName().get() + ' ' + "ParameterKey=NodeGroupName,ParameterValue=" + (String)awsEksProvider.getNodeGroupName().get() + ' ' + "ParameterKey=KeyName,ParameterValue=" + (String)awsEksProvider.getSshKeyName().get() + ' ' + "ParameterKey=FileSystemName,ParameterValue=" + (String)awsEksProvider.getFileSystemName().get() + ' ' + "ParameterKey=NodeDesiredSize,ParameterValue=" + (Integer)awsEksProvider.getClusterNodeCount().get() + ' ' + "ParameterKey=KubernetesVersion,ParameterValue=" + (String)awsEksProvider.getKubernetesVersion().get() + ' ' + "--on-failure DELETE " + "--output text", null, true, false, 0L, 52, null);
            Object object = awsEksProvider.getStackTimeoutSeconds().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"awsEksProvider.stackTimeoutSeconds.get()");
            this.verifyClusterStatus(((Number)object).intValue(), ((Number)awsEksProvider.getStackSleepTimeBeforeRetrySeconds().get()).intValue(), stackId, "CREATE_COMPLETE");
        }
    }

    private final boolean existingStack() {
        String stackStatusCmd = "aws --region " + (String)this.getProvider().getRegion().get() + ' ' + "cloudformation  describe-stacks" + " --stack-name " + (String)this.getProvider().getStack().get() + ' ' + "--query 'Stacks[0].StackStatus' " + "--output text";
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), stackStatusCmd, null, true, false, 0L, 36, null);
        if (Intrinsics.areEqual((Object)result, (Object)"CREATE_COMPLETE")) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)result, (CharSequence)"does not exist", (boolean)false, (int)2, null)) {
            return false;
        }
        return false;
    }

    private final void verifyClusterStatus(int totalTimeInSec, long sleepTime, String stackId, String status) {
        AwsEksProvider awsEksProvider = this.getProvider();
        this.stackStatus(awsEksProvider, totalTimeInSec, sleepTime, stackId, status);
    }

    private final void stackStatus(AwsEksProvider awsEksProvider, int totalTimeInSec, long sleepTime, String stackId, String status) {
        String stackStatusCmd = "aws --region " + (String)awsEksProvider.getRegion().get() + ' ' + "cloudformation  list-stacks " + "--query 'StackSummaries[?StackId==`" + stackId + "`].StackStatus' " + "--output text";
        boolean stackStatus = this.wait(status, stackStatusCmd, "Stack", totalTimeInSec, sleepTime);
        if (!stackStatus) {
            throw (Throwable)new RuntimeException("Resource STACK status is not " + status);
        }
    }

    private final boolean wait(String status, String command, String resource, int totalTimeInSec, long sleepTime) {
        long expectedEndTime = System.currentTimeMillis() + (long)totalTimeInSec;
        while (expectedEndTime > System.currentTimeMillis()) {
            String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), command, null, true, false, 0L, 36, null);
            if (StringsKt.contains$default((CharSequence)result, (CharSequence)status, (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.contains$default((CharSequence)result, (CharSequence)"does not exist", (boolean)false, (int)2, null)) {
                return false;
            }
            this.getProject().getLogger().lifecycle(resource + " resource  \"" + status + "\" status not met, retry. ");
            Thread.sleep(sleepTime);
        }
        return false;
    }

    static /* synthetic */ boolean wait$default(AwsEksHelper awsEksHelper, String string, String string2, String string3, int n, long l, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: wait");
        }
        if ((n2 & 8) != 0) {
            n = 3000;
        }
        if ((n2 & 0x10) != 0) {
            l = 1000L;
        }
        return awsEksHelper.wait(string, string2, string3, n, l);
    }

    private final void createStorageClass(String efsStorageClassName) {
        this.createStorageClassEFS(efsStorageClassName);
        this.getKubectlHelper().setDefaultStorageClass(efsStorageClassName);
    }

    private final void createIAMOidcProvider() {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "eksctl utils associate-iam-oidc-provider --cluster " + (String)this.getProvider().getClusterName().get() + " --approve --region " + (String)this.getProvider().getRegion().get(), null, true, false, 0L, 36, null);
    }

    private final void createIAMRoleForCSIDriver() {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "eksctl create iamserviceaccount --name efs-csi-controller-sa --namespace kube-system " + "--cluster " + (String)this.getProvider().getClusterName().get() + ' ' + "--attach-policy-arn arn:aws:iam::932770550094:policy/AmazonEKS_EFS_CSI_Driver_Policy " + "--approve " + "--override-existing-serviceaccounts " + "--region " + (String)this.getProvider().getRegion().get(), null, true, false, 0L, 36, null);
    }

    private final void installEFSDriver() {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "helm repo add aws-efs-csi-driver https://kubernetes-sigs.github.io/aws-efs-csi-driver/", null, true, false, 0L, 36, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "helm repo update", null, true, false, 0L, 36, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "helm upgrade -i aws-efs-csi-driver aws-efs-csi-driver/aws-efs-csi-driver --namespace kube-system --set controller.serviceAccount.create=false --set controller.serviceAccount.name=efs-csi-controller-sa", null, true, false, 0L, 36, null);
    }

    private final void createStorageClassEFS(String storageClassName) {
        if (!this.getKubectlHelper().hasStorageClass(storageClassName)) {
            this.getProject().getLogger().lifecycle("Create OIDC PROVIDER");
            this.createIAMOidcProvider();
            this.getProject().getLogger().lifecycle("Create IAM role for 'CSI DRIVER'");
            this.createIAMRoleForCSIDriver();
            this.getProject().getLogger().lifecycle("Install EFS CSI Driver");
            this.installEFSDriver();
            this.getProject().getLogger().lifecycle("Create storage class: {}", new Object[]{storageClassName});
            this.updateStorageClass(this.getFileSystemId(), storageClassName);
        } else {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing storage class: {}", new Object[]{storageClassName});
        }
    }

    private final void updateStorageClass(String fileSystemId, String storageClassName) {
        this.getProject().getLogger().lifecycle("Create storage class: {}", new Object[]{storageClassName});
        File awsEfsScTemplateFile = this.getTemplate("operator/aws-eks/aws-efs-storage.yaml");
        String awsEFSTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)awsEfsScTemplateFile, (Charset)Charsets.UTF_8), (String)"{{NAME}}", (String)storageClassName, (boolean)false, (int)4, null), (String)"{{FILESYSTEMID}}", (String)fileSystemId, (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)awsEfsScTemplateFile, (String)awsEFSTemplate, null, (int)2, null);
        this.getKubectlHelper().applyFile(awsEfsScTemplateFile);
    }

    private final String getFileSystemId() {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws --region " + (String)this.getProvider().getRegion().get() + ' ' + "cloudformation describe-stacks " + "--stack-name " + (String)this.getProvider().getStack().get() + ' ' + "--query 'Stacks[0].Outputs[?OutputKey==`Filesystem`].OutputValue' " + "--output text", null, false, false, 0L, 36, null);
    }

    private final void updateKubeConfig() {
        AwsEksProvider awsEksProvider = this.getProvider();
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws eks --region " + (String)awsEksProvider.getRegion().get() + ' ' + "update-kubeconfig " + "--name " + (String)awsEksProvider.getClusterName().get(), null, false, false, 0L, 44, null);
    }

    private final void updateCrValues() {
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_CR_VALUES_REL_PATH());
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.ingress.hosts", (Object)new String[]{this.getFqdn()}), TuplesKt.to((Object)"spec.rabbitmq.persistence.storageClass", (Object)"gp2")});
        YamlFileUtil.Companion.overlayFile(file, pairs, false);
    }

    private final void updateRoute53() {
        File templateFile = this.updateRoute53Json();
        String changeInfo = this.updateRoute53RecordSet(templateFile);
        this.verifyRoute53Status(changeInfo);
    }

    private final File updateRoute53Json() {
        File awsRoute53TemplateFile = this.getTemplate("operator/aws-eks/aws-route53-record-update.json");
        String hostName = this.getHostName();
        String hostZoneId = this.getHostZoneId(hostName);
        String awsRoute53Template = StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)awsRoute53TemplateFile, (Charset)Charsets.UTF_8), (String)"{{HOSTNAME}}", (String)("dualstack." + hostName), (boolean)false, (int)4, null), (String)"{{HOSTZONEID}}", (String)hostZoneId, (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)awsRoute53TemplateFile, (String)awsRoute53Template, null, (int)2, null);
        return awsRoute53TemplateFile;
    }

    private final String getHostZoneId(String hostName) {
        Project project = this.getProject();
        StringBuilder stringBuilder = new StringBuilder().append("aws --region ").append((String)this.getProvider().getRegion().get()).append(' ').append("elb describe-load-balancers").append(" --load-balancer-name ");
        String string = hostName;
        int n = 0;
        int n2 = 32;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, stringBuilder.append(string3).append(' ').append("--query LoadBalancerDescriptions[*].CanonicalHostedZoneNameID --output text").toString(), null, false, false, 0L, 36, null);
    }

    private final String getHostName() {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "kubectl get service" + " dai-" + this.getPrefixName() + "-nginx-ingress-controller " + "-o=jsonpath=\"{.status.loadBalancer.ingress[*].hostname}\"", null, false, false, 0L, 36, null);
    }

    private final String updateRoute53RecordSet(File awsRoute53TemplateFile) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws route53 change-resource-record-sets --hosted-zone-id Z0621108QZWN6SHNIF6I " + "--change-batch file://\"" + awsRoute53TemplateFile + '\"', null, false, false, 0L, 36, null);
    }

    private final void verifyRoute53Status(String route53Change) {
        Object object = new JSONTokener(route53Change).nextValue();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.sf.json.JSONObject");
        }
        JSONObject route53ChangeId = (JSONObject)object;
        Object object2 = route53ChangeId.get("ChangeInfo");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.sf.json.JSONObject");
        }
        JSONObject changeInfo = (JSONObject)object2;
        String route53GetChange = "aws route53 get-change " + "--id=" + changeInfo.get("Id") + ' ' + "--query=ChangeInfo.Status " + "--output text";
        Object object3 = this.getProvider().getRoute53InsycAwaitTimeoutSeconds().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"getProvider().route53Ins\u2026AwaitTimeoutSeconds.get()");
        boolean changeStatus = this.wait("INSYNC", route53GetChange, "Route 53 change record set", ((Number)object3).intValue(), 1000L);
        this.getProject().getLogger().lifecycle("Route 53 Status " + changeStatus);
    }

    public final void shutdownCluster() {
        AwsEksProvider awsEksProvider = this.getProvider();
        this.undeployCluster();
        this.getProject().getLogger().lifecycle("Delete iamserviceaccount for CSI driver.");
        this.deleteIAMRoleForCSIDriver(this.getProvider());
        this.getProject().getLogger().lifecycle("Delete cluster and ssh key");
        this.deleteSshKey(awsEksProvider);
        this.deleteCluster(awsEksProvider);
        this.getProject().getLogger().lifecycle("Delete current context");
        this.getKubectlHelper().deleteCurrentContext();
    }

    private final void deleteIAMRoleForCSIDriver(AwsEksProvider awsEksProvider) {
        Object object = awsEksProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"awsEksProvider.skipExisting.get()");
        if (((Boolean)object).booleanValue()) {
            this.getProject().getLogger().lifecycle("Skipping deletion of the storageClass and iamserviceaccount: {}", new Object[]{awsEksProvider.getSshKeyName().get()});
        } else {
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "eksctl delete iamserviceaccount --name efs-csi-controller-sa --namespace kube-system " + "--cluster " + (String)this.getProvider().getClusterName().get() + ' ' + "--region " + (String)this.getProvider().getRegion().get(), null, true, false, 0L, 36, null);
        }
    }

    private final void deleteSshKey(AwsEksProvider awsEksProvider) {
        Object object = awsEksProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"awsEksProvider.skipExisting.get()");
        if (((Boolean)object).booleanValue()) {
            this.getProject().getLogger().lifecycle("Skipping deletion of the ssh key: {}", new Object[]{awsEksProvider.getSshKeyName().get()});
        } else {
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws --region " + (String)awsEksProvider.getRegion().get() + ' ' + "ec2 delete-key-pair " + "--key-name " + (String)awsEksProvider.getSshKeyName().get(), null, false, false, 0L, 36, null);
        }
    }

    private final void deleteCluster(AwsEksProvider awsEksProvider) {
        Object object = awsEksProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"awsEksProvider.skipExisting.get()");
        if (((Boolean)object).booleanValue()) {
            this.getProject().getLogger().lifecycle("Skipping deletion of the stack: {}", new Object[]{awsEksProvider.getStack().get()});
        } else {
            String stackId = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws --region " + (String)awsEksProvider.getRegion().get() + ' ' + "cloudformation describe-stacks " + "--stack-name " + (String)awsEksProvider.getStack().get() + ' ' + "--query='Stacks[0].StackId' " + "--output text", null, false, false, 0L, 36, null);
            if (!StringsKt.contains$default((CharSequence)stackId, (CharSequence)"does not exist", (boolean)false, (int)2, null)) {
                ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "aws --region " + (String)awsEksProvider.getRegion().get() + " cloudformation delete-stack " + "--stack-name " + (String)awsEksProvider.getStack().get() + ' ' + "--output text", null, false, false, 0L, 36, null);
                Object object2 = awsEksProvider.getStackTimeoutSeconds().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"awsEksProvider.stackTimeoutSeconds.get()");
                this.verifyClusterStatus(((Number)object2).intValue(), ((Number)awsEksProvider.getStackSleepTimeBeforeRetrySeconds().get()).intValue(), stackId, "DELETE_COMPLETE");
            }
        }
    }

    @Override
    @NotNull
    public String getProviderHomeDir() {
        return this.getOperatorHomeDir() + '/' + this.getName() + "-operator-aws-eks";
    }

    @Override
    @NotNull
    public AwsEksProvider getProvider() {
        return this.getProfile().getAwsEks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse((Object)"aws-efs");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageClass.getOrElse(\"aws-efs\")");
        return (String)object;
    }

    private final void updateInfrastructure(InfrastructureInfo infraInfo) {
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        AwsEksProvider awsEksProvider = this.getProvider();
        Pair[] pairArray = new Pair[6];
        String string = infraInfo.getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].accessKey", (Object)awsEksProvider.getAwsAccessKey());
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].accessSecret", (Object)awsEksProvider.getAwsSecretKey());
        pairArray[4] = TuplesKt.to((Object)"spec[0].children[0].regionName", (Object)awsEksProvider.getRegion().get());
        pairArray[5] = TuplesKt.to((Object)"spec[0].children[0].clusterName", (Object)awsEksProvider.getClusterName().get());
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getName() + ".digitalai-testing.com";
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        return "gp2";
    }

    @Override
    @NotNull
    public String getMqStorageClass() {
        return "gp2";
    }

    public AwsEksHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
    }
}

