/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.constant.OperatorProviderName;
import ai.digital.integration.server.common.util.DockerUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/XlCliUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class XlCliUtil {
    @NotNull
    private static final Map<OperatorProviderName, String> XL_OP_MAPPING;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        XL_OP_MAPPING = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)OperatorProviderName.AWS_EKS, (Object)"AwsEKS"), new Pair((Object)OperatorProviderName.AZURE_AKS, (Object)"AzureAKS"), new Pair((Object)OperatorProviderName.GCP_GKE, (Object)"GoogleGKE"), new Pair((Object)OperatorProviderName.AWS_OPENSHIFT, (Object)"Openshift"), new Pair((Object)OperatorProviderName.ON_PREMISE, (Object)"PlainK8SCluster")});
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006J.\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lai/digital/integration/server/common/util/XlCliUtil$Companion;", "", "()V", "XL_OP_MAPPING", "", "Lai/digital/integration/server/common/constant/OperatorProviderName;", "", "getXL_OP_MAPPING", "()Ljava/util/Map;", "checkAndDownload", "", "project", "Lorg/gradle/api/Project;", "cliPath", "workDir", "Ljava/io/File;", "checkIfXlDownloaded", "", "location", "copyFromLocal", "download", "cliUrl", "getCliUrl", "cliVersion", "xlApply", "file", "deployServerForOperatorPort", "", "xlOp", "answersFile", "blueprintPath", "integration-server-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final Map<OperatorProviderName, String> getXL_OP_MAPPING() {
            return XL_OP_MAPPING;
        }

        private final void download(String cliUrl, File location) {
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "wget " + cliUrl, location, false, false, 0L, 24, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "chmod +x xl", location, false, false, 0L, 24, null);
        }

        private final void copyFromLocal(String cliPath, File location) {
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "cp " + cliPath + ' ' + location, null, false, false, 0L, 26, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "chmod +x xl", location, false, false, 0L, 24, null);
        }

        private final boolean checkIfXlDownloaded(File location) {
            return new File(location.getAbsolutePath(), "xl").isFile();
        }

        private final void checkAndDownload(Project project, String cliPath, File workDir) {
            if (StringsKt.startsWith$default((String)cliPath, (String)"http", (boolean)false, (int)2, null)) {
                if (!this.checkIfXlDownloaded(workDir)) {
                    this.download(cliPath, workDir);
                }
            } else {
                this.copyFromLocal(cliPath, workDir);
            }
        }

        @NotNull
        public final String getCliUrl(@NotNull String cliVersion) {
            Intrinsics.checkParameterIsNotNull((Object)cliVersion, (String)"cliVersion");
            String osFolder = Os.isFamily((String)"windows") ? "windows-amd64" : (Os.isFamily((String)"mac") ? "darwin-amd64" : "linux-amd64");
            return "https://dist.xebialabs.com/public/xl-cli/" + cliVersion + '/' + osFolder + "/xl";
        }

        public final void xlApply(@NotNull Project project, @NotNull String cliPath, @NotNull File file, @NotNull File workDir, int deployServerForOperatorPort) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)cliPath, (String)"cliPath");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)workDir, (String)"workDir");
            this.checkAndDownload(project, cliPath, workDir);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "./xl apply --verbose -f \"" + file.getName() + "\" --xl-deploy-url http://localhost:" + deployServerForOperatorPort + "/ --xl-deploy-username admin --xl-deploy-password admin", workDir, false, false, 0L, 56, null);
        }

        public final void xlOp(@NotNull Project project, @NotNull String cliPath, @NotNull File answersFile, @NotNull File workDir, @Nullable File blueprintPath) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)cliPath, (String)"cliPath");
            Intrinsics.checkParameterIsNotNull((Object)answersFile, (String)"answersFile");
            Intrinsics.checkParameterIsNotNull((Object)workDir, (String)"workDir");
            this.checkAndDownload(project, cliPath, workDir);
            DockerUtil.Companion.execute(project, CollectionsKt.arrayListOf((Object[])new String[]{"stop", "dai-deploy"}), false, false);
            DockerUtil.Companion.execute(project, CollectionsKt.arrayListOf((Object[])new String[]{"rm", "dai-deploy"}), false, false);
            String blueprintPathOption = blueprintPath != null ? "--local-repo \"" + blueprintPath.getAbsolutePath() + "\" " : "";
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "./xl op --verbose --skip-prompts --no-cleanup --upgrade --advanced-setup " + "--answers \"" + answersFile.getAbsolutePath() + "\" " + "--xl-deploy-url http://localhost:4516/ --xl-deploy-username admin --xl-deploy-password admin " + blueprintPathOption, workDir, false, false, 0L, 56, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

