/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.providers.operator.AwsOpenshiftProvider;
import ai.digital.integration.server.common.util.HtmlUtil;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\nJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\bJ\b\u0010!\u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020\bH\u0002J\u0006\u0010#\u001a\u00020\bJ\b\u0010$\u001a\u00020\bH\u0002J\u0018\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0002\u00a8\u0006("}, d2={"Lai/digital/integration/server/common/cluster/operator/AwsOpenshiftHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "createOcContext", "", "exec", "", "command", "getApiServerUrl", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "getMasterPodName", "position", "", "getOcApiServerToken", "getOcLogin", "", "getOcPassword", "getOperatorImage", "getPostgresPodName", "getProvider", "Lai/digital/integration/server/common/domain/providers/operator/AwsOpenshiftProvider;", "getProviderHomePath", "getRabbitMqPodName", "getStorageClass", "getWorkerPodName", "hasIngress", "", "launchCluster", "ocLogin", "ocLogout", "shutdownCluster", "updateCrValues", "updateInfrastructure", "apiServerURL", "token", "integration-server-gradle-plugin"})
public class AwsOpenshiftHelper
extends OperatorHelper {
    public final void launchCluster() {
        this.createOcContext();
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
        this.updateCrValues();
        this.updateInfrastructure(this.getApiServerUrl(), this.getOcApiServerToken());
        this.applyYamlFiles();
        this.ocLogin();
        this.turnOnLogging();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.createClusterMetadata();
        this.waitForBoot();
        this.turnOffLogging();
    }

    private final String exec(String command) {
        File workDir = new File(this.getProviderHomeDir());
        if (!workDir.exists()) {
            workDir.mkdirs();
        }
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, command, workDir, false, false, 0L, 28, null);
    }

    private final void ocLogin() {
        this.exec("oc login " + this.getApiServerUrl() + " --username " + this.getOcLogin() + " --password \"" + this.getOcPassword() + '\"');
    }

    private final void ocLogout() {
        try {
            this.exec("oc logout");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public final String getOcApiServerToken() {
        Base64.Encoder encoder = Base64.getEncoder();
        String string = "" + this.getOcLogin() + ':' + this.getOcPassword();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String basicAuthToken = encoder.encodeToString(byArray);
        Object object = this.getProvider().getOauthHostName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().oauthHostName.get()");
        String oauthHostName = (String)object;
        this.ocLogout();
        String command1Output = this.exec("curl -vvv -L -k -c cookie -b cookie  -H \"Authorization: Basic " + basicAuthToken + "\" https://" + oauthHostName + "/oauth/token/request");
        Document doc1 = HtmlUtil.Companion.htmlToDocument(command1Output);
        String string3 = doc1.select("form input[name=\"code\"]").val();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"doc1.select(\"form input[name=\\\"code\\\"]\").`val`()");
        String code = string3;
        String string4 = doc1.select("form input[name=\"csrf\"]").val();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"doc1.select(\"form input[name=\\\"csrf\\\"]\").`val`()");
        String csrf = string4;
        String command2Output = this.exec("curl -vvv -L -k -c cookie -b cookie -d 'code=" + code + "&csrf=" + csrf + "' -H \"Authorization: Basic " + basicAuthToken + "\" https://" + oauthHostName + "/oauth/token/display");
        Document doc2 = HtmlUtil.Companion.htmlToDocument(command2Output);
        String string5 = doc2.select("code").text();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"doc2.select(\"code\").text()");
        return string5;
    }

    public final void shutdownCluster() {
        this.ocLogin();
        this.undeployCluster();
        this.ocLogout();
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-openshift";
    }

    @Override
    @NotNull
    public AwsOpenshiftProvider getProvider() {
        return this.getProfile().getAwsOpenshift();
    }

    @Override
    @NotNull
    public String getOperatorImage() {
        Object object = this.getProvider().getOperatorImage().getOrElse((Object)("xldevdocker/" + this.getName() + "-operator:1.3.0-openshift"));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().operatorIm\u2026perator:1.3.0-openshift\")");
        return (String)object;
    }

    @Override
    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse((Object)"aws-efs");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageClass.getOrElse(\"aws-efs\")");
        return (String)object;
    }

    private final void updateInfrastructure(String apiServerURL, String token) {
        this.getProject().getLogger().lifecycle("Updating operator's infrastructure");
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec[0].children[0].serverUrl", (Object)apiServerURL), TuplesKt.to((Object)"spec[0].children[0].openshiftToken", (Object)token)});
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    private final void updateCrValues() {
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_CR_VALUES_REL_PATH());
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.postgresql.postgresqlExtendedConf.listenAddresses", (Object)"*")});
        YamlFileUtil.Companion.overlayFile(file, pairs, false);
    }

    @Override
    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.getProject(), true);
    }

    @Override
    public boolean hasIngress() {
        return false;
    }

    @Override
    @NotNull
    public String getWorkerPodName(int position) {
        return "pod/dai-ocp-" + this.getPrefixName() + "-digitalai-" + this.getName() + "-ocp-worker-" + position;
    }

    @Override
    @NotNull
    public String getMasterPodName(int position) {
        return "pod/dai-ocp-" + this.getPrefixName() + "-digitalai-" + this.getName() + "-ocp-" + this.getMasterPodNameSuffix(position);
    }

    @Override
    @NotNull
    public String getPostgresPodName(int position) {
        return "pod/dai-ocp-" + this.getPrefixName() + "-postgresql-" + position;
    }

    @Override
    @NotNull
    public String getRabbitMqPodName(int position) {
        return "pod/dai-ocp-" + this.getPrefixName() + "-rabbitmq-" + position;
    }

    private final String getApiServerUrl() {
        Object object = this.getProvider().getApiServerURL().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().apiServerURL.get()");
        return (String)object;
    }

    private final Object getOcLogin() {
        return this.getProject().property("ocLogin");
    }

    private final Object getOcPassword() {
        return this.getProject().property("ocPassword");
    }

    private final void createOcContext() {
        this.getProject().getLogger().lifecycle("Updating kube config for Open Shift");
        this.exec("export KUBECONFIG=~/.kube/config");
        this.ocLogin();
    }

    public AwsOpenshiftHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)productName), (String)"productName");
        super(project, productName);
    }
}

