/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.AwsEksHelper;
import ai.digital.integration.server.common.cluster.operator.AwsOpenshiftHelper;
import ai.digital.integration.server.common.cluster.operator.GcpGkeHelper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.K8sSetup;
import ai.digital.integration.server.common.constant.OperatorProviderName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.util.GitUtil;
import ai.digital.integration.server.common.util.XlCliUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.AntBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyBuilderScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0016H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/operator/OperatorBasedUpgradeDeployClusterTask;", "Lorg/gradle/api/DefaultTask;", "()V", "imageRepositoryName", "Lorg/gradle/api/provider/Property;", "", "getImageRepositoryName", "()Lorg/gradle/api/provider/Property;", "imageTargetVersion", "getImageTargetVersion", "opBlueprintBranch", "getOpBlueprintBranch", "operatorBranch", "getOperatorBranch", "launch", "", "opUsingAnswersFile", "operatorHelper", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "answersFile", "Ljava/io/File;", "operatorBranchToOperatorZip", "Ljava/nio/file/Path;", "prepareAnswersFile", "operatorZip", "Companion", "integration-server-gradle-plugin"})
public class OperatorBasedUpgradeDeployClusterTask
extends DefaultTask {
    @Input
    @NotNull
    private final Property<String> imageRepositoryName;
    @Input
    @NotNull
    private final Property<String> imageTargetVersion;
    @Input
    @NotNull
    private final Property<String> operatorBranch;
    @Input
    @NotNull
    private final Property<String> opBlueprintBranch;
    @NotNull
    public static final String NAME = "operatorBasedUpgradeDeployCluster";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Property<String> getImageRepositoryName() {
        return this.imageRepositoryName;
    }

    @NotNull
    public final Property<String> getImageTargetVersion() {
        return this.imageTargetVersion;
    }

    @NotNull
    public final Property<String> getOperatorBranch() {
        return this.operatorBranch;
    }

    @NotNull
    public final Property<String> getOpBlueprintBranch() {
        return this.opBlueprintBranch;
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project, ProductName.DEPLOY);
        Path operatorZip = this.operatorBranchToOperatorZip(operatorHelper);
        File answersFile = this.prepareAnswersFile(operatorHelper, operatorZip);
        this.opUsingAnswersFile(operatorHelper, answersFile);
        operatorHelper.waitForDeployment();
        operatorHelper.waitForMasterPods();
        operatorHelper.waitForWorkerPods();
        operatorHelper.waitForBoot();
    }

    private final File prepareAnswersFile(OperatorHelper operatorHelper, Path operatorZip) {
        String string;
        String k8sSetup;
        String string2;
        String operatorImage = operatorHelper.getOperatorImage();
        String crdName = operatorHelper.getKubectlHelper().getCrd();
        String crName = operatorHelper.getKubectlHelper().getCr(crdName);
        Map<OperatorProviderName, String> map2 = XlCliUtil.Companion.getXL_OP_MAPPING();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string3 = map2.get((Object)DeployClusterUtil.Companion.getOperatorProviderName(project));
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        File answersFile = Intrinsics.areEqual((Object)(string2 = (k8sSetup = string3)), (Object)K8sSetup.GoogleGKE.toString()) ? operatorHelper.getTemplate("operator/xl-upgrade/answers_gke.yaml", "answers.yaml") : (Intrinsics.areEqual((Object)string2, (Object)K8sSetup.Openshift.toString()) ? operatorHelper.getTemplate("operator/xl-upgrade/answers_aws_openshift.yaml", "answers.yaml") : (Intrinsics.areEqual((Object)string2, (Object)K8sSetup.AwsEKS.toString()) ? operatorHelper.getTemplate("operator/xl-upgrade/answers_eks.yaml", "answers.yaml") : OperatorHelper.getTemplate$default(operatorHelper, "operator/xl-upgrade/answers.yaml", null, 2, null)));
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        project2.getLogger().lifecycle("Preparing answers file " + answersFile.getAbsolutePath());
        InfrastructureInfo kubeContextInfo = operatorHelper.getCurrentContextInfo();
        String string4 = StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)answersFile, (Charset)Charsets.UTF_8), (String)"{{CRD_NAME}}", (String)crdName, (boolean)false, (int)4, null), (String)"{{CR_NAME}}", (String)crName, (boolean)false, (int)4, null);
        String string5 = kubeContextInfo.getApiServerURL();
        if (string5 == null) {
            Intrinsics.throwNpe();
        }
        String string6 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string4, (String)"{{K8S_API_SERVER_URL}}", (String)string5, (boolean)false, (int)4, null), (String)"{{K8S_SETUP}}", (String)k8sSetup, (boolean)false, (int)4, null), (String)"{{OPERATOR_IMAGE}}", (String)operatorImage, (boolean)false, (int)4, null);
        Object object = this.imageRepositoryName.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"imageRepositoryName.get()");
        String string7 = StringsKt.replace$default((String)string6, (String)"{{REPOSITORY_NAME}}", (String)((String)object), (boolean)false, (int)4, null);
        Object object2 = this.imageTargetVersion.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"imageTargetVersion.get()");
        Path path = operatorZip;
        String answersFileTemplateTmp = StringsKt.replace$default((String)StringsKt.replace$default((String)string7, (String)"{{IMAGE_TAG}}", (String)((String)object2), (boolean)false, (int)4, null), (String)"{{OPERATOR_ZIP_DEPLOY}}", (String)String.valueOf(path != null ? path.toAbsolutePath() : null), (boolean)false, (int)4, null);
        String string8 = k8sSetup;
        if (Intrinsics.areEqual((Object)string8, (Object)K8sSetup.GoogleGKE.toString())) {
            OperatorHelper operatorHelper2 = operatorHelper;
            if (operatorHelper2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.cluster.operator.GcpGkeHelper");
            }
            string = StringsKt.replace$default((String)answersFileTemplateTmp, (String)"{{K8S_TOKEN}}", (String)((GcpGkeHelper)operatorHelper2).getAccessToken(), (boolean)false, (int)4, null);
        } else if (Intrinsics.areEqual((Object)string8, (Object)K8sSetup.Openshift.toString())) {
            OperatorHelper operatorHelper3 = operatorHelper;
            if (operatorHelper3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.cluster.operator.AwsOpenshiftHelper");
            }
            string = StringsKt.replace$default((String)answersFileTemplateTmp, (String)"{{K8S_TOKEN}}", (String)((AwsOpenshiftHelper)operatorHelper3).getOcApiServerToken(), (boolean)false, (int)4, null);
        } else if (Intrinsics.areEqual((Object)string8, (Object)K8sSetup.AwsEKS.toString())) {
            OperatorHelper operatorHelper4 = operatorHelper;
            if (operatorHelper4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ai.digital.integration.server.common.cluster.operator.AwsEksHelper");
            }
            AwsEksHelper awsEksHelper = (AwsEksHelper)operatorHelper4;
            String string9 = kubeContextInfo.getCaCert();
            if (string9 == null) {
                Intrinsics.throwNpe();
            }
            String string10 = StringsKt.replace$default((String)answersFileTemplateTmp, (String)"{{K8S_CLIENT_CERT}}", (String)string9, (boolean)false, (int)4, null);
            Object object3 = awsEksHelper.getProvider().getClusterName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"awsEksHelper.getProvider().clusterName.get()");
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string10, (String)"{{CLUSTER_NAME}}", (String)((String)object3), (boolean)false, (int)4, null), (String)"{{AWS_ACCESS_KEY}}", (String)awsEksHelper.getProvider().getAwsAccessKey(), (boolean)false, (int)4, null), (String)"{{AWS_ACCESS_SECRET}}", (String)awsEksHelper.getProvider().getAwsSecretKey(), (boolean)false, (int)4, null);
        } else {
            String string11 = kubeContextInfo.getCaCert();
            if (string11 == null) {
                Intrinsics.throwNpe();
            }
            String string12 = StringsKt.replace$default((String)answersFileTemplateTmp, (String)"{{K8S_CLIENT_CERT}}", (String)string11, (boolean)false, (int)4, null);
            String string13 = kubeContextInfo.getTlsPrivateKey();
            if (string13 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.replace$default((String)string12, (String)"{{K8S_CLIENT_KEY}}", (String)string13, (boolean)false, (int)4, null);
        }
        String answersFileTemplate = string;
        FilesKt.writeText$default((File)answersFile, (String)answersFileTemplate, null, (int)2, null);
        return answersFile;
    }

    private final void opUsingAnswersFile(OperatorHelper operatorHelper, File answersFile) {
        Provider provider = this.opBlueprintBranch.map((Transformer)new Transformer<File, String>(this, operatorHelper){
            final /* synthetic */ OperatorBasedUpgradeDeployClusterTask this$0;
            final /* synthetic */ OperatorHelper $operatorHelper;

            @NotNull
            public final File transform(@NotNull String branch) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                Project project = this.this$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                project.getLogger().lifecycle("Using xl-op-blueprints from branch " + branch);
                Path path = Paths.get(this.$operatorHelper.getProviderHomeDir(), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(operatorHelper.getProviderHomeDir())");
                return GitUtil.Companion.checkout("xl-op-blueprints", path, branch).toFile();
            }
            {
                this.this$0 = operatorBasedUpgradeDeployClusterTask;
                this.$operatorHelper = operatorHelper;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"opBlueprintBranch.map { \u2026ranch).toFile()\n        }");
        Provider opBlueprintPath2 = provider;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Applying prepared answers file " + answersFile.getAbsolutePath());
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Object object = operatorHelper.getProfile().getXlCliVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"operatorHelper.getProfile().xlCliVersion.get()");
        XlCliUtil.Companion.xlOp(project2, answersFile, (String)object, new File(operatorHelper.getProviderHomeDir()), (File)opBlueprintPath2.getOrNull());
    }

    private final Path operatorBranchToOperatorZip(OperatorHelper operatorHelper) {
        Object object = this.operatorBranch.getOrNull();
        boolean bl = false;
        boolean bl2 = false;
        String branch = (String)object;
        boolean bl3 = false;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Using xl-deploy-kubernetes-operator from branch " + branch);
        Path path = Paths.get(operatorHelper.getProviderHomeDir(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(operatorHelper.getProviderHomeDir())");
        Path operatorPath = GitUtil.Companion.checkout("xl-deploy-kubernetes-operator", path, branch);
        Path src = Paths.get(((Object)operatorPath.toAbsolutePath()).toString(), operatorHelper.getProviderHomePath());
        Path dest = Paths.get(operatorHelper.getProviderHomeDir(), "operator-upgrade.zip");
        AntBuilder antBuilder = this.getAnt();
        Intrinsics.checkExpressionValueIsNotNull((Object)antBuilder, (String)"ant");
        AntBuilder $this$withGroovyBuilder$iv = antBuilder;
        boolean $i$f$withGroovyBuilder = false;
        GroovyBuilderScope $this$withGroovyBuilder = GroovyBuilderScope.Companion.of((Object)$this$withGroovyBuilder$iv);
        boolean bl4 = false;
        $this$withGroovyBuilder.invoke("zip", new Pair[]{TuplesKt.to((Object)"basedir", (Object)((Object)src.toAbsolutePath()).toString()), TuplesKt.to((Object)"destfile", (Object)((Object)dest.toAbsolutePath()).toString())});
        return dest;
    }

    public OperatorBasedUpgradeDeployClusterTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.imageRepositoryName = property;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ObjectFactory objectFactory2 = project2.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory2, (String)"project.objects");
        $this$property$iv = objectFactory2;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.imageTargetVersion = property2;
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        ObjectFactory objectFactory3 = project3.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory3, (String)"project.objects");
        $this$property$iv = objectFactory3;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.operatorBranch = property3;
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        ObjectFactory objectFactory4 = project4.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory4, (String)"project.objects");
        $this$property$iv = objectFactory4;
        $i$f$property = false;
        Property property4 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.java)");
        this.opBlueprintBranch = property4;
        this.setGroup("Integration Server");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/operator/OperatorBasedUpgradeDeployClusterTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

