/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\bJ\u0006\u0010 \u001a\u00020\bJ\u0010\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u0018\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0002J\u000e\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bJ\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bH\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\u0002J\u000e\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\bJ\u000e\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\bJ\u000e\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\bJ\u001e\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020;R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006<"}, d2={"Lai/digital/integration/server/common/util/KubeCtlHelper;", "", "project", "Lorg/gradle/api/Project;", "isOpenShift", "", "(Lorg/gradle/api/Project;Z)V", "command", "", "getCommand", "()Ljava/lang/String;", "getProject", "()Lorg/gradle/api/Project;", "applyFile", "", "file", "Ljava/io/File;", "configView", "jsonPath", "fallbackJsonPath", "deleteAllPVCs", "deleteCurrentContext", "deleteFile", "getClusterCertificateAuthorityData", "clusterName", "getClusterServer", "getContextCluster", "contextName", "getContextUser", "getCr", "crdName", "getCrd", "getCurrentContext", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "skip", "getIngresHost", "ingressName", "getNameAndGrep", "params", "grepFor", "getServiceExternalIp", "serviceName", "getUserClientCertificateData", "userName", "getUserClientKeyData", "getWithPath", "subCommand", "jsonpath", "hasStorageClass", "storageClass", "savePodLogs", "podName", "setDefaultStorageClass", "newDefaultStorageClass", "wait", "resource", "condition", "timeoutSeconds", "", "integration-server-gradle-plugin"})
public class KubeCtlHelper {
    @NotNull
    private final String command;
    @NotNull
    private final Project project;

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    public final void applyFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " apply -f \"" + file.getAbsolutePath() + '\"', null, false, false, 0L, 60, null);
    }

    public final void deleteFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " delete -f \"" + file.getAbsolutePath() + '\"', null, false, false, 0L, 60, null);
    }

    public final boolean wait(@NotNull String resource, @NotNull String condition, int timeoutSeconds) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        Intrinsics.checkParameterIsNotNull((Object)condition, (String)"condition");
        this.project.getLogger().lifecycle("Waiting for resource " + resource + " to be " + condition);
        long expectedEndTime = System.currentTimeMillis() + (long)(timeoutSeconds * 1000);
        while (expectedEndTime > System.currentTimeMillis()) {
            String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " wait --for condition=" + condition + " --timeout=" + timeoutSeconds + "s " + resource, null, false, false, 0L, 44, null);
            if (StringsKt.contains$default((CharSequence)result, (CharSequence)"condition met", (boolean)false, (int)2, null)) {
                return true;
            }
            Thread.sleep(1000L);
        }
        return false;
    }

    public final void savePodLogs(@NotNull String podName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)podName, (String)"podName");
        if (StringsKt.startsWith$default((String)podName, (String)"pod/", (boolean)false, (int)2, null)) {
            String string2 = podName;
            int n = 4;
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = podName;
        }
        String name = string;
        try {
            String logContent = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " logs " + name, null, false, false, 0L, 52, null);
            File logDir = DeployServerUtil.Companion.getLogDir(this.project);
            File file = new File(logDir, name + ".log");
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            FilesKt.writeText((File)file, (String)logContent, (Charset)charset);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setDefaultStorageClass(@NotNull String newDefaultStorageClass) {
        Intrinsics.checkParameterIsNotNull((Object)newDefaultStorageClass, (String)"newDefaultStorageClass");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " get sc -o name" + "|sed -e 's/.*\\///g' " + "|xargs -I {} " + this.command + " patch storageclass {} -p '{\"metadata\": {\"annotations\":{\"storageclass.kubernetes.io/is-default-class\":\"false\"}}}'", null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " patch storageclass " + newDefaultStorageClass + " -p '{\"metadata\": {\"annotations\":{\"storageclass.kubernetes.io/is-default-class\":\"true\"}}}'", null, false, false, 0L, 60, null);
    }

    public final boolean hasStorageClass(@NotNull String storageClass) {
        Intrinsics.checkParameterIsNotNull((Object)storageClass, (String)"storageClass");
        String result = this.getNameAndGrep("storageclass", storageClass);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)storageClass, (boolean)false, (int)2, null);
    }

    @NotNull
    public final InfrastructureInfo getCurrentContextInfo(boolean skip) {
        String context = this.getCurrentContext();
        String cluster = this.getContextCluster(context);
        String user = this.getContextUser(context);
        return new InfrastructureInfo(cluster, user, this.getClusterServer(cluster), this.getClusterCertificateAuthorityData(cluster), !skip ? this.getUserClientCertificateData(user) : null, !skip ? this.getUserClientKeyData(user) : null);
    }

    public static /* synthetic */ InfrastructureInfo getCurrentContextInfo$default(KubeCtlHelper kubeCtlHelper, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCurrentContextInfo");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return kubeCtlHelper.getCurrentContextInfo(bl);
    }

    public final void deleteCurrentContext() {
        try {
            String context = this.getCurrentContext();
            String cluster = this.getContextCluster(context);
            String user = this.getContextUser(context);
            this.project.getLogger().info("Current cluster context is being deleted {} with related cluster {} and user {} information", new Object[]{context, cluster, user});
            Function1<String, Unit> $fun$delete$1 = new Function1<String, Unit>(this){
                final /* synthetic */ KubeCtlHelper this$0;

                public final void invoke(@NotNull String what) {
                    Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
                    ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.this$0.getProject(), this.this$0.getCommand() + " config " + what, null, false, false, 0L, 44, null);
                }
                {
                    this.this$0 = kubeCtlHelper;
                    super(1);
                }
            };
            $fun$delete$1.invoke("delete-context " + context);
            $fun$delete$1.invoke("delete-user " + user);
            $fun$delete$1.invoke("delete-cluster " + cluster);
        }
        catch (RuntimeException e) {
            this.project.getLogger().info("Skipping delete of current context because: {}", (Object)e.getMessage());
        }
    }

    public final void deleteAllPVCs() {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " delete pvc --all --grace-period=1", null, false, false, 0L, 44, null);
    }

    @NotNull
    public final String getIngresHost(@NotNull String ingressName) {
        Intrinsics.checkParameterIsNotNull((Object)ingressName, (String)"ingressName");
        return this.getWithPath("ing " + ingressName, "{.items[*].spec.rules[*].host}");
    }

    @NotNull
    public final String getServiceExternalIp(@NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        return this.getWithPath("get " + serviceName, "{.status.loadBalancer.ingress[*].ip}");
    }

    @NotNull
    public final String getCurrentContext() {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config current-context", null, false, false, 0L, 52, null);
    }

    private final String configView(String jsonPath) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config view -o jsonpath='" + jsonPath + "' --raw", null, false, false, 0L, 52, null);
    }

    @NotNull
    public final String getContextCluster(@NotNull String contextName) {
        Intrinsics.checkParameterIsNotNull((Object)contextName, (String)"contextName");
        return this.configView("{.contexts[?(@.name == \"" + contextName + "\")].context.cluster}");
    }

    @NotNull
    public final String getContextUser(@NotNull String contextName) {
        Intrinsics.checkParameterIsNotNull((Object)contextName, (String)"contextName");
        return this.configView("{.contexts[?(@.name == \"" + contextName + "\")].context.user}");
    }

    @NotNull
    public final String getClusterServer(@NotNull String clusterName) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        return this.configView("{.clusters[?(@.name == \"" + clusterName + "\")].cluster.server}");
    }

    private final String configView(String jsonPath, String fallbackJsonPath) {
        String string;
        String data = this.configView(jsonPath);
        if (Intrinsics.areEqual((Object)data, (Object)"")) {
            String path = this.configView(fallbackJsonPath);
            String string2 = FilesKt.readText$default((File)new File(path), null, (int)1, null);
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            String string4 = Base64.encodeBase64String((byte[])byArray);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Base64.encodeBase64Strin\u2026readText().toByteArray())");
        } else {
            string = data;
        }
        return string;
    }

    @NotNull
    public final String getClusterCertificateAuthorityData(@NotNull String clusterName) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        return this.configView("{.clusters[?(@.name == \"" + clusterName + "\")].cluster.certificate-authority-data}", "{.clusters[?(@.name == \"" + clusterName + "\")].cluster.certificate-authority}");
    }

    private final String getUserClientKeyData(String userName) {
        return this.configView("{.users[?(@.name == \"" + userName + "\")].user.client-key-data}", "{.users[?(@.name == \"" + userName + "\")].user.client-key}");
    }

    private final String getUserClientCertificateData(String userName) {
        return this.configView("{.users[?(@.name == \"" + userName + "\")].user.client-certificate-data}", "{.users[?(@.name == \"" + userName + "\")].user.client-certificate}");
    }

    private final String getNameAndGrep(String params2, String grepFor) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " get " + params2 + " -o name | grep " + grepFor, null, bl, bl2, l, 36, null);
    }

    private final String getWithPath(String subCommand, String jsonpath) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + ' ' + subCommand + " -o 'jsonpath=" + jsonpath + '\'', null, false, false, 0L, 60, null);
    }

    @NotNull
    public final String getCrd() {
        return this.getWithPath("get crd", "{.items[?(@..spec.group == \"xld.digital.ai\")].metadata.name}");
    }

    @NotNull
    public final String getCr(@NotNull String crdName) {
        Intrinsics.checkParameterIsNotNull((Object)crdName, (String)"crdName");
        return this.getWithPath("get " + crdName, "{.items[0].metadata.name}");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KubeCtlHelper(@NotNull Project project, boolean isOpenShift) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.command = isOpenShift ? "oc" : "kubectl";
    }

    public /* synthetic */ KubeCtlHelper(Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(project, bl);
    }
}

