/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals.cluster.operator;

import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.operator.GcpGkeProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.cluster.operator.GcpGkeHelper;
import ai.digital.integration.server.deploy.internals.cluster.operator.OperatorHelper;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002JZ\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\u0006H\u0002J(\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\u0006\u0010#\u001a\u00020\u0006J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0002J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0006\u0010'\u001a\u00020\u0006J\b\u0010(\u001a\u00020\u0006H\u0002J\u001c\u0010)\u001a\u00020\u00062\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\b0\u001dH\u0002J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\bH\u0002J\b\u0010-\u001a\u00020\u0006H\u0002\u00a8\u0006."}, d2={"Lai/digital/integration/server/deploy/internals/cluster/operator/GcpGkeHelper;", "Lai/digital/integration/server/deploy/internals/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "applyDnsOpenApi", "", "ip", "", "changeDefaultProject", "projectName", "changeDefaultRegionZone", "regionZone", "connectToCluster", "accountName", "name", "createCluster", "clusterNodeCount", "Lorg/gradle/api/provider/Property;", "", "clusterNodeVmSize", "kubernetesVersion", "skipExisting", "", "deleteCluster", "deleteDnsOpenApi", "existsCluster", "existsDnsOpenApi", "getCurrentContextInfo", "Lkotlin/Pair;", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "getFqdn", "getProvider", "Lai/digital/integration/server/common/domain/providers/operator/GcpGkeProvider;", "getProviderHomeDir", "launchCluster", "loginGCloudCli", "accountCredFile", "logoutGCloudCli", "shutdownCluster", "updateCrValues", "updateInfrastructure", "kubeContextInfo", "useCustomStorageClass", "storageClassName", "validateGCloudCli", "integration-server-gradle-plugin"})
public class GcpGkeHelper
extends OperatorHelper {
    public final void launchCluster() {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.name.get()");
        String name = (String)object2;
        Object object3 = gcpGkeProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.skipExisting.get()");
        boolean skipExisting = (Boolean)object3;
        Object object4 = gcpGkeProvider.getRegionZone().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"gcpGkeProvider.regionZone.get()");
        String regionZone = (String)object4;
        Object object5 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object5;
        this.validateGCloudCli();
        this.loginGCloudCli(accountName, gcpGkeProvider.getAccountCredFile());
        this.changeDefaultProject(projectName);
        this.changeDefaultRegionZone(regionZone);
        this.createCluster(accountName, projectName, name, regionZone, gcpGkeProvider.getClusterNodeCount(), gcpGkeProvider.getClusterNodeVmSize(), gcpGkeProvider.getKubernetesVersion(), skipExisting);
        this.connectToCluster(accountName, projectName, name, regionZone);
        Pair<InfrastructureInfo, String> kubeContextInfo = this.getCurrentContextInfo(accountName, projectName);
        this.useCustomStorageClass(this.getStorageClass());
        this.updateControllerManager();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateInfrastructure(kubeContextInfo);
        this.updateOperatorCrValues();
        this.updateCrValues();
        this.applyYamlFiles();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        String ip = this.getKubectlHelper().getServiceExternalIp("service/dai-xld-nginx-ingress-controller");
        this.applyDnsOpenApi(ip);
        this.createClusterMetadata();
        this.waitForBoot();
    }

    public final void shutdownCluster() {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.name.get()");
        String name = (String)object2;
        Object object3 = gcpGkeProvider.getRegionZone().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.regionZone.get()");
        String regionZone = (String)object3;
        Object object4 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object4;
        this.undeployCluster();
        this.deleteCluster(accountName, projectName, name, regionZone);
        this.deleteDnsOpenApi();
        this.getKubectlHelper().deleteCurrentContext();
        Object object5 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"gcpGkeProvider.accountName.get()");
        this.logoutGCloudCli((String)object5);
    }

    @Override
    @NotNull
    public String getProviderHomeDir() {
        return this.getOperatorHomeDir() + "/deploy-operator-gcp-gke";
    }

    @Override
    @NotNull
    public GcpGkeProvider getProvider() {
        return this.getProfile().getGcpGke();
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getHost() + ".endpoints." + (String)this.getProvider().getProjectName().get() + ".cloud.goog";
    }

    private final void validateGCloudCli() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud -v", null, bl, bl2, l, 36, null);
        if (!StringsKt.contains$default((CharSequence)result, (CharSequence)"Google Cloud SDK", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("No Google Cloud SDK \"gcloud\" in the path. Please verify your installation");
        }
    }

    private final void loginGCloudCli(String accountName, String accountCredFile) {
        this.getProject().getLogger().lifecycle("Login account " + accountName);
        CharSequence charSequence = accountCredFile;
        boolean bl = false;
        String additions2 = !StringsKt.isBlank((CharSequence)charSequence) ? " --cred-file=\"" + new File(accountCredFile).getAbsolutePath() + '\"' : "";
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud auth login " + accountName + ' ' + additions2 + " --quiet", null, false, false, 0L, 60, null);
    }

    private final void logoutGCloudCli(String accountName) {
        this.getProject().getLogger().lifecycle("Revoke account " + accountName);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud auth revoke " + accountName + " --quiet", null, false, false, 0L, 44, null);
    }

    private final void changeDefaultProject(String projectName) {
        this.getProject().getLogger().lifecycle("Change default project to " + projectName);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud config set project " + projectName, null, false, false, 0L, 60, null);
    }

    private final void changeDefaultRegionZone(String regionZone) {
        this.getProject().getLogger().lifecycle("Change default region to " + regionZone);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud config set compute/zone " + regionZone, null, false, false, 0L, 60, null);
    }

    private final void createCluster(String accountName, String projectName, String name, String regionZone, Property<Integer> clusterNodeCount, Property<String> clusterNodeVmSize, Property<String> kubernetesVersion, boolean skipExisting) {
        boolean shouldSkipExisting;
        boolean bl = shouldSkipExisting = skipExisting ? this.existsCluster(accountName, projectName, name, regionZone) : false;
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing cluster: {}", new Object[]{name});
        } else {
            this.getProject().getLogger().lifecycle("Create cluster: {}", new Object[]{name});
            String additions2 = (String)clusterNodeVmSize.map((Transformer)createCluster.additions.1.INSTANCE).getOrElse((Object)"") + (String)kubernetesVersion.map((Transformer)createCluster.additions.2.INSTANCE).getOrElse((Object)" --cluster-version \"1.20.11-gke.1801\"");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud beta container --account \"" + accountName + "\" --project \"" + projectName + "\" clusters create \"" + name + "\" --zone  \"" + regionZone + "\" " + "--release-channel \"regular\" " + "--num-nodes \"" + (Integer)clusterNodeCount.getOrElse((Object)3) + "\" --image-type \"COS_CONTAINERD\" --metadata disable-legacy-endpoints=true " + "--logging=SYSTEM,WORKLOAD --monitoring=SYSTEM --enable-ip-alias --no-enable-master-authorized-networks " + "--addons HorizontalPodAutoscaling,HttpLoadBalancing,GcePersistentDiskCsiDriver --enable-autoupgrade --enable-autorepair " + "--enable-shielded-nodes " + additions2, null, false, false, 0L, 60, null);
        }
    }

    private final boolean existsCluster(String accountName, String projectName, String name, String regionZone) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud beta container --account \"" + accountName + "\" --project \"" + projectName + "\" clusters list --zone \"" + regionZone + '\"', null, bl, bl2, l, 36, null);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)name, (boolean)false, (int)2, null);
    }

    private final void deleteCluster(String accountName, String projectName, String name, String regionZone) {
        if (this.existsCluster(accountName, projectName, name, regionZone)) {
            this.getProject().getLogger().lifecycle("Delete cluster (async): {}", new Object[]{name});
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud beta container --account \"" + accountName + "\" --project \"" + projectName + "\" clusters delete \"" + name + "\" --zone \"" + regionZone + "\" --quiet", null, false, false, 0L, 60, null);
        } else {
            this.getProject().getLogger().lifecycle("Skipping delete of the cluster: {}", new Object[]{name});
        }
    }

    private final void connectToCluster(String accountName, String projectName, String name, String regionZone) {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud beta container --account \"" + accountName + "\" --project \"" + projectName + "\" clusters get-credentials \"" + name + "\" --zone \"" + regionZone + '\"', null, false, false, 0L, 60, null);
    }

    private final Pair<InfrastructureInfo, String> getCurrentContextInfo(String accountName, String projectName) {
        Map gcloudConfigMap;
        KubeCtlHelper kubectlHelper = this.getKubectlHelper();
        String context = kubectlHelper.getCurrentContext();
        String cluster = kubectlHelper.getContextCluster(context);
        String user = kubectlHelper.getContextUser(context);
        InfrastructureInfo info = new InfrastructureInfo(cluster, user, kubectlHelper.getClusterServer(cluster), kubectlHelper.getClusterCertificateAuthorityData(cluster), null, null);
        String gcloudConfig = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud config --account \"" + accountName + "\" --project \"" + projectName + "\" config-helper --format=yaml", null, false, false, 0L, 60, null);
        Map map2 = gcloudConfigMap = (Map)new ObjectMapper((JsonFactory)YAMLFactory.builder().build()).readValue(gcloudConfig, Map.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"gcloudConfigMap");
        Map map3 = map2;
        String string = "credential";
        boolean bl = false;
        Object v = map3.get(string);
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        }
        map3 = (Map)v;
        string = "access_token";
        bl = false;
        Object v2 = map3.get(string);
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String accessToken = (String)v2;
        return new Pair((Object)info, (Object)accessToken);
    }

    private final void updateInfrastructure(Pair<? extends InfrastructureInfo, String> kubeContextInfo) {
        File file = new File(this.getProviderHomeDir(), "digitalai-deploy/infrastructure.yaml");
        Pair[] pairArray = new Pair[3];
        String string = ((InfrastructureInfo)kubeContextInfo.getFirst()).getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = ((InfrastructureInfo)kubeContextInfo.getFirst()).getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].token", (Object)kubeContextInfo.getSecond());
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    private final void updateCrValues() {
        File file = new File(this.getProviderHomeDir(), "digitalai-deploy/kubernetes/daideploy_cr.yaml");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.ingress.hosts", (Object)CollectionsKt.listOf((Object)this.getFqdn()))});
        YamlFileUtil.Companion.overlayFile(file, pairs, false);
    }

    private final void useCustomStorageClass(String storageClassName) {
        if (!this.getKubectlHelper().hasStorageClass(storageClassName) && Intrinsics.areEqual((Object)"standard", (Object)storageClassName) ^ true) {
            this.getProject().getLogger().lifecycle("Use storage class: {}", new Object[]{storageClassName});
            this.getKubectlHelper().setDefaultStorageClass(storageClassName);
        } else {
            this.getProject().getLogger().lifecycle("Skipping using of storage class: {}", new Object[]{storageClassName});
        }
    }

    private final void applyDnsOpenApi(String ip) {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.name.get()");
        String name = (String)object2;
        Object object3 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object3;
        String serviceName = this.getFqdn();
        File dnsOpenApiTemplateFile = this.getTemplate("operator/gcp-gke/dns-openapi.yaml");
        String dnsOpenApiTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)dnsOpenApiTemplateFile, (Charset)Charsets.UTF_8), (String)"{{NAME}}", (String)name, (boolean)false, (int)4, null), (String)"{{PROJECT_ID}}", (String)projectName, (boolean)false, (int)4, null), (String)"{{IP}}", (String)ip, (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)dnsOpenApiTemplateFile, (String)dnsOpenApiTemplate, null, (int)2, null);
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud endpoints --account \"" + accountName + "\" --project \"" + projectName + "\" services undelete \"" + serviceName + '\"', null, bl, bl2, l, 36, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud endpoints --account \"" + accountName + "\" --project \"" + projectName + "\" services deploy \"" + dnsOpenApiTemplateFile.getAbsolutePath() + "\" --force", null, false, false, 0L, 60, null);
    }

    private final boolean existsDnsOpenApi(String accountName, String projectName) {
        String serviceName = this.getFqdn();
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud endpoints --account \"" + accountName + "\" --project \"" + projectName + "\" services list", null, bl, bl2, l, 36, null);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)serviceName, (boolean)false, (int)2, null);
    }

    private final void deleteDnsOpenApi() {
        GcpGkeProvider gcpGkeProvider = this.getProvider();
        Object object = gcpGkeProvider.getProjectName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gcpGkeProvider.projectName.get()");
        String projectName = (String)object;
        Object object2 = gcpGkeProvider.getAccountName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gcpGkeProvider.accountName.get()");
        String accountName = (String)object2;
        if (this.existsDnsOpenApi(accountName, projectName)) {
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "gcloud endpoints --account \"" + accountName + "\" --project \"" + projectName + "\" services delete \"" + this.getFqdn() + "\" --quiet", null, false, false, 0L, 60, null);
        }
    }

    public GcpGkeHelper(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
    }
}

