/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals.cluster.operator;

import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.operator.AzureAksProvider;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.cluster.operator.AzureAksHelper;
import ai.digital.integration.server.deploy.internals.cluster.operator.OperatorHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002JB\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016J\u0006\u0010#\u001a\u00020\tJ\u001c\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\u00062\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0002J\u001c\u0010'\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\u00062\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0006\u0010)\u001a\u00020\tJ\b\u0010*\u001a\u00020\tH\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\tH\u0002\u00a8\u0006/"}, d2={"Lai/digital/integration/server/deploy/internals/cluster/operator/AzureAksHelper;", "Lai/digital/integration/server/deploy/internals/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "aksClusterName", "", "name", "connectToCluster", "", "createCluster", "clusterNodeCount", "Lorg/gradle/api/provider/Property;", "", "clusterNodeVmSize", "kubernetesVersion", "skipExisting", "", "createResourceGroup", "location", "createStorageClass", "createStorageClassFromFile", "storageClassName", "filePath", "deleteResourceGroup", "groupName", "diskStorageClassName", "existsResourceGroup", "fileStorageClassName", "getDbStorageClass", "getFqdn", "getProvider", "Lai/digital/integration/server/common/domain/providers/operator/AzureAksProvider;", "getProviderHomeDir", "getStorageClass", "launchCluster", "loginAzCli", "username", "password", "logoutAzCli", "resourceGroupName", "shutdownCluster", "updateCrValues", "updateInfrastructure", "infraInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "validateAzCli", "integration-server-gradle-plugin"})
public class AzureAksHelper
extends OperatorHelper {
    public final void launchCluster() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.name.get()");
        String name = (String)object;
        Object object2 = azureAksProvider.getSkipExisting().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"azureAksProvider.skipExisting.get()");
        boolean skipExisting = (Boolean)object2;
        Object object3 = azureAksProvider.getLocation().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"azureAksProvider.location.get()");
        String location = (String)object3;
        this.validateAzCli();
        this.loginAzCli(azureAksProvider.getAzUsername(), azureAksProvider.getAzPassword());
        this.createResourceGroup(name, location, skipExisting);
        this.createCluster(name, azureAksProvider.getClusterNodeCount(), azureAksProvider.getClusterNodeVmSize(), azureAksProvider.getKubernetesVersion(), skipExisting);
        this.connectToCluster(name);
        InfrastructureInfo kubeContextInfo = this.getKubectlHelper().getCurrentContextInfo();
        Object object4 = azureAksProvider.getStorageClass().getOrElse((Object)name);
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"azureAksProvider.storageClass.getOrElse(name)");
        this.createStorageClass((String)object4);
        this.updateControllerManager();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateInfrastructure(kubeContextInfo);
        this.updateOperatorCrValues();
        this.updateCrValues();
        this.applyYamlFiles();
        this.turnOnLogging();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.createClusterMetadata();
        this.waitForBoot();
        this.turnOffLogging();
    }

    public final void shutdownCluster() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.name.get()");
        String name = (String)object;
        String groupName = this.resourceGroupName(name);
        Object object2 = azureAksProvider.getLocation().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"azureAksProvider.location.get()");
        String location = (String)object2;
        String clusterName = this.aksClusterName(name);
        this.undeployCluster();
        this.getProject().getLogger().lifecycle("Delete resource group {} and AKS cluster {} ", new Object[]{groupName, clusterName});
        this.deleteResourceGroup(groupName, location);
        this.getKubectlHelper().deleteCurrentContext();
        this.logoutAzCli(azureAksProvider.getAzUsername(), azureAksProvider.getAzPassword());
    }

    private final void updateInfrastructure(InfrastructureInfo infraInfo) {
        File file = new File(this.getProviderHomeDir(), "digitalai-deploy/infrastructure.yaml");
        Pair[] pairArray = new Pair[4];
        String string = infraInfo.getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        String string3 = infraInfo.getTlsCert();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].tlsCert", (Object)string3);
        String string4 = infraInfo.getTlsPrivateKey();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].tlsPrivateKey", (Object)string4);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    @NotNull
    public String getProviderHomeDir() {
        return this.getOperatorHomeDir() + "/deploy-operator-azure-aks";
    }

    @Override
    @NotNull
    public AzureAksProvider getProvider() {
        return this.getProfile().getAzureAks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageCla\u2026getProvider().name.get())");
        return this.fileStorageClassName((String)object);
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageCla\u2026getProvider().name.get())");
        return this.diskStorageClassName((String)object);
    }

    @Override
    @NotNull
    public String getFqdn() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getLocation().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"azureAksProvider.location.get()");
        String location = (String)object;
        return this.getHost() + '.' + location + ".cloudapp.azure.com";
    }

    private final void validateAzCli() {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az -v", null, bl, bl2, l, 36, null);
        if (!StringsKt.contains$default((CharSequence)result, (CharSequence)"azure-cli", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("No azure-cli \"az\" in the path. Please verify your installation");
        }
    }

    private final void loginAzCli(String username, String password) {
        if (username != null && password != null) {
            this.getProject().getLogger().lifecycle("Login user");
            long l = 0L;
            boolean bl = false;
            boolean bl2 = false;
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az login -u " + username + " -p " + password, null, bl, bl2, l, 36, null);
        }
    }

    private final void logoutAzCli(String username, String password) {
        if (username != null && password != null) {
            this.getProject().getLogger().lifecycle("Logout user");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az logout", null, false, false, 0L, 44, null);
        }
    }

    private final void createStorageClassFromFile(String storageClassName, String filePath) {
        if (!this.getKubectlHelper().hasStorageClass(storageClassName)) {
            this.getProject().getLogger().lifecycle("Create storage class: {}", new Object[]{storageClassName});
            File azureFileScTemplateFile = this.getTemplate(filePath);
            String azureFileScTemplate = StringsKt.replace$default((String)FilesKt.readText((File)azureFileScTemplateFile, (Charset)Charsets.UTF_8), (String)"{{NAME}}", (String)storageClassName, (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)azureFileScTemplateFile, (String)azureFileScTemplate, null, (int)2, null);
            this.getKubectlHelper().applyFile(azureFileScTemplateFile);
        } else {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing storage class: {}", new Object[]{storageClassName});
        }
    }

    private final void createStorageClass(String name) {
        String fileStorageClassName = this.fileStorageClassName(name);
        this.createStorageClassFromFile(fileStorageClassName, "operator/azure-aks/azure-file-sc.yaml");
        String diskStorageClassName = this.diskStorageClassName(name);
        this.createStorageClassFromFile(diskStorageClassName, "operator/azure-aks/azure-disk-sc.yaml");
        this.getKubectlHelper().setDefaultStorageClass("default", fileStorageClassName);
    }

    private final boolean existsResourceGroup(String groupName, String location) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az group list --query \"[?location=='" + location + "']\" --output tsv | grep " + groupName, null, bl, bl2, l, 36, null);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)groupName, (boolean)false, (int)2, null);
    }

    private final void createResourceGroup(String name, String location, boolean skipExisting) {
        boolean shouldSkipExisting;
        String groupName = this.resourceGroupName(name);
        boolean bl = shouldSkipExisting = skipExisting ? this.existsResourceGroup(groupName, location) : false;
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing resource group: {}", new Object[]{groupName});
        } else {
            this.getProject().getLogger().lifecycle("Create resource group: {}", new Object[]{groupName});
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az group create --name " + groupName + " --location " + location, null, false, false, 0L, 60, null);
        }
    }

    private final void deleteResourceGroup(String groupName, String location) {
        if (this.existsResourceGroup(groupName, location)) {
            this.getProject().getLogger().lifecycle("Delete resource group: {}", new Object[]{groupName});
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az group delete --name " + groupName + " --yes", null, false, false, 0L, 60, null);
        } else {
            this.getProject().getLogger().lifecycle("Skipping delete of the resource group: {}", new Object[]{groupName});
        }
    }

    private final void createCluster(String name, Property<Integer> clusterNodeCount, Property<String> clusterNodeVmSize, Property<String> kubernetesVersion, boolean skipExisting) {
        boolean shouldSkipExisting;
        boolean bl;
        String groupName = this.resourceGroupName(name);
        String clusterName = this.aksClusterName(name);
        if (skipExisting) {
            long l = 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az aks list --output tsv | grep " + clusterName, null, bl2, bl3, l, 36, null);
            bl = StringsKt.contains$default((CharSequence)result, (CharSequence)clusterName, (boolean)false, (int)2, null);
        } else {
            bl = shouldSkipExisting = false;
        }
        if (shouldSkipExisting) {
            this.getProject().getLogger().lifecycle("Skipping creation of the existing AKS cluster: {}", new Object[]{clusterName});
        } else {
            this.getProject().getLogger().lifecycle("Create AKS cluster: {}", new Object[]{clusterName});
            String additions2 = (String)clusterNodeVmSize.map((Transformer)createCluster.additions.1.INSTANCE).getOrElse((Object)"") + (String)kubernetesVersion.map((Transformer)createCluster.additions.2.INSTANCE).getOrElse((Object)"");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az aks create --resource-group " + groupName + " --name " + clusterName + " --node-count " + (Integer)clusterNodeCount.getOrElse((Object)2) + ' ' + "--generate-ssh-keys --enable-addons monitoring " + additions2, null, false, false, 0L, 60, null);
        }
    }

    private final void connectToCluster(String name) {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az aks get-credentials --resource-group " + this.resourceGroupName(name) + " --name " + this.aksClusterName(name) + " --overwrite-existing", null, false, false, 0L, 60, null);
    }

    private final void updateCrValues() {
        File file = new File(this.getProviderHomeDir(), "digitalai-deploy/kubernetes/daideploy_cr.yaml");
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"spec.nginx-ingress-controller.service.annotations", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"service.beta.kubernetes.io/azure-dns-label-name", (Object)this.getHost()))), TuplesKt.to((Object)"spec.ingress.hosts", (Object)new String[]{this.getFqdn()})});
        YamlFileUtil.Companion.overlayFile(file, pairs, false);
    }

    private final String resourceGroupName(String name) {
        return name + "-group";
    }

    private final String aksClusterName(String name) {
        return name;
    }

    private final String diskStorageClassName(String name) {
        return name + "-disk-storage-class";
    }

    private final String fileStorageClassName(String name) {
        return name + "-file-storage-class";
    }

    public AzureAksHelper(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
    }
}

