/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.common.domain.AkkaSecured;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.MqUtil;
import ai.digital.integration.server.common.util.TlsUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.tasks.server.DownloadAndExtractServerDistTask;
import com.fasterxml.jackson.core.TreeNode;
import java.io.File;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007J-\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lai/digital/integration/server/deploy/tasks/server/CentralConfigurationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "createCentralConfigurationFiles", "", "server", "Lai/digital/integration/server/common/domain/Server;", "launch", "mq", "", "", "mqName", "mqPort", "", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/util/Map;", "overlayRepositoryConfig", "serverDir", "taskConfig", "", "project", "Lorg/gradle/api/Project;", "Companion", "integration-server-gradle-plugin"})
public class CentralConfigurationTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "centralConfiguration";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void overlayRepositoryConfig(String serverDir) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Creating custom deploy-repository.yaml");
        File deployRepositoryYaml = new File(serverDir + "/centralConfiguration/deploy-repository.yaml");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        TreeNode treeNode = DbUtil.Companion.dbConfig(project2);
        if (treeNode != null) {
            TreeNode treeNode2 = treeNode;
            boolean bl = false;
            boolean bl2 = false;
            TreeNode config = treeNode2;
            boolean bl3 = false;
            YamlFileUtil.Companion.writeFileValue$default(YamlFileUtil.Companion, deployRepositoryYaml, config, false, 4, null);
        }
        String string = FilesKt.readText((File)deployRepositoryYaml, (Charset)Charsets.UTF_8);
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        String configuredTemplate = StringsKt.replace$default((String)string, (String)"{{DB_PORT}}", (String)String.valueOf(DbUtil.Companion.getPort(project3)), (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)deployRepositoryYaml, (String)configuredTemplate, null, (int)2, null);
    }

    private final void createCentralConfigurationFiles(Server server) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Generating initial central configuration files for server " + server.getName());
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String serverDir = DeployServerUtil.Companion.getServerWorkingDir(project2, server);
        this.overlayRepositoryConfig(serverDir);
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        project3.getLogger().lifecycle("Creating custom deploy-server.yaml");
        boolean bl = false;
        Map serverYaml = new LinkedHashMap();
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        if (DeployServerUtil.Companion.isAkkaSecured(project4)) {
            AkkaSecured secured;
            Project project5 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
            Project project6 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
            AkkaSecured akkaSecured = secured = TlsUtil.Companion.getAkkaSecured(project5, DeployServerUtil.Companion.getServerWorkingDir(project6));
            if (akkaSecured != null) {
                AkkaSecured akkaSecured2 = akkaSecured;
                boolean bl2 = false;
                boolean bl3 = false;
                AkkaSecured sec = akkaSecured2;
                boolean bl4 = false;
                Map<String, AkkaSecured.KeyMeta> map2 = sec.getKeys();
                StringBuilder stringBuilder = new StringBuilder().append("akka_ssl_master_");
                Project project7 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
                AkkaSecured.KeyMeta key = map2.get(stringBuilder.append(DeployServerUtil.Companion.getServer(project7).getName()).toString());
                if (key != null) {
                    serverYaml.putAll(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.server.ssl.enabled", (Object)true), TuplesKt.to((Object)"deploy.server.ssl.key-store", (Object)key.keyStoreFile().getAbsolutePath()), TuplesKt.to((Object)"deploy.server.ssl.key-store-password", (Object)key.getKeyStorePassword()), TuplesKt.to((Object)"deploy.server.ssl.trust-store", (Object)sec.trustStoreFile().getAbsolutePath()), TuplesKt.to((Object)"deploy.server.ssl.trust-store-password", (Object)sec.getTruststorePassword())}));
                    if (Intrinsics.areEqual((Object)"jks", (Object)"pkcs12") ^ true) {
                        serverYaml.put("deploy.server.ssl.key-password", key.getKeyPassword());
                    }
                }
            }
        }
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, new File(serverDir + "/centralConfiguration/deploy-server.yaml"), serverYaml, false, 4, null);
        Project project8 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
        project8.getLogger().lifecycle("Creating custom deploy-task.yaml");
        File file = new File(serverDir + "/centralConfiguration/deploy-task.yaml");
        Project project9 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project9, (String)"project");
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, this.taskConfig(project9), false, 4, null);
        Project project10 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project10, (String)"project");
        if (SatelliteUtil.Companion.hasSatellites(project10)) {
            Project project11 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project11, (String)"project");
            project11.getLogger().lifecycle("Creating custom deploy-satellite.yaml");
            YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, new File(serverDir + "/centralConfiguration/deploy-satellite.yaml"), MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.satellite.enabled", (Object)true)}), false, 4, null);
        }
    }

    private final Map<String, Object> taskConfig(Project project) {
        Map<String, String> mqDetail = this.mq(MqUtil.Companion.mqName(project), MqUtil.Companion.mqPort(project));
        Map config = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.task.queue.name", (Object)"xld-tasks-queue"), TuplesKt.to((Object)"deploy.task.queue.archive-queue-name", (Object)"xld-archive-queue")});
        config.putAll(WorkerUtil.Companion.hasWorkers(project) ? MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.task.in-process-worker", (Object)"false"), TuplesKt.to((Object)"deploy.task.queue.external.jms-driver-classname", (Object)String.valueOf(mqDetail.get("jms-driver-classname"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-password", (Object)String.valueOf(mqDetail.get("jms-password"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-url", (Object)String.valueOf(mqDetail.get("jms-url"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-username", (Object)String.valueOf(mqDetail.get("jms-username"))), TuplesKt.to((Object)"akka.io.dns.resolver", (Object)"inet-address")}) : MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.task.in-process-worker", (Object)"true")}));
        return config;
    }

    private final Map<String, String> mq(String mqName, Integer mqPort) {
        boolean hasPort = mqPort != null && mqPort > 0;
        Map rabbitMq = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"jms-driver-classname", (Object)"com.rabbitmq.jms.admin.RMQConnectionFactory"), TuplesKt.to((Object)"jms-password", (Object)"guest"), TuplesKt.to((Object)"jms-url", (Object)("amqp://localhost:" + (hasPort ? mqPort : "5672"))), TuplesKt.to((Object)"jms-username", (Object)"guest")});
        Map activeMq = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"jms-driver-classname", (Object)"org.apache.activemq.ActiveMQConnectionFactory"), TuplesKt.to((Object)"jms-password", (Object)"admin"), TuplesKt.to((Object)"jms-url", (Object)("tcp://localhost:" + (hasPort ? mqPort : "61616"))), TuplesKt.to((Object)"jms-username", (Object)"admin")});
        return Intrinsics.areEqual((Object)"activemq", (Object)mqName) ? activeMq : rabbitMq;
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Iterable $this$forEach$iv = DeployServerUtil.Companion.getServers(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            if (!(server.numericVersion() >= 10.2)) continue;
            this.createCentralConfigurationFiles(server);
        }
    }

    public CentralConfigurationTask() {
        this.dependsOn(new Object[]{DownloadAndExtractServerDistTask.Companion.getNAME()});
        this.setGroup("Integration Server");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/CentralConfigurationTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

