/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/internals/ShutdownUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class ShutdownUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/deploy/internals/ShutdownUtil$Companion;", "", "()V", "shutdownServer", "", "project", "Lorg/gradle/api/Project;", "waitForShutdown", "integration-server-gradle-plugin"})
    public static final class Companion {
        private final void waitForShutdown(Project project) {
            Server server = DeployServerUtil.Companion.getServer(project);
            int triesLeft = server.getPingTotalTries();
            boolean success = false;
            while (triesLeft > 0 && !success) {
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HTTPUtil.Companion.doRequest(EntryPointUrlUtil.Companion.composeUrl$default(EntryPointUrlUtil.Companion, project, server.getContextRoot(), false, 4, null)).POST(HttpRequest.BodyPublishers.noBody()).build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    project.getLogger().lifecycle("Waiting " + server.getPingRetrySleepTime() + " seconds for shutdown. (" + triesLeft + ')');
                    TimeUnit.SECONDS.sleep(server.getPingRetrySleepTime());
                    if (response.statusCode() == 200) continue;
                    project.getLogger().lifecycle("XL Deploy server successfully shutdown");
                    success = true;
                }
                catch (Exception ignored) {
                    project.getLogger().lifecycle("XL Deploy server successfully shutdown.");
                    success = true;
                    break;
                }
            }
            if (!success) {
                throw (Throwable)new GradleException("Server failed to stop");
            }
        }

        public final void shutdownServer(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Server server = DeployServerUtil.Companion.getServer(project);
            try {
                int port = server.getHttpPort();
                project.getLogger().lifecycle("Trying to shutdown integration server on port " + port);
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HTTPUtil.Companion.doRequest(EntryPointUrlUtil.Companion.composeUrl$default(EntryPointUrlUtil.Companion, project, "/deployit/server/shutdown", false, 4, null)).POST(HttpRequest.BodyPublishers.noBody()).build();
                client.send(request, HttpResponse.BodyHandlers.ofString());
                this.waitForShutdown(project);
                project.getLogger().lifecycle("Integration server at port " + port + " is now shutdown");
            }
            catch (Exception ignored) {
                project.getLogger().lifecycle("Integration server on port " + server.getHttpPort() + " is not running");
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

