/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.kube.scanning;

import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.KubeScanningUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/KubeAwsScannerFinalizerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "deleteDockerImage", "", "deleteEksJob", "deleteRepository", "dockerLogout", "launch", "Companion", "integration-server-gradle-plugin"})
public class KubeAwsScannerFinalizerTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "KubeAwsScannerFinalizer";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void launch() {
        this.dockerLogout();
        this.deleteRepository();
        this.deleteEksJob();
        this.deleteDockerImage();
    }

    private final void deleteEksJob() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KubeCtlHelper kubeCtlHelper = KubeScanningUtil.Companion.getKubectlHelper(project);
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        kubeCtlHelper.deleteFile(new File(stringBuilder.append(KubeScanningUtil.Companion.getKubeBenchDir(project2)).append("/job-eks.yaml").toString()));
    }

    private final void dockerLogout() {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "docker logout", null, KubeScanningUtil.Companion.getKubeScanner(project2).getLogOutput(), false, 0L, 52, null);
    }

    private final void deleteRepository() {
        Project project = this.getProject();
        StringBuilder stringBuilder = new StringBuilder().append("aws ecr --region ");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String string = stringBuilder.append(KubeScanningUtil.Companion.getRegion(project2)).append(" delete-repository --repository-name k8s/kube-bench --force").toString();
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project3).getLogOutput(), false, 0L, 52, null);
    }

    private final void deleteDockerImage() {
        Project project = this.getProject();
        StringBuilder stringBuilder = new StringBuilder().append("docker image rm ");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        StringBuilder stringBuilder2 = stringBuilder.append(KubeScanningUtil.Companion.getAWSAccountId(project2)).append("/k8s/kube-bench:");
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        String string = stringBuilder2.append(KubeScanningUtil.Companion.getKubeScanner(project3).getKubeBenchTagVersion()).toString();
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project4).getLogOutput(), false, 0L, 52, null);
        Project project5 = this.getProject();
        StringBuilder stringBuilder3 = new StringBuilder().append("docker image rm k8s/kube-bench:");
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        String string2 = stringBuilder3.append(KubeScanningUtil.Companion.getKubeScanner(project6).getKubeBenchTagVersion()).toString();
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project5, string2, null, KubeScanningUtil.Companion.getKubeScanner(project7).getLogOutput(), false, 0L, 52, null);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/KubeAwsScannerFinalizerTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

