/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010\u001a\u001a\u00020\bH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0002J\u000e\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bJ\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0002J\u0018\u0010'\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0002J\u000e\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\bJ\u0016\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bJ\u001e\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u000202R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00063"}, d2={"Lai/digital/integration/server/common/util/KubeCtlHelper;", "", "project", "Lorg/gradle/api/Project;", "isOpenShift", "", "(Lorg/gradle/api/Project;Z)V", "command", "", "getCommand", "()Ljava/lang/String;", "()Z", "getProject", "()Lorg/gradle/api/Project;", "applyFile", "", "file", "Ljava/io/File;", "deleteAllPvcs", "deleteCurrentContext", "getClusterCertificateAuthorityData", "clusterName", "getClusterServer", "getContextCluster", "contextName", "getContextUser", "getCurrentContext", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "getIngresHost", "ingressName", "getNameAndGrep", "params", "grepFor", "getServiceExternalIp", "serviceName", "getUserClientCertificateData", "userName", "getUserClientKeyData", "getWithPath", "jsonpath", "hasStorageClass", "storageClass", "setDefaultStorageClass", "oldDefaultStorageClass", "newDefaultStorageClass", "wait", "resource", "condition", "timeoutSeconds", "", "integration-server-gradle-plugin"})
public class KubeCtlHelper {
    @NotNull
    private final String command;
    @NotNull
    private final Project project;
    private final boolean isOpenShift;

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    public final void applyFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " apply -f " + file.getAbsolutePath(), null, false, false, 0L, 60, null);
    }

    public final boolean wait(@NotNull String resource, @NotNull String condition, int timeoutSeconds) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        Intrinsics.checkParameterIsNotNull((Object)condition, (String)"condition");
        this.project.getLogger().lifecycle("Waiting for resource " + resource + " to be " + condition);
        long expectedEndTime = System.currentTimeMillis() + (long)(timeoutSeconds * 1000);
        while (expectedEndTime > System.currentTimeMillis()) {
            String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " wait --for condition=" + condition + " --timeout=" + timeoutSeconds + "s " + resource, null, false, false, 0L, 44, null);
            if (StringsKt.contains$default((CharSequence)result, (CharSequence)"condition met", (boolean)false, (int)2, null)) {
                return true;
            }
            Thread.sleep(1000L);
        }
        return false;
    }

    public final void setDefaultStorageClass(@NotNull String oldDefaultStorageClass, @NotNull String newDefaultStorageClass) {
        Intrinsics.checkParameterIsNotNull((Object)oldDefaultStorageClass, (String)"oldDefaultStorageClass");
        Intrinsics.checkParameterIsNotNull((Object)newDefaultStorageClass, (String)"newDefaultStorageClass");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, ' ' + this.command + " patch storageclass " + newDefaultStorageClass + " -p '{\"metadata\": {\"annotations\":{\"storageclass.kubernetes.io/is-default-class\":\"true\"}}}'", null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, ' ' + this.command + " patch storageclass " + oldDefaultStorageClass + " -p '{\"metadata\": {\"annotations\":{\"storageclass.kubernetes.io/is-default-class\":\"false\"}}}'", null, false, false, 0L, 60, null);
    }

    public final boolean hasStorageClass(@NotNull String storageClass) {
        Intrinsics.checkParameterIsNotNull((Object)storageClass, (String)"storageClass");
        String result = this.getNameAndGrep("storageclass", storageClass);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)storageClass, (boolean)false, (int)2, null);
    }

    @NotNull
    public final InfrastructureInfo getCurrentContextInfo() {
        String context = this.getCurrentContext();
        String cluster = this.getContextCluster(context);
        String user = this.getContextUser(context);
        return new InfrastructureInfo(cluster, user, this.getClusterServer(cluster), this.getClusterCertificateAuthorityData(cluster), this.getUserClientCertificateData(user), this.getUserClientKeyData(user));
    }

    public final void deleteCurrentContext() {
        String context = this.getCurrentContext();
        String cluster = this.getContextCluster(context);
        String user = this.getContextUser(context);
        this.project.getLogger().info("Delete current context {} with related cluster {} and user {} information", new Object[]{context, cluster, user});
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config delete-context " + context, null, false, false, 0L, 44, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config delete-user " + user, null, false, false, 0L, 44, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config delete-cluster " + cluster, null, false, false, 0L, 44, null);
    }

    public final void deleteAllPvcs() {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " delete pvc --all", null, false, false, 0L, 44, null);
    }

    @NotNull
    public final String getIngresHost(@NotNull String ingressName) {
        Intrinsics.checkParameterIsNotNull((Object)ingressName, (String)"ingressName");
        return this.getWithPath("ing " + ingressName, "{.items[*].spec.rules[*].host}");
    }

    @NotNull
    public final String getServiceExternalIp(@NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        return this.getWithPath("service " + serviceName, "{.status.loadBalancer.ingress[*].ip}");
    }

    private final String getCurrentContext() {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config current-context", null, false, false, 0L, 52, null);
    }

    private final String getContextCluster(String contextName) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config view -o jsonpath='{.contexts[?(@.name == \"" + contextName + "\")].context.cluster}' --raw", null, false, false, 0L, 52, null);
    }

    private final String getContextUser(String contextName) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config view -o jsonpath='{.contexts[?(@.name == \"" + contextName + "\")].context.user}' --raw", null, false, false, 0L, 52, null);
    }

    private final String getClusterServer(String clusterName) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config view -o jsonpath='{.clusters[?(@.name == \"" + clusterName + "\")].cluster.server}' --raw", null, false, false, 0L, 52, null);
    }

    private final String getClusterCertificateAuthorityData(String clusterName) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config view -o jsonpath='{.clusters[?(@.name == \"" + clusterName + "\")].cluster.certificate-authority-data}' --raw", null, false, false, 0L, 52, null);
    }

    private final String getUserClientKeyData(String userName) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config view -o jsonpath='{.users[?(@.name == \"" + userName + "\")].user.client-key-data}' --raw", null, false, false, 0L, 52, null);
    }

    private final String getUserClientCertificateData(String userName) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config view -o jsonpath='{.users[?(@.name == \"" + userName + "\")].user.client-certificate-data}' --raw", null, false, false, 0L, 52, null);
    }

    private final String getNameAndGrep(String params2, String grepFor) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " get " + params2 + " -o name | grep " + grepFor, null, bl, bl2, l, 36, null);
    }

    private final String getWithPath(String command, String jsonpath) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, command + " get " + command + " -o \"jsonpath=" + jsonpath + '\"', null, false, false, 0L, 60, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isOpenShift() {
        return this.isOpenShift;
    }

    public KubeCtlHelper(@NotNull Project project, boolean isOpenShift) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.isOpenShift = isOpenShift;
        this.command = this.isOpenShift ? "oc" : "kubectl";
    }

    public /* synthetic */ KubeCtlHelper(Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(project, bl);
    }
}

